/*
 * Decompiled with CFR 0.152.
 */
package experiments.thesis;

import genetic.fitness.Fitness;
import java.util.Vector;
import processing.core.PApplet;
import processing.core.PImage;
import strategymap.StrategySketch;
import strategymap.genetic.StrategySketchEmbryogeny;
import strategymap.genetic.StrategySketchGene;
import strategymap.genetic.fitness.FeasibleFitness;
import strategymap.genetic.fitness.InfeasibleFitness;
import strategymap.visualization.MapVisualizer;
import util.collections.ParameterCollection;
import util.statics.LogManager;
import util.statics.StatisticUtils;

public class StrategyGame_Random {
    final int targetSize = 50000;

    public void experiment(Fitness ifn, int mapSizeX, int mapSizeY, ParameterCollection params, String folderName) {
        int i;
        PApplet p = new PApplet();
        Vector<StrategySketch> allFeasibleGenes = new Vector<StrategySketch>();
        while (allFeasibleGenes.size() < 50000) {
            StrategySketchGene genotype = new StrategySketchGene(mapSizeX, mapSizeY, params);
            genotype.randomize();
            StrategySketchEmbryogeny sme = new StrategySketchEmbryogeny(mapSizeX, mapSizeY);
            StrategySketch entry = sme.createPhenotype(genotype.getGenotype());
            if (ifn.evaluate((Object)entry) != 0.0) continue;
            allFeasibleGenes.add(entry);
            PImage img = MapVisualizer.renderThumbnail(p, entry).getImage();
            img.save(folderName + "/" + allFeasibleGenes.size() + ".png");
            if (allFeasibleGenes.size() % 100 != 0) continue;
            System.out.print(".");
        }
        System.out.print("\n\n");
        Vector<FeasibleFitness> fitnesses = new Vector<FeasibleFitness>();
        for (int i2 = 0; i2 < FeasibleFitness.labels.length; ++i2) {
            fitnesses.add(new FeasibleFitness(i2));
        }
        fitnesses.add(new FeasibleFitness(0.5, 0.5, 0.0, 0.0, 0.0, 0.0));
        fitnesses.add(new FeasibleFitness(0.0, 0.0, 0.5, 0.5, 0.0, 0.0));
        fitnesses.add(new FeasibleFitness(0.0, 0.0, 0.0, 0.0, 0.5, 0.5));
        fitnesses.add(new FeasibleFitness(0.3333333333333333, 0.0, 0.3333333333333333, 0.0, 0.3333333333333333, 0.0));
        fitnesses.add(new FeasibleFitness(0.0, 0.3333333333333333, 0.0, 0.3333333333333333, 0.0, 0.3333333333333333));
        fitnesses.add(new FeasibleFitness(0.16666666666666666, 0.16666666666666666, 0.16666666666666666, 0.16666666666666666, 0.16666666666666666, 0.16666666666666666));
        String[] report = new String[fitnesses.size() * 4 + 2];
        for (int i3 = 0; i3 < report.length; ++i3) {
            report[i3] = "";
        }
        String[] allValuesReport = new String[fitnesses.size()];
        for (i = 0; i < allValuesReport.length; ++i) {
            allValuesReport[i] = "";
        }
        for (int j = 0; j < fitnesses.size(); ++j) {
            double[] values = new double[allFeasibleGenes.size()];
            for (int i4 = 0; i4 < allFeasibleGenes.size(); ++i4) {
                values[i4] = ((Fitness)fitnesses.get(j)).evaluate(allFeasibleGenes.get(i4));
            }
            double max = StatisticUtils.maximum(values);
            double min = StatisticUtils.minimum(values);
            double avg = StatisticUtils.average(values);
            double sdev = StatisticUtils.standardDeviation(values);
            report[j * 4] = "" + ((Fitness)fitnesses.get(j)).getLabel() + ": " + avg + " (" + sdev + ")";
            report[j * 4 + 1] = "avg " + ((Fitness)fitnesses.get(j)).getLabel() + ": " + avg;
            report[j * 4 + 2] = "max " + ((Fitness)fitnesses.get(j)).getLabel() + ": " + max;
            report[j * 4 + 3] = "min " + ((Fitness)fitnesses.get(j)).getLabel() + ": " + min;
            int n = fitnesses.size() * 4;
            report[n] = report[n] + ((Fitness)fitnesses.get(j)).getLabel() + " & ";
            int n2 = fitnesses.size() * 4 + 1;
            report[n2] = report[n2] + "" + String.format("%.3f", avg) + " (" + String.format("%.3f", sdev) + ")" + " & ";
            for (int i5 = 0; i5 < values.length; ++i5) {
                int n3 = j;
                allValuesReport[n3] = allValuesReport[n3] + values[i5] + ";";
            }
        }
        for (i = 0; i < report.length; ++i) {
            System.out.println(report[i]);
        }
        p.saveStrings(folderName + "/" + "report.txt", report);
        p.saveStrings(folderName + "/" + "allValuesReport.txt", allValuesReport);
    }

    public static void set_experiment(String name, int mapSizeX, int mapSizeY, int minBases, int maxBases, int minResources, int maxResources) {
        LogManager.reset();
        StrategyGame_Random smg = new StrategyGame_Random();
        ParameterCollection params = new ParameterCollection();
        params.setParameter("normalizeFitness", "1");
        params.setParameter("steadyPercentage", "1");
        params.setParameter("repair", "1");
        params.setParameter("enforceMinFeasiblePopulation", "0.5");
        params.setParameter("crossoverPoints", "2");
        params.setParameter("mapSizeX", "" + mapSizeX);
        params.setParameter("mapSizeY", "" + mapSizeY);
        params.setParameter("genotypeMinResources", "" + minResources);
        params.setParameter("genotypeMaxResources", "" + maxResources);
        params.setParameter("genotypeMinBases", "" + minBases);
        params.setParameter("genotypeMaxBases", "" + maxBases);
        params.setParameter("mutateAnyProbability", "1");
        params.setParameter("mutateOnlyProbability", "0");
        params.setParameter("mutateTile", "5");
        params.setParameter("mutateBase", "0");
        params.setParameter("mutateResource", "0");
        params.setParameter("mutateShift", "5");
        params.setParameter("mutateDiagonal", "0");
        params.setParameter("mutateTileMinNumber", "" + (int)(0.05 * (double)mapSizeX * (double)mapSizeY));
        params.setParameter("mutateTileMaxNumber", "" + (int)(0.2 * (double)mapSizeX * (double)mapSizeY));
        InfeasibleFitness ifn = new InfeasibleFitness(minBases, maxBases, minResources, maxResources);
        smg.experiment((Fitness)ifn, mapSizeX, mapSizeY, params, name);
    }

    public static void main(String[] args) {
        System.out.print("Small:\n");
        StrategyGame_Random.set_experiment("experiment/thesis/strategy/random/small", 8, 8, 2, 2, 4, 10);
        System.out.print("Medium:\n");
        StrategyGame_Random.set_experiment("experiment/thesis/strategy/random/medium", 12, 12, 4, 4, 8, 20);
        System.out.print("Large:\n");
        StrategyGame_Random.set_experiment("experiment/thesis/strategy/random/large", 16, 16, 2, 10, 4, 30);
    }
}

