/*
 * Decompiled with CFR 0.152.
 */
package experiments.tileconstraints;

import genetic.fitness.Fitness;
import genetic.fitness.WeightedFitness;
import strategymap.StrategySketch;
import strategymap.constraints.TileConstraints;
import util.image.processing.Thresholding;
import util.math2d.Matrix2D;

public class ConstraintFitness
extends WeightedFitness {
    int totalConstraints = 0;

    public ConstraintFitness(TileConstraints constraints) {
        this.totalConstraints += constraints.countConstraints(TileConstraints.Type.CHOKEPOINT);
        this.totalConstraints += constraints.countConstraints(TileConstraints.Type.DEADEND);
        this.totalConstraints += constraints.countConstraints(TileConstraints.Type.OPENAREA);
        this.totalConstraints += constraints.countConstraints(TileConstraints.Type.SAFESPACE);
        this.totalConstraints += constraints.countConstraints(TileConstraints.Type.UNSAFESPACE);
        this.add(1.0, new ChokePointFitness(constraints, this.totalConstraints));
        this.add(1.0, new DeadEndFitness(constraints, this.totalConstraints));
        this.add(1.0, new OpenAreaFitness(constraints, this.totalConstraints));
        this.add(1.0, new SafeSpaceFitness(constraints, this.totalConstraints, 0.35f));
    }

    class SafeSpaceFitness
    extends TileFidelityFitness {
        float minSafety;

        public SafeSpaceFitness(TileConstraints constraints, int totalConstraints, float minSafety) {
            super(constraints, totalConstraints);
            this.minSafety = minSafety;
        }

        @Override
        public double evaluateSpecific(StrategySketch phenotype) {
            boolean[][] safeAreas = new boolean[phenotype.getMapSizeX()][phenotype.getMapSizeY()];
            for (int i = 0; i < phenotype.getBaseLength(); ++i) {
                safeAreas = Matrix2D.union(safeAreas, Thresholding.getArrayAboveValue(phenotype.getPaths().getSafetyMatrix(i), this.minSafety));
            }
            return this.evaluateSafetyTable(safeAreas);
        }

        protected double evaluateSafetyTable(boolean[][] lookupTable) {
            int successCount = 0;
            int allCount = 0;
            for (int x = 0; x < lookupTable.length; ++x) {
                for (int y = 0; y < lookupTable[0].length; ++y) {
                    if (this.constraints.hasConstraint(x, y, TileConstraints.Type.SAFESPACE)) {
                        if (lookupTable[x][y]) {
                            ++successCount;
                        }
                        ++allCount;
                        continue;
                    }
                    if (!this.constraints.hasConstraint(x, y, TileConstraints.Type.UNSAFESPACE)) continue;
                    if (!lookupTable[x][y]) {
                        ++successCount;
                    }
                    ++allCount;
                }
            }
            if (allCount == 0 || allCount == successCount) {
                return 0.0;
            }
            return (double)successCount / (double)this.totalConstraints;
        }
    }

    class UnusedSpaceFitness
    extends TileFidelityFitness {
        public UnusedSpaceFitness(TileConstraints constraints, int totalConstraints) {
            super(constraints, totalConstraints);
        }

        @Override
        public double evaluateSpecific(StrategySketch phenotype) {
            return this.evaluateLookupTable(phenotype.getPaths().getUnusedSpaces(), TileConstraints.Type.UNUSEDSPACE);
        }
    }

    class OpenAreaFitness
    extends TileFidelityFitness {
        public OpenAreaFitness(TileConstraints constraints, int totalConstraints) {
            super(constraints, totalConstraints);
        }

        @Override
        public double evaluateSpecific(StrategySketch phenotype) {
            return this.evaluateLookupTable(phenotype.getPaths().getOpenAreas(), TileConstraints.Type.OPENAREA);
        }
    }

    class DeadEndFitness
    extends TileFidelityFitness {
        public DeadEndFitness(TileConstraints constraints, int totalConstraints) {
            super(constraints, totalConstraints);
        }

        @Override
        public double evaluateSpecific(StrategySketch phenotype) {
            return this.evaluateLookupTable(phenotype.getPaths().getDeadEnds(), TileConstraints.Type.DEADEND);
        }
    }

    class ChokePointFitness
    extends TileFidelityFitness {
        public ChokePointFitness(TileConstraints constraints, int totalConstraints) {
            super(constraints, totalConstraints);
        }

        @Override
        public double evaluateSpecific(StrategySketch phenotype) {
            return this.evaluateLookupTable(phenotype.getPaths().getChokePoints(), TileConstraints.Type.CHOKEPOINT);
        }
    }

    abstract class TileFidelityFitness
    extends Fitness<StrategySketch> {
        TileConstraints constraints;
        int totalConstraints;

        public TileFidelityFitness(TileConstraints constraints, int totalConstraints) {
            this.constraints = constraints;
            this.totalConstraints = totalConstraints;
        }

        protected double evaluateLookupTable(boolean[][] lookupTable, TileConstraints.Type constraint) {
            int successCount = 0;
            int allCount = 0;
            for (int x = 0; x < lookupTable.length; ++x) {
                for (int y = 0; y < lookupTable[0].length; ++y) {
                    if (!this.constraints.hasConstraint(x, y, constraint)) continue;
                    if (lookupTable[x][y]) {
                        ++successCount;
                    }
                    ++allCount;
                }
            }
            if (allCount == 0 || allCount == successCount) {
                return 0.0;
            }
            return (double)successCount / (double)this.totalConstraints;
        }

        public abstract double evaluateSpecific(StrategySketch var1);
    }
}

