/*
 * Decompiled with CFR 0.152.
 */
package experiments.tileconstraints;

import experiments.tileconstraints.ConstraintFitness;
import genetic.Embryogeny;
import genetic.FI2PopTrainer;
import genetic.GeneticAlgorithm;
import genetic.fitness.Fitness;
import genetic.fitness.WeightedFitness;
import genetic.logger.BestFitnessLogger;
import genetic.logger.SingleFitnessLogger;
import processing.core.PApplet;
import processing.core.PImage;
import strategymap.StrategySketch;
import strategymap.constraints.TileConstraints;
import strategymap.genetic.StrategySketchEmbryogeny;
import strategymap.genetic.StrategySketchGene;
import strategymap.genetic.StrategySketchGeneticAlgorithm;
import strategymap.genetic.fitness.InfeasibleFitness;
import strategymap.visualization.MapVisualizer;
import util.collections.ParameterCollection;
import util.statics.LogManager;

public class Experiment_FI2pop {
    static TrainingMode mode = TrainingMode.RANDOMGENES;
    static int sampleNumber = 8;
    static int adjustmentIteration = 10;
    static int intervalNumber = 10;
    final int totalRuns = 10;
    final int genPerInterval = 1;

    public void experiment(WeightedFitness sfn, Fitness ifn, int mapSizeX, int mapSizeY, ParameterCollection params, String name) {
        String file = name + "/" + sfn.getLabel() + "/";
        PApplet p = new PApplet();
        int intervals = intervalNumber * 1 * adjustmentIteration + 1;
        SingleFitnessLogger logger = new SingleFitnessLogger(intervals, 10, (Fitness)sfn);
        BestFitnessLogger bLogger = new BestFitnessLogger(intervals, 10, sfn);
        for (int r = 1; r <= 10; ++r) {
            StrategySketchEmbryogeny sme = new StrategySketchEmbryogeny(mapSizeX, mapSizeY);
            StrategySketchGeneticAlgorithm ga = new StrategySketchGeneticAlgorithm(params);
            StrategySketchGeneticAlgorithm iga = new StrategySketchGeneticAlgorithm(params);
            FI2PopTrainer gTrainer = new FI2PopTrainer((Fitness)sfn, ifn, (Embryogeny)sme, (GeneticAlgorithm)ga, (GeneticAlgorithm)iga, params);
            gTrainer.shufflePopulations();
            gTrainer.setLogID(file + r + "/log");
            gTrainer.evaluateParents();
            gTrainer.setLogID(file + r + "/log");
            LogManager.addLogfile("MapOutput" + sfn.getLabel() + "_" + r, file + r + "/geneticalgorithm_map.log");
            for (int i = 0; i < intervals; ++i) {
                logger.storeGeneration(i, r, gTrainer.getFeasibleTrainer());
                bLogger.storeGeneration(i, r, gTrainer.getFeasibleTrainer());
                StrategySketchGene best = (StrategySketchGene)gTrainer.getBestFeasibleIndividual();
                if (best != null && i * 1 % 10 == 0) {
                    StrategySketch im = sme.createPhenotype(best.getGenotype());
                    PImage img = MapVisualizer.renderThumbnail(p, im, 80, 80).getImage();
                    img.save(file + r + "/bestIndividual" + i * 1 + ".png");
                    System.out.println(sfn.getLabel() + " (" + i * 1 + ") " + gTrainer.getFeasibleTrainer().getMaxFitness());
                }
                if (i >= intervals) continue;
                gTrainer.train(1);
            }
            logger.writeRun(r, file);
            bLogger.writeRun(r, file);
        }
        logger.writeAllProgress(file);
        bLogger.writeAllProgress(file);
    }

    public static void set_experiment(String name, int mapSizeX, int mapSizeY, int minBases, int maxBases, int minResources, int maxResources, int population) {
        LogManager.reset();
        Experiment_FI2pop smg = new Experiment_FI2pop();
        ParameterCollection params = new ParameterCollection();
        params.setParameter("population", population);
        params.setParameter("maxGenerations", "500");
        params.setParameter("normalizeFitness", "1");
        params.setParameter("steadyPercentage", "1");
        params.setParameter("crossoverPoints", "2");
        params.setParameter("mapSizeX", "" + mapSizeX);
        params.setParameter("mapSizeY", "" + mapSizeY);
        params.setParameter("genotypeMinResources", "" + minResources);
        params.setParameter("genotypeMaxResources", "" + maxResources);
        params.setParameter("genotypeMinBases", "" + minBases);
        params.setParameter("genotypeMaxBases", "" + maxBases);
        params.setParameter("mutateAnyProbability", "5");
        params.setParameter("mutateOnlyProbability", "1");
        params.setParameter("mutateTile", "5");
        params.setParameter("mutateBase", "0");
        params.setParameter("mutateResource", "1");
        params.setParameter("mutateShift", "15");
        params.setParameter("mutateDiagonal", "10");
        params.setParameter("mutateTileMinNumber", "2");
        params.setParameter("mutateTileMaxNumber", "6");
        InfeasibleFitness ifn = new InfeasibleFitness(minBases, maxBases, minResources, maxResources);
        TileConstraints tc = new TileConstraints(mapSizeX, mapSizeY);
        tc.addConstraint(2, 2, TileConstraints.Type.CHOKEPOINT);
        tc.addConstraint(5, 5, TileConstraints.Type.CHOKEPOINT);
        tc.addConstraint(3, 3, TileConstraints.Type.UNSAFESPACE);
        tc.addConstraint(3, 4, TileConstraints.Type.UNSAFESPACE);
        tc.addConstraint(4, 3, TileConstraints.Type.UNSAFESPACE);
        tc.addConstraint(4, 4, TileConstraints.Type.UNSAFESPACE);
        ConstraintFitness tfn = new ConstraintFitness(tc);
        tfn.setLabel("2Chokepoints+4UnsafeArea");
        smg.experiment(tfn, (Fitness)ifn, mapSizeX, mapSizeY, params, name);
    }

    public static void main(String[] args) {
        Experiment_FI2pop.set_experiment("exp_constraints/2", 8, 8, 2, 2, 4, 10, 100);
    }

    public static enum TrainingMode {
        RANDOMGENES,
        DIFFERENTGENES,
        SCALEDGENES;

    }
}

