/*
 * Decompiled with CFR 0.152.
 */
package fps.genetic.fitness;

import dungeon.Dungeon;
import genetic.fitness.Fitness;
import genetic.fitness.WeightedFitness;

public class InfeasibleFitness
extends WeightedFitness<Dungeon> {
    public InfeasibleFitness(int minExits, int maxExits, int minMonsters, int maxMonsters, int minRewards, int maxRewards) {
        this.add(-0.16666666666666666, new ExitsFitness(minExits, maxExits));
        this.add(-0.16666666666666666, new MonstersFitness(minMonsters, maxMonsters));
        this.add(-0.16666666666666666, new RewardsFitness(minRewards, maxRewards));
        this.add(-0.16666666666666666, new ExitsReachabilityFitness());
        this.add(-0.16666666666666666, new MonstersReachabilityFitness());
        this.add(-0.16666666666666666, new RewardsReachabilityFitness());
        this.label = "infeasibility";
    }

    class RewardsReachabilityFitness
    extends Fitness<Dungeon> {
        RewardsReachabilityFitness() {
        }

        public double evaluateSpecific(Dungeon phenotype) {
            int monsterRewardsPairs = phenotype.getMonsterLength() * phenotype.getRewardLength();
            if (monsterRewardsPairs == 0) {
                return 0.0;
            }
            double result = (double)(monsterRewardsPairs - phenotype.getPaths().getMonster_rewardPathLength()) / (double)monsterRewardsPairs;
            return result;
        }
    }

    class MonstersReachabilityFitness
    extends Fitness<Dungeon> {
        MonstersReachabilityFitness() {
        }

        public double evaluateSpecific(Dungeon phenotype) {
            int exitMonsterPairs = phenotype.getExitLength() * phenotype.getMonsterLength();
            if (exitMonsterPairs == 0) {
                return 0.0;
            }
            double result = (double)(exitMonsterPairs - phenotype.getPaths().getExit_monsterPathLength()) / (double)exitMonsterPairs;
            return result;
        }
    }

    class ExitsReachabilityFitness
    extends Fitness<Dungeon> {
        ExitsReachabilityFitness() {
        }

        public double evaluateSpecific(Dungeon phenotype) {
            if (phenotype.getExitLength() <= 1) {
                return 0.0;
            }
            int exitPairs = phenotype.getExitLength() * (phenotype.getExitLength() - 1) / 2;
            double result = (double)(exitPairs - phenotype.getPaths().getExitPathLength()) / (double)exitPairs;
            return result;
        }
    }

    class RewardsFitness
    extends Fitness<Dungeon> {
        final int minValue;
        final int maxValue;

        public RewardsFitness(int minValue, int maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public double evaluateSpecific(Dungeon phenotype) {
            double result = 0.0;
            int value = phenotype.getRewardLength();
            if (value > this.maxValue) {
                result = (double)(value - this.maxValue) / (double)this.maxValue;
            } else if (value < this.minValue) {
                result = (double)(this.minValue - value) / (double)this.minValue;
            }
            return result;
        }
    }

    class MonstersFitness
    extends Fitness<Dungeon> {
        final int minValue;
        final int maxValue;

        public MonstersFitness(int minValue, int maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public double evaluateSpecific(Dungeon phenotype) {
            double result = 0.0;
            int value = phenotype.getMonsterLength();
            if (value > this.maxValue) {
                result = (double)(value - this.maxValue) / (double)this.maxValue;
            } else if (value < this.minValue) {
                result = (double)(this.minValue - value) / (double)this.minValue;
            }
            return result;
        }
    }

    class ExitsFitness
    extends Fitness<Dungeon> {
        final int minValue;
        final int maxValue;

        public ExitsFitness(int minValue, int maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public double evaluateSpecific(Dungeon phenotype) {
            double result = 0.0;
            int value = phenotype.getExitLength();
            if (value > this.maxValue) {
                result = (double)(value - this.maxValue) / (double)this.maxValue;
            } else if (value < this.minValue) {
                result = (double)(this.minValue - value) / (double)this.minValue;
            }
            return result;
        }
    }
}

