/*
 * Decompiled with CFR 0.152.
 */
package fps.visualization;

import ai.pathfinder.Connector;
import ai.pathfinder.Node;
import ai.pathfinder.Pathfinder;
import common.PathLibrary;
import dungeon.Dungeon;
import processing.core.PApplet;
import processing.core.PImage;
import renderer.Render2D;
import util.image.processing.ImageProcessing;
import util.image.processing.Thresholding;
import util.math2d.Matrix2D;
import util.math2d.Point2D;
import util.math2d.Vector2D;

public class FPSVisualizer {
    static final int[][] baseColors = new int[][]{{255, 0, 0}, {0, 0, 255}, {64, 255, 64}, {255, 255, 0}, {128, 0, 255}, {0, 255, 255}, {255, 255, 255}, {0, 0, 0}};
    static final int[] impassableColor = new int[]{40, 40, 40};
    static final int[] passableColor = new int[]{255, 255, 255};
    static final int[] spawnColor = new int[]{255, 0, 200};
    static final int[] weaponColor = new int[]{200, 100, 0};
    static final int[] healthColor = new int[]{80, 80, 255};
    static int explorationIndex = 0;

    public static Render2D renderThumbnail(PApplet p, Dungeon map) {
        return FPSVisualizer.renderThumbnail(p, map, map.getMapSizeX(), map.getMapSizeY());
    }

    public static Render2D renderThumbnail(PApplet p, Dungeon map, int imgSizeX, int imgSizeY) {
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] weapons = map.getRewardArray();
        boolean[][] health = map.getMonsterArray();
        boolean[][] spawns = map.getExitArray();
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(impassableColor[0], impassableColor[1], impassableColor[2]), p.color(passableColor[0], passableColor[1], passableColor[2]));
        renderer.renderTiles(weapons, p.color(weaponColor[0], weaponColor[1], weaponColor[2]));
        renderer.renderTiles(health, p.color(healthColor[0], healthColor[1], healthColor[2]));
        renderer.renderTiles(spawns, p.color(spawnColor[0], spawnColor[1], spawnColor[2]));
        return renderer;
    }

    public static Render2D renderExplorationThumbnail(PApplet p, Dungeon map, int imgSizeX, int imgSizeY) {
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        int i = ++explorationIndex % map.getExitLength();
        float[][] temp = map.getPaths().getExplorationMatrix(i);
        System.out.println(Matrix2D.print(Thresholding.getArrayAboveValue(temp, 0.2f)));
        int c_on = p.color(baseColors[i][0], baseColors[i][1], baseColors[i][2], 160);
        renderer.renderTiles(temp, c_on);
        return renderer;
    }

    public static Render2D renderNavmeshThumbnail(PApplet p, Dungeon map) {
        return FPSVisualizer.renderNavmeshThumbnail(p, map, map.getMapSizeX(), map.getMapSizeY());
    }

    public static Render2D renderNavmeshThumbnail(PApplet p, Dungeon map, int imgSizeX, int imgSizeY) {
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] monsters = map.getMonsterArray();
        boolean[][] rewards = map.getRewardArray();
        boolean[][] exits = map.getExitArray();
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(impassableColor[0], impassableColor[1], impassableColor[2]), p.color(passableColor[0], passableColor[1], passableColor[2]));
        boolean[][] deadEnds = map.getPaths().getDeadEnds();
        boolean[][] chokePoints = map.getPaths().getChokePoints();
        boolean[][] openSpaces = map.getPaths().getOpenAreas();
        renderer.renderTiles(deadEnds, p.color(0, 0, 0, 75));
        renderer.renderTiles(chokePoints, p.color(255, 0, 128, 75));
        renderer.renderTiles(openSpaces, p.color(255, 255, 0, 75));
        if (map.getPaths() != null && map.getPaths().getAStar() != null) {
            Pathfinder astar = map.getPaths().getAStar();
            for (int i = 0; i < astar.nodes.size(); ++i) {
                Node n = (Node)astar.nodes.get(i);
                if (!n.walkable) continue;
                Connector conn = null;
                for (int j = 0; j < n.links.size(); ++j) {
                    conn = (Connector)n.links.get(j);
                    renderer.renderLine(PathLibrary.transformNode(conn.n), PathLibrary.transformNode(n), p.color(0, 255, 0), 2.0f);
                    int pointColor = p.color(0, 255, 0);
                    if (openSpaces[(int)conn.n.x][(int)conn.n.y]) {
                        pointColor = p.color(255, 255, 0);
                    }
                    if (chokePoints[(int)conn.n.x][(int)conn.n.y]) {
                        pointColor = p.color(255, 0, 128);
                    }
                    if (deadEnds[(int)conn.n.x][(int)conn.n.y]) {
                        pointColor = p.color(0, 0, 0);
                    }
                    renderer.renderMidpoint(PathLibrary.transformNode(conn.n), pointColor, 10);
                    pointColor = p.color(0, 255, 0);
                    if (openSpaces[(int)n.x][(int)n.y]) {
                        pointColor = p.color(255, 255, 0);
                    }
                    if (deadEnds[(int)n.x][(int)n.y]) {
                        pointColor = p.color(0, 0, 0);
                    }
                    if (chokePoints[(int)n.x][(int)n.y]) {
                        pointColor = p.color(255, 0, 128);
                    }
                    renderer.renderMidpoint(PathLibrary.transformNode(n), pointColor, 10);
                }
            }
        }
        return renderer;
    }

    public static Render2D renderCorridors(PApplet p, Dungeon map, int imgSizeX, int imgSizeY) {
        int j;
        int i;
        int y;
        int x;
        int gridSize = 10;
        int[] color = new int[]{p.color(255), p.color(100), p.color(255, 0, 200), p.color(255, 160, 80), p.color(80, 80, 255)};
        boolean[][] health = map.getMonsterArray();
        boolean[][] weapons = map.getRewardArray();
        boolean[][] spawns = map.getExitArray();
        boolean[][] passable = map.getPassableArray();
        boolean[][] chokePoints = map.getPaths().getChokePoints();
        boolean[][] openAreas = map.getPaths().getOpenAreas();
        Render2D renderer = new Render2D(p, map.getMapSizeX() * gridSize, map.getMapSizeY() * gridSize, imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderBackground(color[0]);
        for (x = 0; x < passable.length; ++x) {
            for (y = 0; y < passable[x].length; ++y) {
                if (!passable[x][y] || chokePoints[x][y] && !spawns[x][y]) continue;
                for (i = 1; i < gridSize - 1; ++i) {
                    for (j = 1; j < gridSize - 1; ++j) {
                        renderer.renderTile(x * gridSize + i, y * gridSize + j, color[1]);
                    }
                }
            }
        }
        for (x = 0; x < passable.length; ++x) {
            for (y = 0; y < passable[x].length; ++y) {
                if (y >= passable[x].length - 1 || x >= passable.length - 1 || !passable[x][y] || !passable[x][y + 1] || !passable[x + 1][y] || !passable[x + 1][y + 1]) continue;
                for (i = 1; i < 2 * gridSize - 1; ++i) {
                    for (j = 1; j < 2 * gridSize - 1; ++j) {
                        renderer.renderTile(x * gridSize + i, y * gridSize + j, color[1]);
                    }
                }
            }
        }
        float corridorWidth = Math.max(1, Math.min(renderer.getGridSizeX(), renderer.getGridSizeY()) * gridSize / 4);
        if (map.getPaths() != null && map.getPaths().getAStar() != null) {
            Pathfinder astar = map.getPaths().getAStar();
            for (i = 0; i < astar.nodes.size(); ++i) {
                Node n = (Node)astar.nodes.get(i);
                if (!n.walkable) continue;
                Connector conn = null;
                for (int j2 = 0; j2 < n.links.size(); ++j2) {
                    conn = (Connector)n.links.get(j2);
                    Point2D start = PathLibrary.transformNode(n);
                    Point2D end = Vector2D.interpolate(PathLibrary.transformNode(n), PathLibrary.transformNode(conn.n), 0.5f);
                    if (start.x != end.x && start.y != end.y) continue;
                    start.x = (start.x + 0.5) * (double)gridSize;
                    start.y = (start.y + 0.5) * (double)gridSize;
                    end.x = (end.x + 0.5) * (double)gridSize;
                    end.y = (end.y + 0.5) * (double)gridSize;
                    renderer.renderLine(start, end, color[1], corridorWidth);
                    renderer.renderMidrect(start, color[1], (int)corridorWidth, (int)corridorWidth);
                }
            }
        }
        int locationDiameter = Math.min(renderer.getGridSizeX(), renderer.getGridSizeY()) * gridSize / 2;
        for (int x2 = 0; x2 < passable.length; ++x2) {
            for (int y2 = 0; y2 < passable[x2].length; ++y2) {
                if (weapons[x2][y2]) {
                    renderer.renderMidtriangle((int)(((double)x2 + 0.5) * (double)gridSize), (int)(((double)y2 + 0.5) * (double)gridSize), color[3], locationDiameter, locationDiameter, false);
                }
                if (health[x2][y2]) {
                    renderer.renderMidrect((int)(((double)x2 + 0.5) * (double)gridSize), (int)(((double)y2 + 0.5) * (double)gridSize), color[4], locationDiameter, 3, false);
                    renderer.renderMidrect((int)(((double)x2 + 0.5) * (double)gridSize), (int)(((double)y2 + 0.5) * (double)gridSize), color[4], 3, locationDiameter, false);
                }
                if (!spawns[x2][y2]) continue;
                renderer.renderMidpoint((int)(((double)x2 + 0.5) * (double)gridSize), (int)(((double)y2 + 0.5) * (double)gridSize), color[2], locationDiameter, true);
            }
        }
        return renderer;
    }

    public static Render2D renderSprite(PApplet p, Dungeon map, int imgSizeX, int imgSizeY) {
        int j;
        int i;
        int y;
        int x;
        int gridSize = 16;
        ImageProcessing imgProc = new ImageProcessing(p);
        int[] color = new int[]{p.color(255), p.color(100), p.color(255, 0, 200), p.color(200, 100, 0), p.color(80, 80, 255)};
        PImage[] sprites = new PImage[]{p.loadImage("resources/tilesets/fps_transparent/impassable.png"), p.loadImage("resources/tilesets/fps_transparent/passable.png"), imgProc.getTransparentImage(p.loadImage("resources/tilesets/fps_transparent/spawnpoint.png"), p.color(255, 0, 255)), imgProc.getTransparentImage(p.loadImage("resources/tilesets/fps_transparent/weapon.png"), p.color(255, 0, 255)), imgProc.getTransparentImage(p.loadImage("resources/tilesets/fps_transparent/healing.png"), p.color(255, 0, 255))};
        boolean[][] health = map.getMonsterArray();
        boolean[][] weapons = map.getRewardArray();
        boolean[][] spawns = map.getExitArray();
        boolean[][] passable = map.getPassableArray();
        boolean[][] chokePoints = map.getPaths().getChokePoints();
        boolean[][] openAreas = map.getPaths().getOpenAreas();
        Render2D renderer = new Render2D(p, map.getMapSizeX() * gridSize, map.getMapSizeY() * gridSize, imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderBackground(color[0]);
        for (x = 0; x < passable.length; ++x) {
            for (y = 0; y < passable[x].length; ++y) {
                if (!passable[x][y] || chokePoints[x][y] && !spawns[x][y]) continue;
                for (i = 1; i < gridSize - 1; ++i) {
                    for (j = 1; j < gridSize - 1; ++j) {
                        renderer.renderTile(x * gridSize + i, y * gridSize + j, color[1]);
                    }
                }
            }
        }
        for (x = 0; x < passable.length; ++x) {
            for (y = 0; y < passable[x].length; ++y) {
                if (y >= passable[x].length - 1 || x >= passable.length - 1 || !passable[x][y] || !passable[x][y + 1] || !passable[x + 1][y] || !passable[x + 1][y + 1]) continue;
                for (i = 1; i < 2 * gridSize - 1; ++i) {
                    for (j = 1; j < 2 * gridSize - 1; ++j) {
                        renderer.renderTile(x * gridSize + i, y * gridSize + j, color[1]);
                    }
                }
            }
        }
        float corridorWidth = Math.max(1, Math.min(renderer.getGridSizeX(), renderer.getGridSizeY()) * gridSize / 4);
        if (map.getPaths() != null && map.getPaths().getAStar() != null) {
            Pathfinder astar = map.getPaths().getAStar();
            for (i = 0; i < astar.nodes.size(); ++i) {
                Node n = (Node)astar.nodes.get(i);
                if (!n.walkable) continue;
                Connector conn = null;
                for (int j2 = 0; j2 < n.links.size(); ++j2) {
                    conn = (Connector)n.links.get(j2);
                    Point2D start = PathLibrary.transformNode(n);
                    Point2D end = Vector2D.interpolate(PathLibrary.transformNode(n), PathLibrary.transformNode(conn.n), 0.5f);
                    if (start.x != end.x && start.y != end.y) continue;
                    start.x = (start.x + 0.5) * (double)gridSize;
                    start.y = (start.y + 0.5) * (double)gridSize;
                    end.x = (end.x + 0.5) * (double)gridSize;
                    end.y = (end.y + 0.5) * (double)gridSize;
                    renderer.renderLine(start, end, color[1], corridorWidth);
                    renderer.renderMidrect(start, color[1], (int)corridorWidth, (int)corridorWidth);
                }
            }
        }
        int locationDiameter = gridSize;
        for (int x2 = 0; x2 < passable.length; ++x2) {
            for (int y2 = 0; y2 < passable[x2].length; ++y2) {
                if (weapons[x2][y2]) {
                    renderer.renderSprite(sprites[3], (int)(((double)x2 + 0.5) * (double)gridSize), (int)(((double)y2 + 0.5) * (double)gridSize), locationDiameter, locationDiameter, false);
                }
                if (health[x2][y2]) {
                    renderer.renderSprite(sprites[4], (int)(((double)x2 + 0.5) * (double)gridSize), (int)(((double)y2 + 0.5) * (double)gridSize), locationDiameter, locationDiameter, false);
                }
                if (!spawns[x2][y2]) continue;
                renderer.renderSprite(sprites[2], (int)(((double)x2 + 0.5) * (double)gridSize), (int)(((double)y2 + 0.5) * (double)gridSize), locationDiameter, locationDiameter, false);
            }
        }
        return renderer;
    }
}

