/*
 * Decompiled with CFR 0.152.
 */
package generic;

import java.util.Vector;
import util.math2d.Point2D;

public class TileCollection
extends Vector<Point2D> {
    String label;

    public TileCollection(String label) {
        this.label = label;
    }

    public TileCollection(TileCollection copy) {
        this.label = copy.label;
        for (int i = 0; i < copy.size(); ++i) {
            this.add(copy.get(i));
        }
    }

    public boolean isTile(int x, int y) {
        for (int i = 0; i < this.size(); ++i) {
            if (((Point2D)this.get((int)i)).x != (double)x || ((Point2D)this.get((int)i)).y != (double)y) continue;
            return true;
        }
        return false;
    }

    public boolean isTile(Point2D point) {
        return this.isTile((int)point.x, (int)point.y);
    }

    public boolean[][] getArray(int sizeX, int sizeY) {
        boolean[][] result = new boolean[sizeX][sizeY];
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                result[x][y] = false;
            }
        }
        for (int i = 0; i < this.size(); ++i) {
            result[(int)((Point2D)this.get((int)i)).x][(int)((Point2D)this.get((int)i)).y] = true;
        }
        return result;
    }

    public String getLabel() {
        return this.label;
    }

    public static TileCollection union(TileCollection tc1, TileCollection tc2) {
        return TileCollection.union(tc1, tc2, tc1.getLabel() + "+" + tc2.getLabel());
    }

    public static TileCollection union(TileCollection tc1, TileCollection tc2, String label) {
        int i;
        TileCollection result = new TileCollection(label);
        for (i = 0; i < tc1.size(); ++i) {
            result.add(tc1.get(i));
        }
        for (i = 0; i < tc2.size(); ++i) {
            result.add(tc2.get(i));
        }
        return result;
    }
}

