/*
 * Decompiled with CFR 0.152.
 */
package generic;

import generic.TileCollection;
import generic.TilePaths;
import java.util.Arrays;
import java.util.Vector;
import util.math2d.Point2D;
import util.statics.LogManager;
import util.statics.RandomNumberManager;

public class TileMap {
    int mapSizeX;
    int mapSizeY;
    boolean[][] impassable;
    Vector<TileCollection> specialTiles;
    TilePaths paths;

    public TileMap(int sizeX, int sizeY) {
        this.mapSizeX = sizeX;
        this.mapSizeY = sizeY;
        this.clearImpassable();
        this.clearSpecialTiles();
    }

    public TileMap(TileMap copy) {
        this.mapSizeX = copy.mapSizeX;
        this.mapSizeY = copy.mapSizeX;
        this.clearImpassable();
        this.clearSpecialTiles();
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[x].length; ++y) {
                this.impassable[x][y] = copy.impassable[x][y];
            }
        }
        for (int j = 0; j < copy.specialTiles.size(); ++j) {
            this.specialTiles.add(copy.specialTiles.get(j));
        }
        this.paths = new TilePaths(this, copy.paths);
    }

    public int getMapSizeX() {
        return this.mapSizeX;
    }

    public int getMapSizeY() {
        return this.mapSizeY;
    }

    public TilePaths getPaths() {
        return this.paths;
    }

    public int getTileDifference(TileMap other) {
        if (other.mapSizeX != this.mapSizeX || other.mapSizeY != this.mapSizeY) {
            LogManager.writeError("Error", this, "Comparing different-sized sketches");
            return Integer.MAX_VALUE;
        }
        int result = 0;
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[x].length; ++y) {
                if (this.impassable[x][y] == other.impassable[x][y]) continue;
                ++result;
            }
        }
        return result;
    }

    public void clearImpassable() {
        this.impassable = new boolean[this.mapSizeX][this.mapSizeY];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                this.impassable[x][y] = false;
            }
        }
    }

    public void clearSpecialTiles() {
        if (this.specialTiles != null) {
            this.specialTiles.clear();
        }
        this.specialTiles = new Vector();
    }

    public int getSTCIndex(String label) {
        for (int j = 0; j < this.specialTiles.size(); ++j) {
            if (!this.specialTiles.get(j).getLabel().equalsIgnoreCase(label)) continue;
            return j;
        }
        return -1;
    }

    public boolean isSpecialTile(int x, int y, String label) {
        int index = this.getSTCIndex(label);
        if (index != -1) {
            return this.specialTiles.get(index).isTile(x, y);
        }
        return false;
    }

    public boolean isAnySpecialTile(int x, int y) {
        boolean result = false;
        for (int j = 0; j < this.specialTiles.size(); ++j) {
            result = result || this.specialTiles.get(j).isTile(x, y);
        }
        return result;
    }

    public boolean addSpecialTile(int x, int y, String label) {
        if (this.isWithinBounds(x, y) && !this.impassable[x][y] && this.isAnySpecialTile(x, y)) {
            int index = this.getSTCIndex(label);
            if (index != -1) {
                this.specialTiles.get(index).add(new Point2D(x, y));
            } else {
                TileCollection tc = new TileCollection(label);
                tc.add(new Point2D(x, y));
                this.specialTiles.add(tc);
            }
            return true;
        }
        return false;
    }

    public boolean removeSpecialTile(int x, int y, String label) {
        int tIndex;
        int stcIndex = this.getSTCIndex(label);
        if (stcIndex != -1 && (tIndex = this.getSpecialTileIndex(x, y, stcIndex)) != -1) {
            this.specialTiles.get(stcIndex).remove(tIndex);
            return true;
        }
        return false;
    }

    public boolean removeAllSpecialTiles(int x, int y) {
        for (int i = 0; i < this.specialTiles.size(); ++i) {
            int tIndex = this.getSpecialTileIndex(x, y, i);
            if (tIndex == -1) continue;
            this.specialTiles.get(i).remove(tIndex);
            return true;
        }
        return false;
    }

    protected int getSpecialTileIndex(int x, int y, int stcIndex) {
        for (int i = 0; i < this.specialTiles.get(stcIndex).size(); ++i) {
            if (((Point2D)this.specialTiles.get((int)stcIndex).get((int)i)).x != (double)x || ((Point2D)this.specialTiles.get((int)stcIndex).get((int)i)).y != (double)y) continue;
            return i;
        }
        return -1;
    }

    protected int getSpecialTileIndex(int x, int y, String label) {
        int stcIndex = this.getSTCIndex(label);
        if (stcIndex != -1) {
            return this.getSpecialTileIndex(x, y, stcIndex);
        }
        return -1;
    }

    public void setPassable(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            this.impassable[x][y] = false;
        }
    }

    public void setImpassable(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            this.impassable[x][y] = true;
        }
    }

    public void setPassable(boolean[][] pattern, int centerX, int centerY) {
        for (int x = 0; x < pattern.length; ++x) {
            for (int y = 0; y < pattern[0].length; ++y) {
                int global_y;
                int global_x;
                if (!pattern[x][y] || !this.isWithinBounds(global_x = centerX - pattern.length / 2 + x * pattern.length, global_y = centerY - pattern[0].length / 2 + y * pattern[0].length)) continue;
                this.impassable[global_x][global_y] = false;
            }
        }
    }

    public void setImpassable(boolean[][] pattern, int centerX, int centerY) {
        for (int x = 0; x < pattern.length; ++x) {
            for (int y = 0; y < pattern[0].length; ++y) {
                int global_y;
                int global_x;
                if (!pattern[x][y] || !this.isWithinBounds(global_x = centerX - pattern.length / 2 + x, global_y = centerY - pattern[0].length / 2 + y)) continue;
                this.impassable[global_x][global_y] = true;
            }
        }
    }

    public void setImpassableChunk(int centerX, int centerY, int sizeX, int sizeY) {
        for (int x = centerX - sizeX / 2; x < centerX + sizeX / 2; ++x) {
            for (int y = centerY - sizeY / 2; y < centerY + sizeY / 2; ++y) {
                if (!this.isWithinBounds(x, y)) continue;
                this.impassable[x][y] = true;
            }
        }
    }

    public int getSpecialTileLength(String label) {
        int stcIndex = this.getSTCIndex(label);
        if (stcIndex != -1) {
            return this.specialTiles.get(stcIndex).size();
        }
        return 0;
    }

    public Point2D getSpecialTile(int index, String label) {
        int stcIndex = this.getSTCIndex(label);
        if (stcIndex != -1) {
            return (Point2D)this.specialTiles.get(stcIndex).get(index);
        }
        return null;
    }

    public Vector<Point2D> getSpecialTiles(String label) {
        int stcIndex = this.getSTCIndex(label);
        if (stcIndex != -1) {
            return this.specialTiles.get(stcIndex);
        }
        return null;
    }

    public Vector<Point2D> getAllSpecialTiles() {
        Vector<Point2D> result = new Vector<Point2D>();
        for (int i = 0; i < this.specialTiles.size(); ++i) {
            result.addAll(this.specialTiles.get(i));
        }
        return result;
    }

    public void initPaths() {
        this.initPaths(8);
    }

    public void initPaths(int connectivity) {
        this.paths = new TilePaths(this);
        this.paths.init(connectivity);
    }

    public boolean isPassable(int x, int y) {
        if (!this.isWithinBounds(x, y)) {
            return false;
        }
        return !this.impassable[x][y];
    }

    public boolean isWithinBounds(int x, int y) {
        return x >= 0 && x < this.mapSizeX && y >= 0 && y < this.mapSizeY;
    }

    public boolean isCorner(int x, int y) {
        if (x == 0 && y == 0) {
            return true;
        }
        if (x == 0 && y == this.mapSizeY - 1) {
            return true;
        }
        if (x == this.mapSizeX - 1 && y == 0) {
            return true;
        }
        return x == this.mapSizeX - 1 && y == this.mapSizeY - 1;
    }

    public boolean[][] getPassableArray() {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                result[x][y] = !this.impassable[x][y];
            }
        }
        return result;
    }

    public boolean[][] getImpassableArray() {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            result[x] = Arrays.copyOf(this.impassable[x], this.impassable[x].length);
        }
        return result;
    }

    public boolean[][] getTileArray(String label) {
        boolean[][] result = null;
        int stcIndex = this.getSTCIndex(label);
        if (stcIndex != -1) {
            result = this.specialTiles.get(stcIndex).getArray(this.mapSizeX, this.mapSizeY);
        }
        return result;
    }

    public void randomize(int tileCount, String tileLabel) {
        TileCollection tc = new TileCollection(tileLabel);
        for (int k = 0; k < tileCount; ++k) {
            int x = RandomNumberManager.getRandomInt(0, this.mapSizeX);
            int y = RandomNumberManager.getRandomInt(0, this.mapSizeY);
            tc.add(new Point2D(x, y));
        }
        this.specialTiles.add(tc);
    }

    public void randomize(int[] tileCount, String[] tileLabels) {
        if (tileCount.length != tileLabels.length) {
            LogManager.writeError("Error", this, "tile count and tile labels length mismatch");
            return;
        }
        for (int i = 0; i < tileLabels.length; ++i) {
            TileCollection tc = new TileCollection(tileLabels[i]);
            for (int k = 0; k < tileCount[i]; ++k) {
                int x = RandomNumberManager.getRandomInt(0, this.mapSizeX);
                int y = RandomNumberManager.getRandomInt(0, this.mapSizeY);
                tc.add(new Point2D(x, y));
            }
            this.specialTiles.add(tc);
        }
    }

    public void randomizeImpassable(int impassableCount) {
        this.clearImpassable();
        for (int i = 0; i < impassableCount; ++i) {
            int x = RandomNumberManager.getRandomInt(0, this.mapSizeX);
            int y = RandomNumberManager.getRandomInt(0, this.mapSizeY);
            this.impassable[x][y] = true;
        }
    }

    public String toASCII() {
        String result = "";
        for (int y = 0; y < this.mapSizeX; ++y) {
            for (int x = 0; x < this.mapSizeX; ++x) {
                result = this.impassable[x][y] ? result + "#" : result + ".";
            }
            result = result + ";";
        }
        return result;
    }
}

