/*
 * Decompiled with CFR 0.152.
 */
package generic;

import ai.pathfinder.Node;
import ai.pathfinder.Pathfinder;
import common.PathLibrary;
import generic.TileMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import util.math2d.Matrix2D;
import util.math2d.Point2D;
import util.statics.LogManager;

public class TilePaths {
    HashMap<String, Object> variables;
    TileMap parent;
    Pathfinder astar;
    int connectivity;

    public TilePaths(TileMap parent) {
        this.parent = parent;
        this.resetVariables();
    }

    public TilePaths(TileMap parent, TilePaths copy) {
        this(parent);
        this.init(copy.connectivity);
    }

    public void init(int connectivity) {
        this.connectivity = connectivity;
        this.astar = new Pathfinder();
        boolean spacing = true;
        if (connectivity == 4) {
            this.astar.corners = false;
        } else if (connectivity == 8) {
            this.astar.corners = true;
        } else {
            LogManager.writeError("Error", this, "invalid connectivity");
        }
        this.astar.setCuboidNodes(this.parent.getMapSizeX(), this.parent.getMapSizeY(), (float)spacing);
        for (Object temp : this.astar.nodes) {
            Node n = (Node)temp;
            n.walkable = this.parent.isPassable((int)n.x, (int)n.y);
        }
        this.astar.radialDisconnectUnwalkables();
    }

    public void resetVariables() {
        if (this.variables != null) {
            this.variables.clear();
        }
        this.variables = new HashMap();
    }

    public Object getVariable(String label) {
        if (this.variables.containsKey(label)) {
            return this.variables.get(label);
        }
        LogManager.writeError("Error", this, "variable " + label + " does not exist");
        return null;
    }

    public Node findNode(int x, int y) {
        return PathLibrary.findNode(x, y, this.astar);
    }

    public ArrayList getPath(Point2D p1, Point2D p2) {
        return this.getPath((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
    }

    public ArrayList getPath(Point2D p1, int x2, int y2) {
        return this.getPath((int)p1.x, (int)p1.y, x2, y2);
    }

    public ArrayList getPath(int x1, int y1, Point2D p2) {
        return this.getPath(x1, y1, (int)p2.x, (int)p2.y);
    }

    public ArrayList getPath(int x1, int y1, int x2, int y2) {
        ArrayList result = this.astar.aStar(this.findNode(x1, y1), this.findNode(x2, y2));
        if (PathLibrary.hasStart(result, x2, y2) && PathLibrary.hasEnd(result, x1, y1)) {
            return result;
        }
        return null;
    }

    public void calculateAllPaths(Vector<Point2D> connectedTiles, String tileLabel) {
        if (this.variables.containsKey("allPaths" + tileLabel)) {
            return;
        }
        int disconnectedPaths = 0;
        Vector<ArrayList> paths = new Vector<ArrayList>();
        for (int i = 0; i < connectedTiles.size(); ++i) {
            for (int j = i + 1; j < connectedTiles.size(); ++j) {
                ArrayList path = this.getPath((int)connectedTiles.get((int)j).x, (int)connectedTiles.get((int)j).y, (int)connectedTiles.get((int)i).x, (int)connectedTiles.get((int)i).y);
                if (path != null) {
                    paths.add(path);
                    continue;
                }
                ++disconnectedPaths;
            }
        }
        this.variables.put("allPaths" + tileLabel, paths);
        this.variables.put("disconnected" + tileLabel, disconnectedPaths);
    }

    protected boolean[][] getArray(Vector<Point2D> tiles) {
        boolean[][] result = new boolean[this.parent.getMapSizeX()][this.parent.getMapSizeY()];
        for (int x = 0; x < result.length; ++x) {
            for (int y = 0; y < result[0].length; ++y) {
                result[x][y] = false;
            }
        }
        for (int i = 0; i < tiles.size(); ++i) {
            result[(int)tiles.get((int)i).x][(int)tiles.get((int)i).y] = true;
        }
        return result;
    }

    public void calculateEmptySpace(Vector<Point2D> connectedTiles, String tileLabel) {
        if (!this.variables.containsKey("allPaths" + tileLabel)) {
            this.calculateAllPaths(connectedTiles, tileLabel);
        }
        Vector paths = (Vector)this.variables.get("allPaths" + tileLabel);
        boolean[][] unusedSpaces = Matrix2D.invert(this.parent.getImpassableArray());
        unusedSpaces = Matrix2D.intersection(unusedSpaces, Matrix2D.invert(this.getArray(connectedTiles)));
        for (int i = 0; i < paths.size(); ++i) {
            Vector<Point2D> points = PathLibrary.transformPath((ArrayList)paths.get(i));
            unusedSpaces = Matrix2D.intersection(unusedSpaces, Matrix2D.invert(PathLibrary.transformPath(points, unusedSpaces.length, unusedSpaces[0].length)));
        }
        this.variables.put("emptySpace" + tileLabel, paths);
    }

    public void calculateNavigationInfo() {
        boolean[][] chokePoints = null;
        boolean[][] deadEnds = null;
        boolean[][] openAreas = null;
        int[][] branchingFactor = null;
        float avgBranchingFactor = -1.0f;
        if (!this.variables.containsKey("chokePoints")) {
            chokePoints = new boolean[this.parent.getMapSizeX()][this.parent.getMapSizeY()];
        }
        if (!this.variables.containsKey("deadEnds")) {
            deadEnds = new boolean[this.parent.getMapSizeX()][this.parent.getMapSizeY()];
        }
        if (!this.variables.containsKey("openAreas")) {
            openAreas = new boolean[this.parent.getMapSizeX()][this.parent.getMapSizeY()];
        }
        if (!this.variables.containsKey("branchingFactor")) {
            branchingFactor = new int[this.parent.getMapSizeX()][this.parent.getMapSizeY()];
        }
        if (!this.variables.containsKey("avgBranchingFactor")) {
            avgBranchingFactor = 0.0f;
        }
        if (chokePoints == null && deadEnds == null && openAreas == null && branchingFactor == null && this.variables.containsKey("avgBranchingFactor")) {
            return;
        }
        int totalPassable = 0;
        if (chokePoints != null || deadEnds != null || openAreas != null) {
            for (int x = 0; x < chokePoints.length; ++x) {
                for (int y = 0; y < chokePoints[0].length; ++y) {
                    if (chokePoints != null) {
                        chokePoints[x][y] = false;
                    }
                    if (deadEnds != null) {
                        deadEnds[x][y] = false;
                    }
                    if (openAreas == null) continue;
                    openAreas[x][y] = false;
                }
            }
        }
        float averageBranchingFactor = 0.0f;
        for (int i = 0; i < this.astar.nodes.size(); ++i) {
            Node n = (Node)this.astar.nodes.get(i);
            if (!n.walkable) continue;
            boolean j = false;
            ++totalPassable;
            if (branchingFactor != null) {
                branchingFactor[(int)n.x][(int)n.y] = n.links.size();
            }
            if (averageBranchingFactor != -1.0f) {
                averageBranchingFactor += (float)n.links.size();
            }
            if (deadEnds != null && n.links.size() == 1) {
                deadEnds[(int)n.x][(int)n.y] = true;
            }
            if (chokePoints != null && n.links.size() == 2) {
                chokePoints[(int)n.x][(int)n.y] = true;
            }
            if (openAreas == null || n.links.size() != this.connectivity) continue;
            openAreas[(int)n.x][(int)n.y] = true;
        }
        if (averageBranchingFactor != -1.0f) {
            this.variables.put("averageBranchingFactor", Float.valueOf(averageBranchingFactor / (float)totalPassable));
        }
        if (chokePoints != null) {
            this.variables.put("chokePoints", chokePoints);
        }
        if (deadEnds != null) {
            this.variables.put("deadEnds", deadEnds);
        }
        if (openAreas != null) {
            this.variables.put("openAreas", openAreas);
        }
        if (branchingFactor != null) {
            this.variables.put("branchingFactor", branchingFactor);
        }
    }

    public Vector<Point2D> calculateChokePoints(ArrayList path) {
        Vector<Point2D> result = new Vector<Point2D>();
        if (!this.variables.containsKey("chokePoints")) {
            this.calculateNavigationInfo();
        }
        boolean[][] chokePoints = (boolean[][])this.variables.get("chokePoints");
        for (int i = 1; i < path.size() - 1; ++i) {
            Node n = (Node)path.get(i);
            if (!chokePoints[(int)n.x][(int)n.y]) continue;
            result.add(new Point2D(n.x, n.y));
        }
        return result;
    }
}

