/*
 * Decompiled with CFR 0.152.
 */
package generic.descriptors;

import renderer.Render2D;
import util.statics.LogManager;

public class TileType {
    String label;
    int color;
    String detailSprite;
    int detailDrawing;
    boolean passable = true;

    public TileType(String label, int color) {
        this(label, color, null, -1, true);
    }

    public TileType(String label, int color, boolean passable) {
        this(label, color, null, -1, passable);
    }

    public TileType(String label, int color, int detailDrawing, boolean passable) {
        this(label, color, null, detailDrawing, passable);
    }

    public TileType(String label, int color, String detailSprite, boolean passable) {
        this(label, color, detailSprite, -1, passable);
    }

    public TileType(String label, int color, String detailSprite, int detailDrawing, boolean passable) {
        this.label = label;
        this.color = color;
        this.detailSprite = detailSprite;
        this.detailDrawing = detailDrawing;
        this.passable = passable;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setDetailSprite(String detailSprite) {
        this.detailSprite = detailSprite;
    }

    public void setDetailDrawing(int detailDrawing) {
        this.detailDrawing = detailDrawing;
    }

    public void setPassable(boolean passable) {
        this.passable = passable;
    }

    public String getLabel() {
        return this.label;
    }

    public int getColor() {
        return this.color;
    }

    public String getDetailSprite() {
        return this.detailSprite;
    }

    public int getDetailDrawing() {
        return this.detailDrawing;
    }

    public boolean isPassable() {
        return this.passable;
    }

    public void renderTile(Render2D renderer, int x, int y) {
        renderer.renderTile(x, y, this.color);
    }

    public void renderDetailDrawing(Render2D renderer, int x, int y) {
        if (this.detailDrawing < 0) {
            LogManager.writeError("Error", this, "tile does not have a detailDrawing asset");
            return;
        }
        TileType.renderDetailDrawing(renderer, x, y, this.detailDrawing, this.color);
    }

    public static void renderDetailDrawing(Render2D renderer, int x, int y, int detailDrawing, int color) {
        int gsX = renderer.getGridSizeX();
        int gsY = renderer.getGridSizeY();
        int gsMin = Math.min(gsX, gsY);
        switch (detailDrawing) {
            case 0: {
                renderer.renderMidpoint(x, y, color, gsMin / 2, true);
                break;
            }
            case 1: {
                renderer.renderMidrect(x, y, color, gsMin / 2, gsMin / 2, true);
                break;
            }
            case 2: {
                renderer.renderMidrect(x, y, color, gsMin / 5, gsMin * 3 / 5, true);
                break;
            }
            case 3: {
                renderer.renderMidrect(x, y, color, gsMin * 3 / 5, gsMin / 5, true);
                break;
            }
            case 4: {
                renderer.renderMidNgon(x, y, color, gsMin * 3 / 4, 3, true);
                break;
            }
            case 5: {
                renderer.renderMidNgon(x, y, color, gsMin * 3 / 4, 4, true);
                break;
            }
            case 6: {
                renderer.renderMidNgon(x, y, color, gsMin * 3 / 4, 5, true);
                break;
            }
            case 7: {
                renderer.renderMidNgon(x, y, color, gsMin * 3 / 4, 6, true);
                break;
            }
            case 8: {
                renderer.renderMidpoint(x, y, color, gsMin * 3 / 4, true);
                break;
            }
            case 9: {
                renderer.renderMidpoint(x, y, color, gsMin / 4, true);
                break;
            }
            default: {
                renderer.renderTile(x, y, color);
            }
        }
    }

    public static void renderDetailDrawing(Render2D renderer, int x, int y, int detailDrawing, int r, int g, int b) {
        TileType.renderDetailDrawing(renderer, detailDrawing, x, y, renderer.getGraphics().color(r, g, b));
    }
}

