/*
 * Decompiled with CFR 0.152.
 */
package generic.descriptors;

import generic.descriptors.TileType;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import processing.core.PApplet;
import util.statics.LogManager;

public class TileTypeCollection
extends Vector<TileType> {
    PApplet p;

    public TileTypeCollection(PApplet p) {
        this.p = p;
        this.add(new TileType("Passable", p.color(255), true));
        this.add(new TileType("Impassable", p.color(0), false));
    }

    public void saveToXML(String filename) {
        File file = new File(filename);
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            fw.write(this.toXML());
            fw.close();
        }
        catch (Exception e) {
            LogManager.writeError("Error", this, "tileCollection: Error writing to file " + filename + ".");
            return;
        }
    }

    public String toXML() {
        String result = "<tileCollection>\n";
        for (int i = 0; i < this.size(); ++i) {
            String tile = "\t<tile ";
            tile = tile + "name=\"" + ((TileType)this.get(i)).getLabel() + "\"";
            tile = tile + "color=\"" + ((TileType)this.get(i)).getColor() + "\"";
            if (((TileType)this.get(i)).getDetailDrawing() != -1) {
                tile = tile + "detailDrawing=\"" + ((TileType)this.get(i)).getDetailDrawing() + "\"";
            }
            if (((TileType)this.get(i)).getDetailSprite() != null) {
                tile = tile + "detailSprite=\"" + ((TileType)this.get(i)).getDetailSprite() + "\"";
            }
            String string = tile + "/>\n";
        }
        result = result + "</tileCollection>";
        return result;
    }

    public TileTypeCollection(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            LogManager.writeError("Error", this, "File " + filename + " does not exist.");
            return;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        Document doc = null;
        try {
            db = dbf.newDocumentBuilder();
            doc = db.parse(file);
        }
        catch (Exception e) {
            LogManager.writeError("Error", this, "Error parsing file " + filename + ".");
            return;
        }
        doc.getDocumentElement().normalize();
        if (!doc.getDocumentElement().getNodeName().endsWith("tileCollection")) {
            LogManager.writeError("Error", this, "Invalid XML root");
            return;
        }
        NodeList nodeLst = doc.getElementsByTagName("tile");
        for (int i = 0; i < nodeLst.getLength(); ++i) {
            if (nodeLst.item(i).getNodeType() != 1) {
                LogManager.writeError("Error", this, "Invalid XML node");
                break;
            }
            Element el = (Element)nodeLst.item(i);
        }
    }
}

