/*
 * Decompiled with CFR 0.152.
 */
package generic.experiment;

import generic.TileMap;
import processing.core.PApplet;
import processing.core.PImage;
import renderer.SpriteRender2D;
import util.image.ImageVisualization;

public class FPS_Visualization
extends ImageVisualization<TileMap> {
    PImage impassable;
    PImage passable;
    PImage weapon;
    PImage healing;
    PImage spawnpoint;

    public FPS_Visualization() {
        this.loadTileset();
    }

    public FPS_Visualization(PApplet p) {
        this.loadTileset();
    }

    public void loadTileset() {
        this.impassable = this.p.loadImage("./resources/tilesets/fps/impassable.png");
        this.passable = this.p.loadImage("./resources/tilesets/fps/passable.png");
        this.weapon = this.p.loadImage("./resources/tilesets/fps/weapon.png");
        this.healing = this.p.loadImage("./resources/tilesets/fps/healing.png");
        this.spawnpoint = this.p.loadImage("./resources/tilesets/fps/spawnpoint.png");
    }

    @Override
    public PImage visualizeSpecific(TileMap object) {
        SpriteRender2D sr = new SpriteRender2D(this.p, object.getMapSizeX(), object.getMapSizeX(), object.getMapSizeX() * this.impassable.width, object.getMapSizeY() * this.impassable.height);
        sr.renderBackground(this.p.color(255));
        sr.renderTiles(object.getPassableArray(), this.passable);
        sr.renderTiles(object.getTileArray("weapons"), this.weapon);
        sr.renderTiles(object.getTileArray("healing"), this.healing);
        sr.renderTiles(object.getTileArray("spawnpoints"), this.spawnpoint);
        return sr.getImage();
    }
}

