/*
 * Decompiled with CFR 0.152.
 */
package generic.screens;

import generic.TileMap;
import generic.experiment.FPS_Visualization;
import processing.core.PImage;
import ui.BaseApplet;
import ui.components.UIButton;
import ui.components.UIImage;
import ui.components.UILabel;
import ui.screens.Screen;

public class Screen_Generator
extends Screen {
    public Screen_Generator(BaseApplet p) {
        super(p);
        this.addComponent("Title", new UILabel(p, "Welcome to Sentient Sketchbook", p.width / 2, 30, "Huge"));
        this.addComponent("Regenerate_Button", new UIButton(p, "Regenerate", p.width - 150, p.height / 2, "Huge"));
        this.addComponent("Back_Button", new UIButton(p, "Back", p.width - 150, p.height / 2 + 50, "Huge"));
        PImage sampleMap = this.generateFPS();
        this.addComponent("SampleMap_Image", new UIImage(p, sampleMap, p.width / 2, p.height / 2));
    }

    @Override
    public void mouseClicked() {
        super.mouseClicked();
        UIButton b = null;
        b = (UIButton)this.getComponent("Regenerate_Button");
        if (b != null && b.getState() == UIButton.State.PRESSED) {
            PImage sampleMap = this.generateFPS();
            UIImage uiImg = (UIImage)this.getComponent("SampleMap_Image");
            uiImg.setImage(sampleMap, false);
        }
        if ((b = (UIButton)this.getComponent("Back_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.p.swapPreviousScreen();
        }
    }

    protected PImage generateFPS() {
        TileMap tm = null;
        do {
            tm = new TileMap(8, 8);
            tm.randomizeImpassable(15);
            tm.randomize(2, "spawnpoints");
            tm.randomize(3, "weapons");
            tm.randomize(4, "healing");
            tm.initPaths();
            tm.getPaths().calculateAllPaths(tm.getAllSpecialTiles(), "all");
        } while ((Integer)tm.getPaths().getVariable("disconnectedall") > 0);
        FPS_Visualization viz = new FPS_Visualization();
        PImage img = viz.visualize(tm);
        img.save("test.png");
        return img;
    }
}

