/*
 * Decompiled with CFR 0.152.
 */
package generic.screens;

import generic.descriptors.TileType;
import generic.descriptors.TileTypeCollection;
import generic.screens.Screen_TileList;
import processing.core.PApplet;
import renderer.Render2D;
import ui.BaseApplet;
import ui.components.UIButton;
import ui.components.UILabel;
import ui.components.UITextField;
import ui.components.UIToggleButtonGroup;
import ui.screens.Popup;
import ui.screens.Popup_Alert;
import ui.screens.Popup_YesNo;
import ui.screens.Screen;

public class Screen_TileAdd
extends Screen {
    TileTypeCollection currentTTC;
    TileType currentTT;
    Render2D iconRenderer;
    Render2D drawingRenderer;
    String spriteFile;
    int color;
    boolean blockNameEdits = false;
    String popupNoName = "You need to have a name and a color for the tile.";
    int[][] allowedColors = new int[][]{{0, 0, 0}, {127, 0, 0}, {0, 127, 0}, {0, 0, 127}, {127, 127, 0}, {0, 127, 127}, {127, 0, 127}, {127, 64, 0}, {127, 127, 127}, {255, 0, 0}, {0, 255, 0}, {0, 0, 255}, {255, 255, 0}, {0, 255, 255}, {255, 0, 255}, {255, 127, 0}, {255, 255, 255}, {255, 127, 127}, {127, 255, 127}, {127, 127, 255}, {255, 255, 127}, {127, 255, 255}, {255, 127, 255}, {255, 196, 64}};

    public Screen_TileAdd(BaseApplet p, TileTypeCollection ttc) {
        this(p, ttc, null);
    }

    public Screen_TileAdd(BaseApplet p, TileTypeCollection ttc, TileType tileType) {
        this(p, ttc, tileType, false);
    }

    public Screen_TileAdd(BaseApplet p, TileTypeCollection ttc, TileType tileType, boolean blockNameEdits) {
        super(p);
        this.currentTTC = ttc;
        this.currentTT = tileType;
        this.blockNameEdits = blockNameEdits;
        this.color = this.currentTT == null ? this.resolveColor(0) : this.resolveColor(this.getColorIndex(tileType));
        this.addComponent("Title", new UILabel(p, "Add a new Tile Type", p.width / 2, 30, "Huge"));
        if (tileType == null) {
            this.addComponent("ApplyTileType_Button", new UIButton(p, "Add new Tile Type", p.width / 2, p.height - 100, "Large"));
        } else {
            this.addComponent("ApplyTileType_Button", new UIButton(p, "Save Tile Type", p.width / 2, p.height - 100, "Large"));
        }
        this.addComponent("Back_Button", new UIButton(p, "Back", p.width / 2, p.height - 50, "Large"));
        this.iconRenderer = new Render2D((PApplet)p, 1, 1, 20, 20);
        this.drawingRenderer = new Render2D((PApplet)p, 1, 1, 20, 20);
        this.populateTileInformation(tileType);
    }

    @Override
    public void mouseClicked() {
        super.mouseClicked();
        UIToggleButtonGroup icon_tbg = (UIToggleButtonGroup)this.getComponent("Tile_color");
        UIToggleButtonGroup drawing_tbg = (UIToggleButtonGroup)this.getComponent("Tile_detailDrawing");
        UIToggleButtonGroup passable_tbg = (UIToggleButtonGroup)this.getComponent("Tile_passable");
        UITextField label_tf = (UITextField)this.getComponent("Tile_textfield");
        UIButton b = null;
        b = (UIButton)this.getComponent("ApplyTileType_Button");
        if (b != null && b.getState() == UIButton.State.PRESSED) {
            boolean isPassable;
            if (label_tf.getCaption().isEmpty() || icon_tbg.getSelectedIndex() < 0) {
                this.addPopup(new Popup_Alert(this.p, "NoNameAlert", this.popupNoName));
                return;
            }
            String name = label_tf.getCaption();
            this.color = this.resolveColor(icon_tbg.getSelectedIndex());
            int dd_index = drawing_tbg.getSelectedIndex();
            boolean bl = isPassable = passable_tbg.getSelectedIndex() != 0;
            if (this.currentTT == null) {
                this.currentTTC.add(new TileType(name, this.color, dd_index, isPassable));
            } else {
                this.currentTT.setLabel(name);
                this.currentTT.setColor(this.color);
                this.currentTT.setDetailDrawing(dd_index);
                this.currentTT.setPassable(isPassable);
            }
            this.p.swapScreen(new Screen_TileList(this.p, this.currentTTC));
        }
        if ((b = (UIButton)this.getComponent("Back_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.p.swapPreviousScreen();
        }
        int prevColor = this.color;
        int icon_index = icon_tbg.getSelectedIndex();
        if (icon_index != -1) {
            this.color = this.resolveColor(icon_index);
        }
        if (prevColor != this.color) {
            this.updateTileInformation();
        }
    }

    @Override
    public void resolvePopup(Popup popup, int option) {
        super.resolvePopup(popup, option);
        if (!(popup instanceof Popup_YesNo) || !popup.getCaption().equalsIgnoreCase("NoNameAlert") || option == 1) {
            // empty if block
        }
    }

    protected void updateTileInformation() {
        UIToggleButtonGroup drawing_tbg = (UIToggleButtonGroup)this.getComponent("Tile_detailDrawing");
        drawing_tbg.clear();
        int count = 0;
        for (int i = 0; i < 10; ++i) {
            this.drawingRenderer.renderBackground(this.p.color(255));
            TileType.renderDetailDrawing(this.drawingRenderer, 0, 0, i, this.color);
            if (count > 0 && count % 5 == 0) {
                drawing_tbg.addButtonImageNextLine(this.drawingRenderer.getImage(), true);
            } else {
                drawing_tbg.addButtonImage(this.drawingRenderer.getImage(), true);
            }
            ++count;
            this.drawingRenderer.resetGraphics();
        }
    }

    protected int resolveColor() {
        UIToggleButtonGroup icon_tbg = (UIToggleButtonGroup)this.getComponent("Tile_color");
        return this.resolveColor(icon_tbg.getSelectedIndex());
    }

    protected int resolveColor(int icon_index) {
        return this.p.color(this.allowedColors[icon_index][0], this.allowedColors[icon_index][1], this.allowedColors[icon_index][2]);
    }

    protected void populateTileInformation(TileType type) {
        this.populateTileInformation();
        UIToggleButtonGroup icon_tbg = (UIToggleButtonGroup)this.getComponent("Tile_color");
        UIToggleButtonGroup drawing_tbg = (UIToggleButtonGroup)this.getComponent("Tile_detailDrawing");
        UIToggleButtonGroup passable_tbg = (UIToggleButtonGroup)this.getComponent("Tile_passable");
        UITextField label_tf = (UITextField)this.getComponent("Tile_textfield");
        if (type != null) {
            label_tf.setCaption(type.getLabel());
            int icon_index = this.getColorIndex(type);
            icon_tbg.setSelectedIndex(icon_index);
            this.color = this.resolveColor(icon_index);
            drawing_tbg.setSelectedIndex(type.getDetailDrawing());
            this.updateTileInformation();
            passable_tbg.setSelectedIndex(type.isPassable() ? 1 : 0);
        } else {
            label_tf.setCaption("");
            icon_tbg.setSelectedIndex(-1);
            drawing_tbg.setSelectedIndex(-1);
            passable_tbg.setSelectedIndex(0);
        }
    }

    protected void populateTileInformation() {
        this.addComponent("Tile_textfield_label", new UILabel(this.p, "Tile Name", 120, 100, 200, "Large"));
        UITextField label_tf = new UITextField(this.p, "", 120, 130, 200, "Large");
        if (this.blockNameEdits) {
            label_tf.disable();
        }
        this.addComponent("Tile_textfield", label_tf);
        this.addComponent("Tile_color_label", new UILabel(this.p, "Tile Color", 380, 100, 200, "Large"));
        UIToggleButtonGroup icon_tbg = new UIToggleButtonGroup(this.p, 320, 130, 20, 20, false);
        int count = 0;
        for (int i = 0; i < this.allowedColors.length; ++i) {
            this.iconRenderer.renderTile(0, 0, this.p.color(this.allowedColors[i][0], this.allowedColors[i][1], this.allowedColors[i][2]));
            if (count > 0 && count % 8 == 0) {
                icon_tbg.addButtonImageNextLine(this.iconRenderer.getImage(), true);
            } else {
                icon_tbg.addButtonImage(this.iconRenderer.getImage(), true);
            }
            ++count;
            this.iconRenderer.resetGraphics();
        }
        icon_tbg.setSelectedIndex(0);
        this.addComponent("Tile_color", icon_tbg);
        this.addComponent("Tile_detailDrawing_label", new UILabel(this.p, "Tile Drawing (detail)", 590, 100, 200, "Large"));
        this.addComponent("Tile_detailDrawing", new UIToggleButtonGroup(this.p, 540, 130, 20, 20, true));
        this.updateTileInformation();
        this.addComponent("Tile_passable_label", new UILabel(this.p, "Tile Properties", 720, 100, 200, "Large"));
        UIToggleButtonGroup passable_tbg = new UIToggleButtonGroup(this.p, 720, 130, 100, 20, false);
        passable_tbg.addButton("Impassable");
        passable_tbg.addButtonNextLine("Passable");
        this.addComponent("Tile_passable", passable_tbg);
    }

    protected int getColorIndex(TileType type) {
        int r = (int)this.p.red(type.getColor());
        int g = (int)this.p.green(type.getColor());
        int b = (int)this.p.blue(type.getColor());
        int index = 0;
        for (int i = 0; i < this.allowedColors.length; ++i) {
            if (Math.abs(this.allowedColors[i][0] - r) >= 70 || Math.abs(this.allowedColors[i][1] - g) >= 70 || Math.abs(this.allowedColors[i][2] - b) >= 70) continue;
            index = i;
        }
        return index;
    }
}

