/*
 * Decompiled with CFR 0.152.
 */
package generic.screens;

import generic.descriptors.TileType;
import generic.descriptors.TileTypeCollection;
import generic.screens.Screen_TileAdd;
import processing.core.PApplet;
import renderer.Render2D;
import ui.BaseApplet;
import ui.components.UIButton;
import ui.components.UIImage;
import ui.components.UILabel;
import ui.screens.Popup;
import ui.screens.Popup_Rename;
import ui.screens.Screen;

public class Screen_TileList
extends Screen {
    TileTypeCollection currentTTC;

    public Screen_TileList(BaseApplet p, TileTypeCollection ttc) {
        super(p);
        this.currentTTC = ttc;
        this.addComponent("Title", new UILabel(p, "Welcome to Sentient Sketchbook", p.width / 2, 30, "Huge"));
        this.addComponent("AddTileType_Button", new UIButton(p, "Add new Tile Type", p.width / 2, p.height - 150, "Huge"));
        this.addComponent("Save_Button", new UIButton(p, "Save Tile collection", p.width / 2, p.height - 110, "Huge"));
        this.addComponent("Back_Button", new UIButton(p, "Back", p.width / 2, p.height - 70, "Huge"));
        this.populateTileList();
    }

    @Override
    public void mouseClicked() {
        super.mouseClicked();
        UIButton b = null;
        b = (UIButton)this.getComponent("AddTileType_Button");
        if (b != null && b.getState() == UIButton.State.PRESSED) {
            this.p.swapScreen(new Screen_TileAdd(this.p, this.currentTTC));
        }
        if ((b = (UIButton)this.getComponent("Back_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.p.swapPreviousScreen();
        }
        if ((b = (UIButton)this.getComponent("Save_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.addPopup(new Popup_Rename(this.p, "FileAlert", "Choose the name for your tile collection:", "", "Save", "Cancel"));
        }
        for (int i = 0; i < this.currentTTC.size(); ++i) {
            b = (UIButton)this.getComponent("Tile" + i + "_edit_Button");
            if (b != null && b.getState() == UIButton.State.PRESSED) {
                if (i < 2) {
                    this.p.swapScreen(new Screen_TileAdd(this.p, this.currentTTC, (TileType)this.currentTTC.get(i), true));
                } else {
                    this.p.swapScreen(new Screen_TileAdd(this.p, this.currentTTC, (TileType)this.currentTTC.get(i)));
                }
            }
            if ((b = (UIButton)this.getComponent("Tile" + i + "_delete_Button")) == null || b.getState() != UIButton.State.PRESSED) continue;
            this.currentTTC.remove(i);
            this.p.replaceScreen(new Screen_TileList(this.p, this.currentTTC));
        }
    }

    @Override
    public void resolvePopup(Popup popup, int option) {
        if (popup instanceof Popup_Rename && popup.getID() == "FileAlert") {
            Popup_Rename popup_rn = (Popup_Rename)popup;
            String filename = popup_rn.getFieldContent();
            if (option == 1) {
                if (!filename.isEmpty()) {
                    this.currentTTC.saveToXML("./resources/setups/tiles/" + filename + ".xml");
                    super.resolvePopup(popup, option);
                }
            } else {
                super.resolvePopup(popup, option);
            }
        }
    }

    protected void populateTileList() {
        Render2D iconRenderer = new Render2D((PApplet)this.p, 1, 1, 20, 20);
        int currPositionY = 150;
        for (int i = 0; i < this.currentTTC.size(); ++i) {
            TileType tt = (TileType)this.currentTTC.get(i);
            UILabel uil = new UILabel(this.p, tt.getLabel() + " " + (tt.isPassable() ? "(passable)" : "(impassable)"), 0, currPositionY, "Large");
            uil.setBottomLeftPosition(250, currPositionY + uil.getHeight() / 2);
            this.addComponent("Tile" + i + "_label", uil);
            iconRenderer.renderTile(0, 0, tt.getColor());
            this.addComponent("Tile" + i + "_icon", new UIImage(this.p, iconRenderer.getImage(), 200, currPositionY));
            this.addComponent("Tile" + i + "_edit_Button", new UIButton(this.p, "Edit", 100, currPositionY, "Large"));
            if (i >= 2) {
                this.addComponent("Tile" + i + "_delete_Button", new UIButton(this.p, "Delete", 150, currPositionY, "Large"));
            }
            currPositionY += 30;
        }
    }
}

