/*
 * Decompiled with CFR 0.152.
 */
package platformer;

import java.util.Vector;
import platformer.PlatformMetrics;
import platformer.PlatformPaths;
import util.math2d.Point2D;
import util.statics.LogManager;
import util.statics.RandomNumberManager;

public class PlatformLevel {
    int mapSizeX;
    int mapSizeY;
    boolean[][] impassable;
    Vector<Point2D> starts;
    Vector<Point2D> goals;
    Vector<Point2D> monsters;
    Vector<Point2D> rewards;
    PlatformPaths paths;
    PlatformMetrics metrics;

    public PlatformLevel(int sizeX, int sizeY) {
        this.mapSizeX = sizeX;
        this.mapSizeY = sizeY;
        this.clearImpassable();
        this.starts = new Vector();
        this.goals = new Vector();
        this.monsters = new Vector();
        this.rewards = new Vector();
        this.paths = new PlatformPaths(this);
        this.metrics = new PlatformMetrics(this);
    }

    public PlatformLevel(PlatformLevel copy) {
        int i;
        this.mapSizeX = copy.mapSizeX;
        this.mapSizeY = copy.mapSizeX;
        this.clearImpassable();
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[x].length; ++y) {
                this.impassable[x][y] = copy.impassable[x][y];
            }
        }
        this.monsters = new Vector();
        for (i = 0; i < copy.monsters.size(); ++i) {
            this.monsters.add(new Point2D(copy.monsters.get(i)));
        }
        this.rewards = new Vector();
        for (i = 0; i < copy.rewards.size(); ++i) {
            this.rewards.add(new Point2D(copy.rewards.get(i)));
        }
        this.starts = new Vector();
        for (i = 0; i < copy.starts.size(); ++i) {
            this.starts.add(new Point2D(copy.starts.get(i)));
        }
        this.goals = new Vector();
        for (i = 0; i < copy.goals.size(); ++i) {
            this.goals.add(new Point2D(copy.goals.get(i)));
        }
        this.finalizeSketch();
    }

    public int getMapSizeX() {
        return this.mapSizeX;
    }

    public int getMapSizeY() {
        return this.mapSizeY;
    }

    public PlatformPaths getPaths() {
        return this.paths;
    }

    public PlatformMetrics getMetrics() {
        return this.metrics;
    }

    public int getTileDifference(PlatformLevel other) {
        if (other.mapSizeX != this.mapSizeX || other.mapSizeY != this.mapSizeY) {
            LogManager.writeError("Error", this, "Comparing differnet-sized sketches");
            return Integer.MAX_VALUE;
        }
        int result = 0;
        boolean[][] startArray = this.getStartArray();
        boolean[][] goalArray = this.getGoalArray();
        boolean[][] monsterArray = this.getMonsterArray();
        boolean[][] rewardArray = this.getRewardArray();
        boolean[][] otherStartArray = other.getStartArray();
        boolean[][] otherGoalArray = other.getGoalArray();
        boolean[][] otherMonsterArray = other.getMonsterArray();
        boolean[][] otherRewardArray = other.getRewardArray();
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[x].length; ++y) {
                if (this.impassable[x][y] == other.impassable[x][y] && startArray[x][y] == otherStartArray[x][y] && goalArray[x][y] == otherGoalArray[x][y] && rewardArray[x][y] == otherRewardArray[x][y] && monsterArray[x][y] == otherMonsterArray[x][y]) continue;
                ++result;
            }
        }
        return result;
    }

    public void clearImpassable() {
        this.impassable = new boolean[this.mapSizeX][this.mapSizeY];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                this.impassable[x][y] = false;
            }
        }
    }

    public boolean addMonster(int x, int y) {
        if (this.isWithinBounds(x, y) && !this.impassable[x][y] && this.getRewardIndex(x, y) == -1 && this.getMonsterIndex(x, y) == -1 && this.getStartIndex(x, y) == -1 && this.getGoalIndex(x, y) == -1) {
            this.monsters.add(new Point2D(x, y));
            return true;
        }
        return false;
    }

    public boolean removeMonster(int x, int y) {
        int index = this.getMonsterIndex(x, y);
        if (index != -1) {
            this.monsters.remove(index);
            return true;
        }
        return false;
    }

    public int getMonsterIndex(int x, int y) {
        for (int i = 0; i < this.monsters.size(); ++i) {
            if (this.monsters.get((int)i).x != (double)x || this.monsters.get((int)i).y != (double)y) continue;
            return i;
        }
        return -1;
    }

    public boolean addReward(int x, int y) {
        if (this.isWithinBounds(x, y) && !this.impassable[x][y] && this.getRewardIndex(x, y) == -1 && this.getMonsterIndex(x, y) == -1 && this.getStartIndex(x, y) == -1 && this.getGoalIndex(x, y) == -1) {
            this.rewards.add(new Point2D(x, y));
            return true;
        }
        return false;
    }

    public boolean removeReward(int x, int y) {
        int index = this.getRewardIndex(x, y);
        if (index != -1) {
            this.rewards.remove(index);
            return true;
        }
        return false;
    }

    public int getRewardIndex(int x, int y) {
        for (int i = 0; i < this.rewards.size(); ++i) {
            if (this.rewards.get((int)i).x != (double)x || this.rewards.get((int)i).y != (double)y) continue;
            return i;
        }
        return -1;
    }

    public boolean addStart(int x, int y) {
        if (this.isWithinBounds(x, y) && !this.impassable[x][y] && this.getRewardIndex(x, y) == -1 && this.getMonsterIndex(x, y) == -1 && this.getStartIndex(x, y) == -1 && this.getGoalIndex(x, y) == -1) {
            this.starts.add(new Point2D(x, y));
            return true;
        }
        return false;
    }

    public boolean removeStart(int x, int y) {
        int index = this.getStartIndex(x, y);
        if (index != -1) {
            this.starts.remove(index);
            return true;
        }
        return false;
    }

    public int getStartIndex(int x, int y) {
        for (int i = 0; i < this.starts.size(); ++i) {
            if (this.starts.get((int)i).x != (double)x || this.starts.get((int)i).y != (double)y) continue;
            return i;
        }
        return -1;
    }

    public boolean addGoal(int x, int y) {
        if (this.isWithinBounds(x, y) && !this.impassable[x][y] && this.getRewardIndex(x, y) == -1 && this.getMonsterIndex(x, y) == -1 && this.getStartIndex(x, y) == -1 && this.getGoalIndex(x, y) == -1) {
            this.goals.add(new Point2D(x, y));
            return true;
        }
        return false;
    }

    public boolean removeGoal(int x, int y) {
        int index = this.getStartIndex(x, y);
        if (index != -1) {
            this.goals.remove(index);
            return true;
        }
        return false;
    }

    public int getGoalIndex(int x, int y) {
        for (int i = 0; i < this.starts.size(); ++i) {
            if (this.goals.get((int)i).x != (double)x || this.goals.get((int)i).y != (double)y) continue;
            return i;
        }
        return -1;
    }

    public void setPassable(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            this.impassable[x][y] = false;
        }
    }

    public void setImpassable(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            this.impassable[x][y] = true;
        }
    }

    public void setPassable(boolean[][] pattern, int centerX, int centerY) {
        for (int x = 0; x < pattern.length; ++x) {
            for (int y = 0; y < pattern[0].length; ++y) {
                int global_y;
                int global_x;
                if (!pattern[x][y] || !this.isWithinBounds(global_x = centerX - pattern.length / 2 + x * pattern.length, global_y = centerY - pattern[0].length / 2 + y * pattern[0].length)) continue;
                this.impassable[global_x][global_y] = false;
            }
        }
    }

    public void setImpassable(boolean[][] pattern, int centerX, int centerY) {
        for (int x = 0; x < pattern.length; ++x) {
            for (int y = 0; y < pattern[0].length; ++y) {
                int global_y;
                int global_x;
                if (!pattern[x][y] || !this.isWithinBounds(global_x = centerX - pattern.length / 2 + x, global_y = centerY - pattern[0].length / 2 + y)) continue;
                this.impassable[global_x][global_y] = true;
            }
        }
    }

    public void setImpassableChunk(int centerX, int centerY, int sizeX, int sizeY) {
        for (int x = centerX - sizeX / 2; x < centerX + sizeX / 2; ++x) {
            for (int y = centerY - sizeY / 2; y < centerY + sizeY / 2; ++y) {
                if (!this.isWithinBounds(x, y)) continue;
                this.impassable[x][y] = true;
            }
        }
    }

    public int getStartLength() {
        return this.starts.size();
    }

    public int getGoalLength() {
        return this.goals.size();
    }

    public int getMonsterLength() {
        return this.monsters.size();
    }

    public int getRewardLength() {
        return this.rewards.size();
    }

    public Point2D getStart(int index) {
        return this.starts.get(index);
    }

    public Point2D getGoal(int index) {
        return this.goals.get(index);
    }

    public Point2D getMonster(int index) {
        return this.monsters.get(index);
    }

    public Point2D getReward(int index) {
        return this.rewards.get(index);
    }

    public boolean isStart(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            return this.inList(x, y, this.starts);
        }
        return false;
    }

    public boolean isGoal(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            return this.inList(x, y, this.goals);
        }
        return false;
    }

    public boolean isMonster(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            return this.inList(x, y, this.monsters);
        }
        return false;
    }

    public boolean isReward(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            return this.inList(x, y, this.rewards);
        }
        return false;
    }

    public boolean inList(int x, int y, Vector<Point2D> list) {
        for (int i = 0; i < list.size(); ++i) {
            Point2D currPoint = list.get(i);
            if (x != (int)currPoint.x || y != (int)currPoint.y) continue;
            return true;
        }
        return false;
    }

    public boolean inList(Point2D point, Vector<Point2D> list) {
        for (int i = 0; i < list.size(); ++i) {
            Point2D currPoint = list.get(i);
            if ((int)point.x != (int)currPoint.x || (int)point.y != (int)currPoint.y) continue;
            return true;
        }
        return false;
    }

    public void finalizeSketch() {
    }

    public boolean isPassable(int x, int y) {
        if (!this.isWithinBounds(x, y)) {
            return false;
        }
        return !this.impassable[x][y];
    }

    public boolean isWithinBounds(int x, int y) {
        return x >= 0 && x < this.mapSizeX && y >= 0 && y < this.mapSizeY;
    }

    public boolean isCorner(int x, int y) {
        if (x == 0 && y == 0) {
            return true;
        }
        if (x == 0 && y == this.mapSizeY - 1) {
            return true;
        }
        if (x == this.mapSizeX - 1 && y == 0) {
            return true;
        }
        return x == this.mapSizeX - 1 && y == this.mapSizeY - 1;
    }

    public boolean[][] getPassableArray() {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                result[x][y] = !this.impassable[x][y];
            }
        }
        return result;
    }

    public boolean[][] getImpassableArray() {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                result[x][y] = this.impassable[x][y];
            }
        }
        return result;
    }

    public boolean[][] getMonsterArray() {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                result[x][y] = false;
            }
        }
        for (int i = 0; i < this.monsters.size(); ++i) {
            result[(int)this.monsters.get((int)i).x][(int)this.monsters.get((int)i).y] = true;
        }
        return result;
    }

    public boolean[][] getRewardArray() {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                result[x][y] = false;
            }
        }
        for (int i = 0; i < this.rewards.size(); ++i) {
            result[(int)this.rewards.get((int)i).x][(int)this.rewards.get((int)i).y] = true;
        }
        return result;
    }

    public boolean[][] getStartArray() {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                result[x][y] = false;
            }
        }
        for (int i = 0; i < this.starts.size(); ++i) {
            result[(int)this.starts.get((int)i).x][(int)this.starts.get((int)i).y] = true;
        }
        return result;
    }

    public boolean[][] getGoalArray() {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                result[x][y] = false;
            }
        }
        for (int i = 0; i < this.goals.size(); ++i) {
            result[(int)this.goals.get((int)i).x][(int)this.goals.get((int)i).y] = true;
        }
        return result;
    }

    public boolean[][] getArray(Vector<Point2D> points) {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                result[x][y] = false;
            }
        }
        for (int i = 0; i < points.size(); ++i) {
            result[(int)points.get((int)i).x][(int)points.get((int)i).y] = true;
        }
        return result;
    }

    public void randomize(int startCount, int goalCount, int monsterCount, int rewardCount) {
        int y;
        int x;
        int i;
        this.starts.clear();
        for (i = 0; i < startCount; ++i) {
            x = RandomNumberManager.getRandomInt(0, this.mapSizeX);
            y = RandomNumberManager.getRandomInt(0, this.mapSizeY);
            this.addStart(x, y);
        }
        this.goals.clear();
        for (i = 0; i < goalCount; ++i) {
            x = RandomNumberManager.getRandomInt(0, this.mapSizeX);
            y = RandomNumberManager.getRandomInt(0, this.mapSizeY);
            this.addGoal(x, y);
        }
        this.monsters.clear();
        for (i = 0; i < monsterCount; ++i) {
            x = RandomNumberManager.getRandomInt(0, this.mapSizeX);
            y = RandomNumberManager.getRandomInt(0, this.mapSizeY);
            this.addMonster(x, y);
        }
        this.rewards.clear();
        for (i = 0; i < monsterCount; ++i) {
            x = RandomNumberManager.getRandomInt(0, this.mapSizeX);
            y = RandomNumberManager.getRandomInt(0, this.mapSizeY);
            this.addReward(x, y);
        }
    }

    public void randomizeChunks(int chunkCount) {
        this.clearImpassable();
        for (int i = 0; i < chunkCount; ++i) {
            int x = RandomNumberManager.getRandomInt(0, this.mapSizeX);
            int y = RandomNumberManager.getRandomInt(0, this.mapSizeY);
            this.impassable[x][y] = true;
        }
    }

    public String toASCII() {
        String result = "";
        for (int y = 0; y < this.mapSizeY; ++y) {
            for (int x = 0; x < this.mapSizeX; ++x) {
                result = this.impassable[x][y] ? result + "#" : (this.isGoal(x, y) ? result + "G" : (this.isStart(x, y) ? result + "S" : (this.isMonster(x, y) ? result + "m" : (this.isReward(x, y) ? result + "r" : result + "."))));
            }
            result = result + ";";
        }
        return result;
    }
}

