/*
 * Decompiled with CFR 0.152.
 */
package platformer.screens;

import platformer.PlatformLevel;
import processing.core.PApplet;
import processing.core.PImage;
import renderer.Render2D;
import ui.BaseApplet;
import ui.components.UIButton;
import ui.components.UIImage;
import ui.components.UILabel;
import ui.screens.Screen;

public class Screen_Intro
extends Screen {
    final int[] size = new int[]{1050, 665};

    public Screen_Intro(BaseApplet p) {
        super(p);
        p.size(this.size[0], this.size[1]);
        this.addComponent("Title", new UILabel(p, "Welcome to Sentient Sketchbook", p.width / 2, 30, "Huge"));
        this.addComponent("Map", new UIImage(p, this.generateMap(), p.width / 2, p.height / 2));
        this.addComponent("Regenerate_Button", new UIButton(p, "Regenerate", p.width / 2, p.height - 100, 280, "Huge"));
    }

    @Override
    public void mouseClicked() {
        super.mouseClicked();
        UIButton b = null;
        b = (UIButton)this.getComponent("Regenerate_Button");
        if (b != null && b.getState() == UIButton.State.PRESSED) {
            UIImage uiimg = (UIImage)this.getComponent("Map");
            uiimg.setImage(this.generateMap(), false);
        }
    }

    public PImage generateMap() {
        PlatformLevel pl = new PlatformLevel(15, 5);
        pl.addStart(0, 0);
        pl.addGoal(15, 5);
        boolean[][] passable = pl.getPassableArray();
        Render2D renderer = new Render2D((PApplet)this.p, pl.getMapSizeX(), pl.getMapSizeY(), 400, 200);
        renderer.renderTiles(passable, this.p.color(0, 200, 255), this.p.color(0, 128, 0));
        renderer.renderTiles(pl.getStartArray(), this.p.color(255));
        renderer.renderTiles(pl.getGoalArray(), this.p.color(0));
        renderer.renderTiles(pl.getMonsterArray(), this.p.color(255, 0, 0));
        renderer.renderTiles(pl.getRewardArray(), this.p.color(255, 255, 0));
        boolean[][] traversable = new boolean[pl.getMapSizeX()][pl.getMapSizeY()];
        for (int x = 0; x < passable.length; ++x) {
            for (int y = 0; y < passable[x].length - 1; ++y) {
                if (!passable[x][y] || passable[x][y + 1]) continue;
                traversable[x][y] = true;
                renderer.renderTile(x, y, this.p.color(255, 255, 0, 200));
            }
        }
        boolean[][] lateralJumps = new boolean[pl.getMapSizeX()][pl.getMapSizeY()];
        for (int x = 1; x < passable.length - 1; ++x) {
            for (int y = 0; y < passable[x].length; ++y) {
                if (!passable[x][y] || traversable[x][y] || !traversable[x - 1][y] || !traversable[x + 1][y]) continue;
                lateralJumps[x][y] = true;
            }
        }
        boolean[][] verticalJumps = new boolean[pl.getMapSizeX()][pl.getMapSizeY()];
        for (int x = 0; x < passable.length - 1; ++x) {
            for (int y = 0; y < passable[x].length - 1; ++y) {
                if (!traversable[x][y + 1] || !passable[x][y] || !traversable[x + 1][y]) continue;
                verticalJumps[x][y] = true;
            }
        }
        boolean[][] drops = new boolean[pl.getMapSizeX()][pl.getMapSizeY()];
        for (int x = 1; x < passable.length; ++x) {
            int y;
            for (int y2 = passable[x].length - 2; y2 >= 0; --y2) {
                if (!traversable[x][y2 + 1] && !drops[x][y2 + 1] || !passable[x][y2] || traversable[x][y2]) continue;
                drops[x][y2] = true;
            }
            boolean dropStarted = false;
            for (y = 0; y < passable[x].length; ++y) {
                if (dropStarted) continue;
                if (drops[x][y] && traversable[x - 1][y]) {
                    dropStarted = true;
                    continue;
                }
                drops[x][y] = false;
            }
            for (y = 0; y < passable[x].length; ++y) {
                if (!drops[x][y]) continue;
                renderer.renderTile(x, y, this.p.color(255, 0, 0, 200));
            }
        }
        return renderer.getImage();
    }
}

