/*
 * Decompiled with CFR 0.152.
 */
package strategymap;

import java.util.Vector;
import strategymap.StrategySketch;
import util.math2d.Matrix2D;
import util.math2d.Point2D;
import util.statics.RandomNumberManager;

public class DetailConverter {
    StrategySketch detailedView;
    StrategySketch sketch;
    int gridSizeX;
    int gridSizeY;
    final float connectionWidth = 0.2f;
    final float baseWidth = 0.2f;
    final float resourceRatio = 0.3f;
    Vector<boolean[][]> tilePatterns;

    public DetailConverter(StrategySketch sketch, int gridSizeX, int gridSizeY) {
        this.reset(sketch, gridSizeX, gridSizeY);
    }

    public void setSketch(StrategySketch sketch) {
        this.sketch = sketch;
        this.reset(sketch, this.gridSizeX, this.gridSizeY);
    }

    public void reset(StrategySketch sketch) {
        if (this.sketch != sketch) {
            this.setSketch(sketch);
        }
        this.detailedView = new StrategySketch(sketch.getMapSizeX() * this.gridSizeX, sketch.getMapSizeY() * this.gridSizeY);
        this.tilePatterns = new Vector();
        for (int x = 0; x < sketch.getMapSizeX(); ++x) {
            for (int y = 0; y < sketch.getMapSizeY(); ++y) {
                this.tilePatterns.add(new boolean[(int)Math.ceil((double)this.gridSizeX * 1.4)][(int)Math.ceil((double)this.gridSizeX * 1.4)]);
            }
        }
    }

    public void reset(StrategySketch sketch, int gridSizeX, int gridSizeY) {
        this.gridSizeX = gridSizeX;
        this.gridSizeY = gridSizeY;
        this.reset(sketch);
    }

    public int getGridSizeX() {
        return this.gridSizeX;
    }

    public int getGridSizeY() {
        return this.gridSizeY;
    }

    public void generateMap() {
        this.generateMap(2);
    }

    public void generateMap(int caIterations) {
        int i;
        for (int x = 0; x < this.sketch.getMapSizeX(); ++x) {
            for (int y = 0; y < this.sketch.getMapSizeY(); ++y) {
                this.generateChunk(x, y, true);
            }
        }
        this.remakeMap();
        for (i = 0; i < this.sketch.getBaseLength(); ++i) {
            Point2D b = this.sketch.getBase(i);
            this.generateBase((int)b.x, (int)b.y);
        }
        for (i = 0; i < this.sketch.getResourceLength(); ++i) {
            Point2D r = this.sketch.getResource(i);
            this.generateResource((int)r.x, (int)r.y);
        }
        for (i = 0; i < caIterations; ++i) {
            this.detailedView.impassable = i == 0 ? DetailConverter.runCellularFilter(this.detailedView.impassable) : Matrix2D.union(this.detailedView.impassable, DetailConverter.runCellularFilter(this.detailedView.impassable));
        }
    }

    public StrategySketch getMap() {
        return this.detailedView;
    }

    public StrategySketch getSketch() {
        return this.sketch;
    }

    public void generateChunk(int sketchX, int sketchY) {
        this.generateChunk(sketchX, sketchY, false);
    }

    public void generateChunk(int sketchX, int sketchY, boolean remakeNeighbours) {
        if (this.sketch.isWithinBounds(sketchX, sketchY)) {
            boolean[][] currentTile = this.tilePatterns.get(sketchX * this.sketch.getMapSizeX() + sketchY);
            for (int x = 0; x < currentTile.length; ++x) {
                for (int y = 0; y < currentTile[0].length; ++y) {
                    currentTile[x][y] = this.sketch.isPassable(sketchX, sketchY) ? false : ((double)x >= (double)this.gridSizeX * 0.5 && (double)y >= (double)this.gridSizeY * 0.5 && (double)x <= (double)this.gridSizeX * 0.9 && (double)y <= (double)this.gridSizeY * 0.9 ? true : ((double)x >= (double)this.gridSizeX * 0.2 && (double)y >= (double)this.gridSizeY * 0.2 && (double)x <= (double)this.gridSizeX * 1.2 && (double)y <= (double)this.gridSizeY * 1.2 ? RandomNumberManager.getRandomBoolean() : RandomNumberManager.getRandomInt(0, 5) == 0));
                }
            }
            if (!this.sketch.isPassable(sketchX, sketchY)) {
                this.makeConnections(sketchX, sketchY);
            }
            if (remakeNeighbours) {
                this.generateChunk(sketchX - 1, sketchY - 1, false);
                this.generateChunk(sketchX - 1, sketchY, false);
                this.generateChunk(sketchX - 1, sketchY + 1, false);
                this.generateChunk(sketchX, sketchY - 1, false);
                this.generateChunk(sketchX, sketchY + 1, false);
                this.generateChunk(sketchX + 1, sketchY - 1, false);
                this.generateChunk(sketchX + 1, sketchY, false);
                this.generateChunk(sketchX + 1, sketchY + 1, false);
            }
        }
    }

    protected void generateBase(int sketchX, int sketchY) {
        if (this.sketch.isWithinBounds(sketchX, sketchY)) {
            int midX = (int)((float)(sketchX * this.gridSizeX) + 0.5f * (float)this.gridSizeX);
            int midY = (int)((float)(sketchY * this.gridSizeY) + 0.5f * (float)this.gridSizeY);
            for (int x = midX - (int)(0.2f * (float)this.gridSizeX); x <= midX + (int)(0.2f * (float)this.gridSizeX); ++x) {
                for (int y = midY - (int)(0.2f * (float)this.gridSizeY); y <= midY + (int)(0.2f * (float)this.gridSizeY); ++y) {
                    this.detailedView.addBase(x, y);
                }
            }
        }
    }

    protected void removeBase(int sketchX, int sketchY) {
        if (this.sketch.isWithinBounds(sketchX, sketchY)) {
            for (int x = sketchX * this.gridSizeX; x < (sketchX + 1) * this.gridSizeX; ++x) {
                for (int y = sketchY * this.gridSizeY; y < (sketchY + 1) * this.gridSizeY; ++y) {
                    if (!this.detailedView.isBase(x, y)) continue;
                    this.detailedView.removeBase(x, y);
                }
            }
        }
    }

    protected void generateResource(int sketchX, int sketchY) {
        if (this.sketch.isWithinBounds(sketchX, sketchY)) {
            int placedResources = 0;
            int targetResources = (int)(0.3f * (float)this.gridSizeX * (float)this.gridSizeY);
            while (placedResources < targetResources) {
                int randY;
                int randX = sketchX * this.gridSizeX + RandomNumberManager.getRandomInt(0, this.gridSizeX);
                if (!this.detailedView.isPassable(randX, randY = sketchY * this.gridSizeY + RandomNumberManager.getRandomInt(0, this.gridSizeY)) || this.detailedView.isBase(randX, randY) || this.detailedView.isResource(randX, randY)) continue;
                this.detailedView.addResource(randX, randY);
                ++placedResources;
            }
        }
    }

    protected void removeResource(int sketchX, int sketchY) {
        if (this.sketch.isWithinBounds(sketchX, sketchY)) {
            for (int x = sketchX * this.gridSizeX; x < (sketchX + 1) * this.gridSizeX; ++x) {
                for (int y = sketchY * this.gridSizeY; y < (sketchY + 1) * this.gridSizeY; ++y) {
                    if (!this.detailedView.isResource(x, y)) continue;
                    this.detailedView.removeResource(x, y);
                }
            }
        }
    }

    protected void makeConnections(int sketchX, int sketchY) {
        if (this.sketch.isWithinBounds(sketchX, sketchY)) {
            this.makeConnectionTop(sketchX, sketchY);
            this.makeConnectionLeft(sketchX, sketchY);
            this.makeConnectionBottom(sketchX, sketchY);
            this.makeConnectionRight(sketchX, sketchY);
            this.makeConnectionTopLeft(sketchX, sketchY);
            this.makeConnectionTopRight(sketchX, sketchY);
            this.makeConnectionBottomLeft(sketchX, sketchY);
            this.makeConnectionBottomRight(sketchX, sketchY);
        }
    }

    protected void makeConnectionTop(int sketchX, int sketchY) {
        if (this.sketch.isWithinBounds(sketchX, sketchY) && !this.sketch.isPassable(sketchX, sketchY - 1)) {
            boolean[][] currentTile = this.tilePatterns.get(sketchX * this.sketch.getMapSizeX() + sketchY);
            for (int x = currentTile.length / 2 - (int)((float)this.gridSizeX * 0.2f); x <= currentTile.length / 2 + (int)((float)this.gridSizeX * 0.2f); ++x) {
                for (int y = 0; y < currentTile[0].length / 2; ++y) {
                    currentTile[x][y] = true;
                }
            }
        }
    }

    protected void makeConnectionLeft(int sketchX, int sketchY) {
        if (this.sketch.isWithinBounds(sketchX, sketchY) && !this.sketch.isPassable(sketchX - 1, sketchY)) {
            boolean[][] currentTile = this.tilePatterns.get(sketchX * this.sketch.getMapSizeX() + sketchY);
            for (int x = 0; x < currentTile.length / 2; ++x) {
                for (int y = currentTile[0].length / 2 - (int)((float)this.gridSizeY * 0.2f); y <= currentTile[0].length / 2 + (int)((float)this.gridSizeY * 0.2f); ++y) {
                    currentTile[x][y] = true;
                }
            }
        }
    }

    protected void makeConnectionBottom(int sketchX, int sketchY) {
        if (this.sketch.isWithinBounds(sketchX, sketchY) && !this.sketch.isPassable(sketchX, sketchY + 1)) {
            boolean[][] currentTile = this.tilePatterns.get(sketchX * this.sketch.getMapSizeX() + sketchY);
            for (int x = currentTile.length / 2 - (int)((float)this.gridSizeX * 0.2f); x <= currentTile.length / 2 + (int)((float)this.gridSizeX * 0.2f); ++x) {
                for (int y = currentTile[0].length / 2; y < currentTile[0].length; ++y) {
                    currentTile[x][y] = true;
                }
            }
        }
    }

    protected void makeConnectionRight(int sketchX, int sketchY) {
        if (this.sketch.isWithinBounds(sketchX, sketchY) && !this.sketch.isPassable(sketchX + 1, sketchY)) {
            boolean[][] currentTile = this.tilePatterns.get(sketchX * this.sketch.getMapSizeX() + sketchY);
            for (int x = currentTile.length / 2; x < currentTile.length; ++x) {
                for (int y = currentTile[0].length / 2 - (int)((float)this.gridSizeY * 0.2f); y <= currentTile[0].length / 2 + (int)((float)this.gridSizeY * 0.2f); ++y) {
                    currentTile[x][y] = true;
                }
            }
        }
    }

    protected void makeConnectionTopLeft(int sketchX, int sketchY) {
        if (this.sketch.isWithinBounds(sketchX, sketchY) && !this.sketch.isPassable(sketchX - 1, sketchY - 1)) {
            boolean[][] currentTile = this.tilePatterns.get(sketchX * this.sketch.getMapSizeX() + sketchY);
            double diag = (float)currentTile[0].length / (float)currentTile.length;
            for (int x = 0; x < currentTile.length / 2; ++x) {
                for (int y = (int)(diag * (double)x - (double)((float)this.gridSizeY * 0.2f)); y <= (int)(diag * (double)x + (double)((float)this.gridSizeY * 0.2f)); ++y) {
                    if (y < 0 || y >= currentTile[0].length) continue;
                    currentTile[x][y] = true;
                }
            }
        }
    }

    protected void makeConnectionBottomLeft(int sketchX, int sketchY) {
        if (this.sketch.isWithinBounds(sketchX, sketchY) && !this.sketch.isPassable(sketchX - 1, sketchY + 1)) {
            boolean[][] currentTile = this.tilePatterns.get(sketchX * this.sketch.getMapSizeX() + sketchY);
            double diag = (float)currentTile[0].length / (float)currentTile.length;
            for (int x = 0; x < currentTile.length / 2; ++x) {
                for (int y = currentTile[0].length + (int)(-diag * (double)x - (double)((float)this.gridSizeY * 0.2f)); y <= currentTile[0].length + (int)(-diag * (double)x + (double)((float)this.gridSizeY * 0.2f)); ++y) {
                    if (y < 0 || y >= currentTile[0].length) continue;
                    currentTile[x][y] = true;
                }
            }
        }
    }

    protected void makeConnectionBottomRight(int sketchX, int sketchY) {
        if (this.sketch.isWithinBounds(sketchX, sketchY) && !this.sketch.isPassable(sketchX + 1, sketchY + 1)) {
            boolean[][] currentTile = this.tilePatterns.get(sketchX * this.sketch.getMapSizeX() + sketchY);
            double diag = (float)currentTile[0].length / (float)currentTile.length;
            for (int x = currentTile.length / 2; x < currentTile.length; ++x) {
                for (int y = (int)(diag * (double)x - (double)((float)this.gridSizeY * 0.2f)); y <= (int)(diag * (double)x + (double)((float)this.gridSizeY * 0.2f)); ++y) {
                    if (y < 0 || y >= currentTile[0].length) continue;
                    currentTile[x][y] = true;
                }
            }
        }
    }

    protected void makeConnectionTopRight(int sketchX, int sketchY) {
        if (this.sketch.isWithinBounds(sketchX, sketchY) && !this.sketch.isPassable(sketchX + 1, sketchY - 1)) {
            boolean[][] currentTile = this.tilePatterns.get(sketchX * this.sketch.getMapSizeX() + sketchY);
            double diag = (float)currentTile[0].length / (float)currentTile.length;
            for (int x = currentTile.length / 2; x < currentTile.length; ++x) {
                for (int y = currentTile[0].length + (int)(-diag * (double)x - (double)((float)this.gridSizeY * 0.2f)); y <= currentTile[0].length + (int)(-diag * (double)x + (double)((float)this.gridSizeY * 0.2f)); ++y) {
                    if (y < 0 || y >= currentTile[0].length) continue;
                    currentTile[x][y] = true;
                }
            }
        }
    }

    protected void remakeMap() {
        for (int x = 0; x < this.detailedView.getMapSizeX(); ++x) {
            for (int y = 0; y < this.detailedView.getMapSizeY(); ++y) {
                this.detailedView.setPassable(x, y);
            }
        }
        for (int i = 0; i < this.tilePatterns.size(); ++i) {
            boolean[][] currentTile = this.tilePatterns.get(i);
            int g_x = (int)Math.floor(i / this.sketch.getMapSizeX());
            int g_y = i % this.sketch.getMapSizeX();
            for (int x = 0; x < currentTile.length; ++x) {
                for (int y = 0; y < currentTile[0].length; ++y) {
                    int coordX = (int)((double)(g_x * this.gridSizeX + x) - 0.2 * (double)this.gridSizeX);
                    int coordY = (int)((double)(g_y * this.gridSizeY + y) - 0.2 * (double)this.gridSizeY);
                    if (!this.detailedView.isWithinBounds(coordX, coordY) || !currentTile[x][y]) continue;
                    this.detailedView.setImpassable(coordX, coordY);
                }
            }
        }
    }

    public boolean[][] getMapPatterns() {
        boolean[][] result = new boolean[this.detailedView.getMapSizeX()][this.detailedView.getMapSizeY()];
        for (int x = 0; x < result.length; ++x) {
            for (int y = 0; y < result[0].length; ++y) {
                result[x][y] = false;
            }
        }
        for (int i = 0; i < this.tilePatterns.size(); ++i) {
            boolean[][] currentTile = this.tilePatterns.get(i);
            int g_x = (int)Math.floor(i / this.sketch.getMapSizeX());
            int g_y = i % this.sketch.getMapSizeX();
            for (int x = 0; x < currentTile.length; ++x) {
                for (int y = 0; y < currentTile[0].length; ++y) {
                    int coordX = (int)((double)(g_x * this.gridSizeX + x) - 0.2 * (double)this.gridSizeX);
                    int coordY = (int)((double)(g_y * this.gridSizeY + y) - 0.2 * (double)this.gridSizeY);
                    if (coordX < 0 || coordX >= result.length || coordY < 0 || coordY >= result[0].length || !currentTile[x][y]) continue;
                    result[coordX][coordY] = true;
                }
            }
        }
        return result;
    }

    public static boolean[][] runCellularFilter(boolean[][] initial) {
        boolean[][] result = new boolean[initial.length][initial[0].length];
        for (int x = 0; x < initial.length; ++x) {
            for (int y = 0; y < initial[0].length; ++y) {
                int totalWalls = 0;
                for (int i = x - 1; i <= x + 1; ++i) {
                    for (int j = y - 1; j <= y + 1; ++j) {
                        if (i >= 0 && i < initial.length && j >= 0 && j < initial[0].length) {
                            if (!initial[i][j]) continue;
                            ++totalWalls;
                            continue;
                        }
                        if (i == j || i == initial[0].length - j) continue;
                        ++totalWalls;
                    }
                }
                result[x][y] = totalWalls >= 5;
            }
        }
        return result;
    }

    public static boolean[][] runRandomizeFilter(boolean[][] initial) {
        boolean[][] result = new boolean[initial.length][initial[0].length];
        for (int x = 0; x < initial.length; ++x) {
            for (int y = 0; y < initial[0].length; ++y) {
                int totalWalls = 0;
                for (int i = x - 1; i <= x + 1; ++i) {
                    for (int j = y - 1; j <= y + 1; ++j) {
                        if (i == j || i < 0 || i >= initial.length || j < 0 || j >= initial[0].length || !initial[i][j]) continue;
                        ++totalWalls;
                    }
                }
                result[x][y] = RandomNumberManager.getRandomInt(0, 9) < totalWalls;
            }
        }
        return result;
    }

    public static boolean[][] runSparseRandomizeFilter(boolean[][] initial) {
        boolean[][] result = new boolean[initial.length][initial[0].length];
        for (int x = 0; x < initial.length; ++x) {
            for (int y = 0; y < initial[0].length; ++y) {
                int totalWalls = 0;
                for (int i = x - 1; i <= x + 1; ++i) {
                    for (int j = y - 1; j <= y + 1; ++j) {
                        if (i == j || i < 0 || i >= initial.length || j < 0 || j >= initial[0].length || !initial[i][j]) continue;
                        ++totalWalls;
                    }
                }
                result[x][y] = RandomNumberManager.getRandomInt(0, 15) < totalWalls;
            }
        }
        return result;
    }

    public static boolean[][] runCompletelyRandomizeFilter(boolean[][] initial) {
        boolean[][] result = new boolean[initial.length][initial[0].length];
        for (int x = 0; x < initial.length; ++x) {
            for (int y = 0; y < initial[0].length; ++y) {
                if (!initial[x][y]) continue;
                result[x][y] = RandomNumberManager.getRandomBoolean();
            }
        }
        return result;
    }

    public static boolean isCorner(int x, int y, boolean[][] initial) {
        if (x == 0 && y == 0) {
            return true;
        }
        if (x == initial.length && y == 0) {
            return true;
        }
        if (x == initial.length && y == initial[0].length) {
            return true;
        }
        return x == 0 && y == initial[0].length;
    }
}

