/*
 * Decompiled with CFR 0.152.
 */
package strategymap;

import ai.pathfinder.Connector;
import ai.pathfinder.Node;
import ai.pathfinder.Pathfinder;
import common.NodeClosenessComparator;
import common.PathLibrary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Vector;
import strategymap.StrategySketch;
import util.math2d.Matrix2D;
import util.math2d.Point2D;
import util.statics.LogManager;

public class StrategyPaths {
    StrategySketch parent;
    Pathfinder astar;
    Vector<ArrayList> basePaths;
    Vector<ArrayList> resourcePaths;
    Vector<ArrayList> basePathChokePoints;
    Vector<ArrayList> resourcePathChokePoints;
    boolean[][] chokePoints;
    boolean[][] deadEnds;
    boolean[][] openAreas;
    int[][] branchingFactor;
    float averageBranchingFactor;
    boolean[][] unusedSpaces;
    Vector<float[]> resourceSafety;
    float[][][] safetyMatrix;
    float[][][] explorationMatrix;

    public StrategyPaths(StrategySketch parent) {
        this.parent = parent;
    }

    public void init() {
        this.astar = new Pathfinder();
        boolean spacing = true;
        this.astar.setCuboidNodes(this.parent.getMapSizeX(), this.parent.getMapSizeY(), (float)spacing);
        for (Object temp : this.astar.nodes) {
            Node n = (Node)temp;
            n.walkable = this.parent.isPassable((int)n.x, (int)n.y);
        }
        this.astar.radialDisconnectUnwalkables();
    }

    public Node findNode(int x, int y) {
        return PathLibrary.findNode(x, y, this.astar);
    }

    public void calculateAllPaths() {
        ArrayList path;
        int j;
        int i;
        if (this.astar == null) {
            this.init();
        }
        this.basePaths = new Vector();
        for (i = 0; i < this.parent.bases.size(); ++i) {
            for (j = i + 1; j < this.parent.bases.size(); ++j) {
                path = this.getPath((int)this.parent.bases.get((int)j).x, (int)this.parent.bases.get((int)j).y, (int)this.parent.bases.get((int)i).x, (int)this.parent.bases.get((int)i).y);
                if (path == null) continue;
                this.basePaths.add(path);
            }
        }
        this.resourcePaths = new Vector();
        for (i = 0; i < this.parent.bases.size(); ++i) {
            for (j = 0; j < this.parent.resources.size(); ++j) {
                path = this.getPath((int)this.parent.resources.get((int)j).x, (int)this.parent.resources.get((int)j).y, (int)this.parent.bases.get((int)i).x, (int)this.parent.bases.get((int)i).y);
                if (path == null) continue;
                this.resourcePaths.add(path);
            }
        }
    }

    public void calculateEmptySpace() {
        Vector<Point2D> points;
        int i;
        if (this.astar == null) {
            this.init();
        }
        if (this.basePaths == null || this.resourcePaths == null) {
            this.calculateAllPaths();
        }
        this.unusedSpaces = Matrix2D.invert(this.parent.getImpassableArray());
        this.unusedSpaces = Matrix2D.intersection(this.unusedSpaces, Matrix2D.invert(this.parent.getBaseArray()));
        this.unusedSpaces = Matrix2D.intersection(this.unusedSpaces, Matrix2D.invert(this.parent.getResourceArray()));
        for (i = 0; i < this.basePaths.size(); ++i) {
            points = PathLibrary.transformPath(this.basePaths.get(i));
            this.unusedSpaces = Matrix2D.intersection(this.unusedSpaces, Matrix2D.invert(PathLibrary.transformPath(points, this.unusedSpaces.length, this.unusedSpaces[0].length)));
        }
        for (i = 0; i < this.resourcePaths.size(); ++i) {
            points = PathLibrary.transformPath(this.resourcePaths.get(i));
            this.unusedSpaces = Matrix2D.intersection(this.unusedSpaces, Matrix2D.invert(PathLibrary.transformPath(points, this.unusedSpaces.length, this.unusedSpaces[0].length)));
        }
    }

    public void calculateNavigationInfo() {
        if (this.astar == null) {
            this.init();
        }
        this.chokePoints = new boolean[this.parent.getMapSizeX()][this.parent.getMapSizeY()];
        this.deadEnds = new boolean[this.parent.getMapSizeX()][this.parent.getMapSizeY()];
        this.openAreas = new boolean[this.parent.getMapSizeX()][this.parent.getMapSizeY()];
        this.branchingFactor = new int[this.parent.getMapSizeX()][this.parent.getMapSizeY()];
        this.averageBranchingFactor = 0.0f;
        int totalWalkable = 0;
        for (int x = 0; x < this.chokePoints.length; ++x) {
            for (int y = 0; y < this.chokePoints[0].length; ++y) {
                this.chokePoints[x][y] = false;
                this.deadEnds[x][y] = false;
                this.openAreas[x][y] = false;
            }
        }
        for (int i = 0; i < this.astar.nodes.size(); ++i) {
            Node n = (Node)this.astar.nodes.get(i);
            if (!n.walkable) continue;
            boolean j = false;
            ++totalWalkable;
            this.branchingFactor[(int)n.x][(int)n.y] = n.links.size();
            this.averageBranchingFactor += (float)n.links.size();
            if (n.links.size() == 1) {
                this.deadEnds[(int)n.x][(int)n.y] = true;
            }
            if (n.links.size() == 2) {
                this.chokePoints[(int)n.x][(int)n.y] = true;
            }
            if (n.links.size() != 8) continue;
            this.openAreas[(int)n.x][(int)n.y] = true;
        }
        this.averageBranchingFactor /= (float)totalWalkable;
    }

    public Vector<Point2D> calculateChokePoints(ArrayList path) {
        Vector<Point2D> result = new Vector<Point2D>();
        if (this.chokePoints == null) {
            this.calculateNavigationInfo();
        }
        for (int i = 1; i < path.size() - 1; ++i) {
            Node n = (Node)path.get(i);
            if (!this.isChokePoint((int)n.x, (int)n.y)) continue;
            result.add(new Point2D(n.x, n.y));
        }
        return result;
    }

    public boolean isChokePoint(int x, int y) {
        if (this.chokePoints == null) {
            this.calculateNavigationInfo();
        }
        if (x < 0 || y < 0 || x >= this.chokePoints.length || y >= this.chokePoints[0].length) {
            LogManager.writeError("Error", this, "Point out of bounds");
            return false;
        }
        return this.chokePoints[x][y];
    }

    public Vector<Point2D> getNearbyResources(int baseIndex, float maxDistanceRatio) {
        if (this.resourceSafety == null) {
            this.calculateResourceSafety();
        }
        float[] candidates = this.resourceSafety.get(baseIndex);
        Vector<Point2D> result = new Vector<Point2D>();
        for (int j = 0; j < candidates.length; ++j) {
            if (!(candidates[j] > maxDistanceRatio)) continue;
            result.add(this.parent.resources.get(j));
        }
        return result;
    }

    public Vector<Point2D> getUnsafeResources(float maxDistanceRatio) {
        if (this.resourceSafety == null) {
            this.calculateResourceSafety();
        }
        Vector<Point2D> allSafe = new Vector<Point2D>();
        for (int i = 0; i < this.parent.getBaseLength(); ++i) {
            allSafe.addAll(this.getNearbyResources(i, maxDistanceRatio));
        }
        Vector<Point2D> result = new Vector<Point2D>();
        for (int i = 0; i < this.parent.getResourceLength(); ++i) {
            if (allSafe.contains(this.parent.getResource(i))) continue;
            result.add(this.parent.getResource(i));
        }
        return result;
    }

    protected float[] calculateResourceDistanceRatio(int resourceIndex) {
        if (resourceIndex < 0 || resourceIndex >= this.parent.resources.size()) {
            LogManager.writeError("Error", this, "Resource index out of bounds");
            return null;
        }
        return this.calculateDistanceRatio(this.parent.resources.get(resourceIndex));
    }

    protected float[] calculateDistanceRatio(Point2D point) {
        return this.calculateDistanceRatio((int)point.x, (int)point.y);
    }

    protected float[] calculateDistanceRatio(int x, int y) {
        int i;
        float[] result = new float[this.parent.bases.size()];
        if (!this.parent.isPassable(x, y)) {
            return result;
        }
        float[] dist = new float[this.parent.bases.size()];
        for (i = 0; i < this.parent.bases.size(); ++i) {
            dist[i] = -1.0f;
            ArrayList path = this.getPath(this.parent.bases.get(i), x, y);
            if (!PathLibrary.hasStart(path, x, y) && !PathLibrary.hasEnd(path, x, y)) continue;
            dist[i] = PathLibrary.calculateDistance(path);
        }
        for (i = 0; i < result.length; ++i) {
            if (dist[i] == -1.0f) {
                result[i] = -1.0f;
                continue;
            }
            result[i] = 1.0f;
            for (int j = 0; j < result.length; ++j) {
                if (i == j || result[j] == -1.0f) continue;
                result[i] = Math.min(result[i], Math.max(0.0f, (dist[j] - dist[i]) / (dist[i] + dist[j])));
            }
        }
        return result;
    }

    protected float[] calculateDistanceRatio(Vector<Point2D> refTiles, Point2D point) {
        return this.calculateDistanceRatio(refTiles, (int)point.x, (int)point.y);
    }

    protected float[] calculateDistanceRatio(Vector<Point2D> refTiles, int x, int y) {
        int i;
        float[] result = new float[refTiles.size()];
        if (!this.parent.isPassable(x, y)) {
            return result;
        }
        float[] dist = new float[refTiles.size()];
        for (i = 0; i < refTiles.size(); ++i) {
            dist[i] = -1.0f;
            ArrayList path = this.getPath(refTiles.get(i), x, y);
            if (!PathLibrary.hasStart(path, x, y) && !PathLibrary.hasEnd(path, x, y)) continue;
            dist[i] = PathLibrary.calculateDistance(path);
        }
        for (i = 0; i < result.length; ++i) {
            if (dist[i] == -1.0f) {
                result[i] = -1.0f;
                continue;
            }
            result[i] = 1.0f;
            for (int j = 0; j < result.length; ++j) {
                if (i == j || result[j] == -1.0f) continue;
                result[i] = Math.min(result[i], Math.max(0.0f, (dist[j] - dist[i]) / (dist[i] + dist[j])));
            }
        }
        return result;
    }

    public float[][][] getCustomSafetyMatrix(Vector<Point2D> tiles) {
        float[][][] result = new float[this.parent.getMapSizeX()][this.parent.getMapSizeY()][tiles.size()];
        for (int x = 0; x < this.parent.getMapSizeX(); ++x) {
            for (int y = 0; y < this.parent.getMapSizeY(); ++y) {
                result[x][y] = this.calculateDistanceRatio(tiles, x, y);
            }
        }
        return result;
    }

    public float[][] getCustomSafetyMatrix(float[][][] customSafety, int index) {
        float[][] result = new float[customSafety.length][customSafety[0].length];
        for (int x = 0; x < this.parent.getMapSizeX(); ++x) {
            for (int y = 0; y < this.parent.getMapSizeY(); ++y) {
                result[x][y] = customSafety[x][y][index];
            }
        }
        return result;
    }

    public void calculateSafetyMatrix() {
        this.safetyMatrix = new float[this.parent.getMapSizeX()][this.parent.getMapSizeY()][this.parent.bases.size()];
        for (int x = 0; x < this.parent.getMapSizeX(); ++x) {
            for (int y = 0; y < this.parent.getMapSizeY(); ++y) {
                this.safetyMatrix[x][y] = this.calculateDistanceRatio(x, y);
            }
        }
    }

    public float[][] getSafetyMatrix(int baseIndex) {
        if (this.safetyMatrix == null) {
            this.calculateSafetyMatrix();
        }
        float[][] result = new float[this.parent.getMapSizeX()][this.parent.getMapSizeY()];
        for (int x = 0; x < this.parent.getMapSizeX(); ++x) {
            for (int y = 0; y < this.parent.getMapSizeY(); ++y) {
                result[x][y] = this.safetyMatrix[x][y][baseIndex];
            }
        }
        return result;
    }

    public float getSafety(int x, int y, int baseIndex) {
        if (this.safetyMatrix == null) {
            this.calculateSafetyMatrix();
        }
        return this.safetyMatrix[x][y][baseIndex];
    }

    public float[] getSafety(int x, int y) {
        if (this.safetyMatrix == null) {
            this.calculateSafetyMatrix();
        }
        return Arrays.copyOf(this.safetyMatrix[x][y], this.safetyMatrix[x][y].length);
    }

    public void calculateResourceSafety() {
        this.resourceSafety = new Vector();
        for (int j = 0; j < this.parent.getResourceLength(); ++j) {
            this.resourceSafety.add(this.calculateResourceDistanceRatio(j));
        }
    }

    public float[] getResourceSafety(int resourceIndex) {
        if (this.resourceSafety == null) {
            this.calculateResourceSafety();
        }
        return this.resourceSafety.get(resourceIndex);
    }

    protected float[][] exploreTo(boolean[][] pixels, Point2D startingPixel, Point2D endingPixel) {
        int x = (int)startingPixel.x;
        int y = (int)startingPixel.y;
        float[][] result = new float[pixels.length][pixels[0].length];
        double midpointX = (double)(pixels.length + 1) / 2.0;
        double midpointY = (double)(pixels[0].length + 1) / 2.0;
        if (pixels[x][y]) {
            LinkedList<Point2D> queue = new LinkedList<Point2D>();
            queue.add(new Point2D(x, y));
            while (!queue.isEmpty() && result[(int)endingPixel.x][(int)endingPixel.y] != 1.0f) {
                Point2D point = (Point2D)queue.remove();
                if (!(point.x >= 0.0) || !(point.y >= 0.0) || !(point.x < (double)pixels.length) || !(point.y < (double)pixels[0].length) || !pixels[(int)point.x][(int)point.y]) continue;
                pixels[(int)point.x][(int)point.y] = false;
                result[(int)point.x][(int)point.y] = 1.0f;
                queue.addAll(StrategyPaths.getPrioritizedAdjacent(point, this.astar, midpointX, midpointY, false));
            }
        }
        return result;
    }

    public static Node findNode(Point2D point, Pathfinder pf) {
        return StrategyPaths.findNode((int)point.x, (int)point.y, pf);
    }

    public static Node findNode(int x, int y, Pathfinder pf) {
        for (Object temp : pf.nodes) {
            Node n = (Node)temp;
            if (n.x != (float)x || n.y != (float)y) continue;
            return n;
        }
        return null;
    }

    public static Vector<Point2D> getPrioritizedAdjacent(Point2D point, Pathfinder pf, Point2D target) {
        return StrategyPaths.getPrioritizedAdjacent(point.x, point.y, pf, target.x, target.y, true);
    }

    public static Vector<Point2D> getPrioritizedAdjacent(Point2D point, Pathfinder pf, Point2D target, boolean diagonals) {
        return StrategyPaths.getPrioritizedAdjacent(point.x, point.y, pf, target, diagonals);
    }

    public static Vector<Point2D> getPrioritizedAdjacent(Point2D point, Pathfinder pf, double target_x, double target_y, boolean diagonals) {
        return StrategyPaths.getPrioritizedAdjacent(point.x, point.y, pf, target_x, target_y, diagonals);
    }

    public static Vector<Point2D> getPrioritizedAdjacent(double x, double y, Pathfinder pf, Point2D target, boolean diagonals) {
        return StrategyPaths.getPrioritizedAdjacent(x, y, pf, target.x, target.y, diagonals);
    }

    public static Vector<Point2D> getPrioritizedAdjacent(double x, double y, Pathfinder pf, double target_x, double target_y, boolean diagonals) {
        Node n1 = StrategyPaths.findNode((int)x, (int)y, pf);
        Vector<Point2D> result = new Vector<Point2D>();
        for (int i = 0; i < n1.links.size(); ++i) {
            Connector link = (Connector)n1.links.get(i);
            if (diagonals) {
                result.add(new Point2D(link.n.x, link.n.y));
                continue;
            }
            if (x != (double)((int)link.n.x) && y != (double)((int)link.n.y)) continue;
            result.add(new Point2D(link.n.x, link.n.y));
        }
        NodeClosenessComparator ncc = new NodeClosenessComparator(target_x, target_y);
        Collections.sort(result, ncc);
        return result;
    }

    public void calculateExplorationMatrix() {
        this.explorationMatrix = new float[this.parent.getMapSizeX()][this.parent.getMapSizeY()][this.parent.bases.size()];
        float increment = 1.0f / (float)(this.parent.getBaseLength() - 1);
        for (int i = 0; i < this.parent.getBaseLength(); ++i) {
            for (int j = 0; j < this.parent.getBaseLength(); ++j) {
                if (i == j) continue;
                float[][] temp = this.exploreTo(Matrix2D.invert(this.parent.impassable), this.parent.getBase(i), this.parent.getBase(j));
                for (int x = 0; x < temp.length; ++x) {
                    for (int y = 0; y < temp[0].length; ++y) {
                        float[] fArray = this.explorationMatrix[x][y];
                        int n = i;
                        fArray[n] = fArray[n] + temp[x][y] * increment;
                    }
                }
            }
        }
    }

    public float[][] getExplorationMatrix(int baseIndex) {
        if (this.explorationMatrix == null) {
            this.calculateExplorationMatrix();
        }
        float[][] result = new float[this.parent.getMapSizeX()][this.parent.getMapSizeY()];
        for (int x = 0; x < this.parent.getMapSizeX(); ++x) {
            for (int y = 0; y < this.parent.getMapSizeY(); ++y) {
                result[x][y] = this.explorationMatrix[x][y][baseIndex];
            }
        }
        return result;
    }

    public Vector<ArrayList> getResourcePaths() {
        return this.resourcePaths;
    }

    public Vector<ArrayList> getBasePaths() {
        return this.basePaths;
    }

    public int getResourcePathLength() {
        return this.resourcePaths.size();
    }

    public int getBasePathLength() {
        return this.basePaths.size();
    }

    public boolean[][] getChokePoints() {
        if (this.chokePoints == null) {
            this.calculateNavigationInfo();
        }
        return Matrix2D.copy(this.chokePoints);
    }

    public boolean[][] getDeadEnds() {
        if (this.deadEnds == null) {
            this.calculateNavigationInfo();
        }
        return Matrix2D.copy(this.deadEnds);
    }

    public boolean[][] getOpenAreas() {
        if (this.openAreas == null) {
            this.calculateNavigationInfo();
        }
        return Matrix2D.copy(this.openAreas);
    }

    public int[][] getBranchingFactor() {
        if (this.branchingFactor == null) {
            this.calculateNavigationInfo();
        }
        return Matrix2D.copy(this.branchingFactor);
    }

    public boolean[][] getUnusedSpaces() {
        if (this.unusedSpaces == null) {
            this.calculateEmptySpace();
        }
        return Matrix2D.copy(this.unusedSpaces);
    }

    public float getAverageBranchingFactor() {
        if (this.branchingFactor == null) {
            this.calculateNavigationInfo();
        }
        return this.averageBranchingFactor;
    }

    public float getBestAverageBranchingFactor() {
        if (this.astar == null) {
            this.init();
        }
        int allTiles = this.parent.getMapSizeX() * this.parent.getMapSizeY();
        int middleTiles = (this.parent.getMapSizeX() - 2) * (this.parent.getMapSizeY() - 2);
        int cornerTiles = 4;
        int edgeTiles = allTiles - middleTiles - cornerTiles;
        float result = this.astar.corners ? (float)(middleTiles * 8 + cornerTiles * 3 + edgeTiles * 5) : (float)(middleTiles * 4 + cornerTiles * 2 + edgeTiles * 3);
        return result / (float)allTiles;
    }

    public Pathfinder getAStar() {
        return this.astar;
    }

    public Vector<ArrayList> getResourcePathsFromBase(int baseIndex) {
        Vector<ArrayList> result = new Vector<ArrayList>();
        if (baseIndex < 0 || baseIndex >= this.parent.bases.size()) {
            LogManager.writeError("Error", this, "Base index out of bounds");
            return result;
        }
        int baseX = (int)this.parent.bases.get((int)baseIndex).x;
        int baseY = (int)this.parent.bases.get((int)baseIndex).y;
        for (int i = 0; i < this.resourcePaths.size(); ++i) {
            if (!PathLibrary.hasStart(this.resourcePaths.get(i), baseX, baseY) && !PathLibrary.hasEnd(this.resourcePaths.get(i), baseX, baseY)) continue;
            result.add(this.resourcePaths.get(i));
        }
        return result;
    }

    public Vector<ArrayList> getResourcePathsFromResource(int resourceIndex) {
        Vector<ArrayList> result = new Vector<ArrayList>();
        if (resourceIndex < 0 || resourceIndex >= this.parent.resources.size()) {
            LogManager.writeError("Error", this, "Resource index out of bounds");
            return result;
        }
        int resourceX = (int)this.parent.resources.get((int)resourceIndex).x;
        int resourceY = (int)this.parent.resources.get((int)resourceIndex).y;
        for (int i = 0; i < this.resourcePaths.size(); ++i) {
            if (!PathLibrary.hasStart(this.resourcePaths.get(i), resourceX, resourceY) && !PathLibrary.hasEnd(this.resourcePaths.get(i), resourceX, resourceY)) continue;
            result.add(this.resourcePaths.get(i));
        }
        return result;
    }

    public ArrayList getResourcePath(int baseIndex, int resourceIndex) {
        if (baseIndex < 0 || baseIndex >= this.parent.bases.size()) {
            LogManager.writeError("Error", this, "Base index out of bounds");
            return null;
        }
        if (resourceIndex < 0 || resourceIndex >= this.parent.resources.size()) {
            LogManager.writeError("Error", this, "Resource index out of bounds");
            return null;
        }
        int baseX = (int)this.parent.bases.get((int)baseIndex).x;
        int baseY = (int)this.parent.bases.get((int)baseIndex).y;
        int resourceX = (int)this.parent.resources.get((int)resourceIndex).x;
        int resourceY = (int)this.parent.resources.get((int)resourceIndex).y;
        for (int i = 0; i < this.resourcePaths.size(); ++i) {
            if (PathLibrary.hasStart(this.resourcePaths.get(i), baseX, baseY) && PathLibrary.hasEnd(this.resourcePaths.get(i), resourceX, resourceY)) {
                return this.resourcePaths.get(i);
            }
            if (!PathLibrary.hasStart(this.resourcePaths.get(i), resourceX, resourceY) || !PathLibrary.hasEnd(this.resourcePaths.get(i), baseX, baseY)) continue;
            return this.resourcePaths.get(i);
        }
        return null;
    }

    public ArrayList getPath(Point2D p1, Point2D p2) {
        return this.getPath((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
    }

    public ArrayList getPath(Point2D p1, int x2, int y2) {
        return this.getPath((int)p1.x, (int)p1.y, x2, y2);
    }

    public ArrayList getPath(int x1, int y1, Point2D p2) {
        return this.getPath(x1, y1, (int)p2.x, (int)p2.y);
    }

    public ArrayList getPath(int x1, int y1, int x2, int y2) {
        ArrayList result = this.astar.aStar(this.findNode(x1, y1), this.findNode(x2, y2));
        if (PathLibrary.hasStart(result, x2, y2) && PathLibrary.hasEnd(result, x1, y1)) {
            return result;
        }
        return null;
    }

    public Vector<ArrayList> calculateDFSPaths(Point2D start, Point2D end) {
        Vector<ArrayList> result = new Vector<ArrayList>();
        if (this.astar == null) {
            this.init();
        }
        Node startNode = this.findNode((int)start.x, (int)start.y);
        Node endNode = this.findNode((int)end.x, (int)end.y);
        Vector<Node> marked = new Vector<Node>();
        LinkedList<Node> q = new LinkedList<Node>();
        ArrayList<Node> currPath = new ArrayList<Node>();
        currPath.add(startNode);
        q.addLast(startNode);
        marked.add(startNode);
        while (!q.isEmpty()) {
            Node temp = (Node)q.getLast();
            currPath.add(temp);
            if (temp.x == endNode.x && temp.y == endNode.y) {
                result.add(currPath);
                if (result.size() > 4) {
                    return result;
                }
                marked.clear();
                marked.add(startNode);
                q.clear();
                q.addLast(startNode);
                currPath = new ArrayList();
                currPath.add(startNode);
            }
            for (int i = 0; i < temp.links.size(); ++i) {
                Connector conn = (Connector)temp.links.get(i);
                Node neighb = conn.n;
                if (marked.contains(neighb)) continue;
                marked.add(neighb);
                q.add(neighb);
            }
        }
        return result;
    }
}

