/*
 * Decompiled with CFR 0.152.
 */
package strategymap;

import java.util.Vector;
import strategymap.StrategyMetrics;
import strategymap.StrategyPaths;
import util.math2d.Point2D;
import util.statics.LogManager;
import util.statics.RandomNumberManager;

public class StrategySketch {
    int mapSizeX;
    int mapSizeY;
    boolean[][] impassable;
    Vector<Point2D> resources;
    Vector<Point2D> bases;
    StrategyPaths paths;
    StrategyMetrics metrics;

    public StrategySketch(int sizeX, int sizeY) {
        this.mapSizeX = sizeX;
        this.mapSizeY = sizeY;
        this.clearImpassable();
        this.resources = new Vector();
        this.bases = new Vector();
        this.paths = new StrategyPaths(this);
        this.metrics = new StrategyMetrics(this);
    }

    public StrategySketch(StrategySketch copy) {
        int i;
        this.mapSizeX = copy.mapSizeX;
        this.mapSizeY = copy.mapSizeX;
        this.clearImpassable();
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[x].length; ++y) {
                this.impassable[x][y] = copy.impassable[x][y];
            }
        }
        this.resources = new Vector();
        for (i = 0; i < copy.resources.size(); ++i) {
            this.resources.add(new Point2D(copy.resources.get(i)));
        }
        this.bases = new Vector();
        for (i = 0; i < copy.bases.size(); ++i) {
            this.bases.add(new Point2D(copy.bases.get(i)));
        }
        this.paths = new StrategyPaths(this);
        this.metrics = new StrategyMetrics(this);
        this.finalizeSketch();
    }

    public int getMapSizeX() {
        return this.mapSizeX;
    }

    public int getMapSizeY() {
        return this.mapSizeY;
    }

    public StrategyPaths getPaths() {
        return this.paths;
    }

    public StrategyMetrics getMetrics() {
        return this.metrics;
    }

    public int getTileDifference(StrategySketch other) {
        if (other.mapSizeX != this.mapSizeX || other.mapSizeY != this.mapSizeY) {
            LogManager.writeError("Error", this, "Comparing different-sized sketches");
            return Integer.MAX_VALUE;
        }
        int result = 0;
        boolean[][] baseArray = this.getBaseArray();
        boolean[][] resourceArray = this.getResourceArray();
        boolean[][] otherBaseArray = other.getBaseArray();
        boolean[][] otherResourceArray = other.getResourceArray();
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[x].length; ++y) {
                if (this.impassable[x][y] == other.impassable[x][y] && resourceArray[x][y] == otherResourceArray[x][y] && baseArray[x][y] == otherBaseArray[x][y]) continue;
                ++result;
            }
        }
        return result;
    }

    public void clearImpassable() {
        this.impassable = new boolean[this.mapSizeX][this.mapSizeY];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                this.impassable[x][y] = false;
            }
        }
    }

    public boolean addResource(int x, int y) {
        if (this.isWithinBounds(x, y) && !this.impassable[x][y] && this.getBaseIndex(x, y) == -1 && this.getResourceIndex(x, y) == -1) {
            this.resources.add(new Point2D(x, y));
            return true;
        }
        return false;
    }

    public boolean removeResource(int x, int y) {
        int index = this.getResourceIndex(x, y);
        if (index != -1) {
            this.resources.remove(index);
            return true;
        }
        return false;
    }

    public int getResourceIndex(int x, int y) {
        for (int i = 0; i < this.resources.size(); ++i) {
            if (this.resources.get((int)i).x != (double)x || this.resources.get((int)i).y != (double)y) continue;
            return i;
        }
        return -1;
    }

    public boolean addBase(int x, int y) {
        if (this.isWithinBounds(x, y) && !this.impassable[x][y] && this.getBaseIndex(x, y) == -1 && this.getResourceIndex(x, y) == -1) {
            this.bases.add(new Point2D(x, y));
            return true;
        }
        return false;
    }

    public boolean removeBase(int x, int y) {
        int index = this.getBaseIndex(x, y);
        if (index != -1) {
            this.bases.remove(index);
            return true;
        }
        return false;
    }

    public int getBaseIndex(int x, int y) {
        for (int i = 0; i < this.bases.size(); ++i) {
            if (this.bases.get((int)i).x != (double)x || this.bases.get((int)i).y != (double)y) continue;
            return i;
        }
        return -1;
    }

    public void setPassable(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            this.impassable[x][y] = false;
        }
    }

    public void setImpassable(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            this.impassable[x][y] = true;
        }
    }

    public void setPassable(boolean[][] pattern, int centerX, int centerY) {
        for (int x = 0; x < pattern.length; ++x) {
            for (int y = 0; y < pattern[0].length; ++y) {
                int global_y;
                int global_x;
                if (!pattern[x][y] || !this.isWithinBounds(global_x = centerX - pattern.length / 2 + x * pattern.length, global_y = centerY - pattern[0].length / 2 + y * pattern[0].length)) continue;
                this.impassable[global_x][global_y] = false;
            }
        }
    }

    public void setImpassable(boolean[][] pattern, int centerX, int centerY) {
        for (int x = 0; x < pattern.length; ++x) {
            for (int y = 0; y < pattern[0].length; ++y) {
                int global_y;
                int global_x;
                if (!pattern[x][y] || !this.isWithinBounds(global_x = centerX - pattern.length / 2 + x, global_y = centerY - pattern[0].length / 2 + y)) continue;
                this.impassable[global_x][global_y] = true;
            }
        }
    }

    public void setImpassableChunk(int centerX, int centerY, int sizeX, int sizeY) {
        for (int x = centerX - sizeX / 2; x < centerX + sizeX / 2; ++x) {
            for (int y = centerY - sizeY / 2; y < centerY + sizeY / 2; ++y) {
                if (!this.isWithinBounds(x, y)) continue;
                this.impassable[x][y] = true;
            }
        }
    }

    public int getResourceLength() {
        return this.resources.size();
    }

    public int getBaseLength() {
        return this.bases.size();
    }

    public Vector<Point2D> getResources() {
        Vector<Point2D> result = new Vector<Point2D>();
        for (int i = 0; i < this.resources.size(); ++i) {
            result.add(new Point2D(this.resources.get(i)));
        }
        return result;
    }

    public Vector<Point2D> getBases() {
        Vector<Point2D> result = new Vector<Point2D>();
        for (int i = 0; i < this.bases.size(); ++i) {
            result.add(new Point2D(this.bases.get(i)));
        }
        return result;
    }

    public Point2D getResource(int index) {
        return this.resources.get(index);
    }

    public Point2D getBase(int index) {
        return this.bases.get(index);
    }

    public boolean isBase(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            return this.inList(x, y, this.bases);
        }
        return false;
    }

    public boolean isResource(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            return this.inList(x, y, this.resources);
        }
        return false;
    }

    public boolean inList(int x, int y, Vector<Point2D> list) {
        for (int i = 0; i < list.size(); ++i) {
            Point2D currPoint = list.get(i);
            if (x != (int)currPoint.x || y != (int)currPoint.y) continue;
            return true;
        }
        return false;
    }

    public boolean inList(Point2D point, Vector<Point2D> list) {
        for (int i = 0; i < list.size(); ++i) {
            Point2D currPoint = list.get(i);
            if ((int)point.x != (int)currPoint.x || (int)point.y != (int)currPoint.y) continue;
            return true;
        }
        return false;
    }

    public void finalizeSketch() {
        this.paths.init();
        this.paths.calculateAllPaths();
        this.paths.calculateNavigationInfo();
        this.paths.calculateEmptySpace();
        this.paths.calculateResourceSafety();
        this.paths.calculateSafetyMatrix();
        this.paths.calculateExplorationMatrix();
        this.metrics.update();
    }

    public boolean isPassable(int x, int y) {
        if (!this.isWithinBounds(x, y)) {
            return false;
        }
        return !this.impassable[x][y];
    }

    public boolean isWithinBounds(int x, int y) {
        return x >= 0 && x < this.mapSizeX && y >= 0 && y < this.mapSizeY;
    }

    public boolean isCorner(int x, int y) {
        if (x == 0 && y == 0) {
            return true;
        }
        if (x == 0 && y == this.mapSizeY - 1) {
            return true;
        }
        if (x == this.mapSizeX - 1 && y == 0) {
            return true;
        }
        return x == this.mapSizeX - 1 && y == this.mapSizeY - 1;
    }

    public boolean[][] getPassableArray() {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                result[x][y] = !this.impassable[x][y];
            }
        }
        return result;
    }

    public boolean[][] getImpassableArray() {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                result[x][y] = this.impassable[x][y];
            }
        }
        return result;
    }

    public boolean[][] getResourceArray() {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                result[x][y] = false;
            }
        }
        for (int i = 0; i < this.resources.size(); ++i) {
            result[(int)this.resources.get((int)i).x][(int)this.resources.get((int)i).y] = true;
        }
        return result;
    }

    public boolean[][] getBaseArray() {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                result[x][y] = false;
            }
        }
        for (int i = 0; i < this.bases.size(); ++i) {
            result[(int)this.bases.get((int)i).x][(int)this.bases.get((int)i).y] = true;
        }
        return result;
    }

    public boolean[][] getArray(Vector<Point2D> points) {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                result[x][y] = false;
            }
        }
        for (int i = 0; i < points.size(); ++i) {
            result[(int)points.get((int)i).x][(int)points.get((int)i).y] = true;
        }
        return result;
    }

    public void randomize(int baseCount, int resourceCount) {
        int y;
        int x;
        int i;
        this.bases.clear();
        for (i = 0; i < baseCount; ++i) {
            x = RandomNumberManager.getRandomInt(0, this.mapSizeX);
            y = RandomNumberManager.getRandomInt(0, this.mapSizeY);
            this.addBase(x, y);
        }
        this.resources.clear();
        for (i = 0; i < resourceCount; ++i) {
            x = RandomNumberManager.getRandomInt(0, this.mapSizeX);
            y = RandomNumberManager.getRandomInt(0, this.mapSizeY);
            this.addResource(x, y);
        }
    }

    public void randomizeChunks(int chunkCount) {
        this.clearImpassable();
        for (int i = 0; i < chunkCount; ++i) {
            int x = RandomNumberManager.getRandomInt(0, this.mapSizeX);
            int y = RandomNumberManager.getRandomInt(0, this.mapSizeY);
            this.impassable[x][y] = true;
        }
    }

    public String toASCII() {
        String result = "";
        for (int y = 0; y < this.mapSizeX; ++y) {
            for (int x = 0; x < this.mapSizeX; ++x) {
                result = this.impassable[x][y] ? result + "#" : (this.isBase(x, y) ? result + "B" : (this.isResource(x, y) ? result + "r" : result + "."));
            }
            result = result + ";";
        }
        return result;
    }
}

