/*
 * Decompiled with CFR 0.152.
 */
package strategymap.constraints;

import java.util.Vector;
import util.statics.LogManager;

public class DataConstraints {
    public static final String[] dataConstraintLabels = new String[]{"Bases", "Resources", "Used_Space", "Max_Base_Distance", "Avg_Base_Distance", "Min_Base_Distance", "Choke_Points", "Dead_Ends", "Open_Areas"};
    Vector<DataConstraintEntry> list = new Vector();

    public void add(DataConstraintEntry entry) {
        int currIndex = this.findIndex(entry.index);
        if (currIndex == -1) {
            this.list.add(entry);
        } else {
            this.list.get((int)currIndex).modifier = entry.modifier;
            this.list.get((int)currIndex).targetValue = entry.targetValue;
        }
    }

    public void add(int index, int targetValue, int modifier) {
        int currIndex = this.findIndex(index);
        if (currIndex == -1) {
            this.list.add(new DataConstraintEntry(index, targetValue, modifier));
        } else {
            this.list.get((int)currIndex).modifier = modifier;
            this.list.get((int)currIndex).targetValue = targetValue;
        }
    }

    public void add(String label, int targetValue, int modifier) {
        int index = this.indexOf(label);
        if (index == -1) {
            LogManager.writeError("Error", this, "No index found for " + label);
            return;
        }
        this.add(index, targetValue, modifier);
    }

    public void remove(String label) {
        int index = this.indexOf(label);
        if (index == -1) {
            LogManager.writeError("Error", this, "No index found for " + label);
            return;
        }
        this.remove(index);
    }

    public void remove(int index) {
        int currIndex = this.findIndex(index);
        if (index != -1) {
            this.list.remove(currIndex);
        }
    }

    public int indexOf(String label) {
        for (int i = 0; i < dataConstraintLabels.length; ++i) {
            if (!dataConstraintLabels[i].equalsIgnoreCase(label)) continue;
            return i;
        }
        return -1;
    }

    public int findIndex(int index) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get((int)i).index != index) continue;
            return i;
        }
        return -1;
    }

    public int findIndex(String label) {
        int index = this.indexOf(label);
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get((int)i).index != index) continue;
            return i;
        }
        return -1;
    }

    public boolean isValid(int value, int index) {
        return this.list.get(index).isValid(value);
    }

    public double getNormalizedDifference(int value, int index) {
        return (double)Math.abs(this.list.get(index).getDifference(value)) / (double)Math.max(value, this.list.get((int)index).targetValue);
    }

    public int size() {
        return this.list.size();
    }

    class DataConstraintEntry {
        int index;
        int targetValue;
        int modifier;

        public DataConstraintEntry(int index, int value, int modifier) {
            this.index = index;
            this.modifier = modifier;
            this.targetValue = value;
        }

        public boolean isValid(int currValue) {
            int difference = currValue - this.targetValue;
            if (difference == 0 && this.modifier == 0) {
                return true;
            }
            if (difference > 0 && this.modifier > 0) {
                return true;
            }
            return difference < 0 && this.modifier < 0;
        }

        public int getDifference(int currValue) {
            return currValue - this.targetValue;
        }
    }
}

