/*
 * Decompiled with CFR 0.152.
 */
package strategymap.constraints;

import java.util.Vector;

public class FitnessConstraints {
    Vector<FitnessConstraintEntry> list = new Vector();

    public void clear() {
        this.list.clear();
    }

    public void add(FitnessConstraintEntry entry) {
        int currIndex = this.findIndex(entry.index);
        if (currIndex == -1) {
            this.list.add(entry);
        } else {
            this.list.get((int)currIndex).modifier = entry.modifier;
            this.list.get((int)currIndex).targetValue = entry.targetValue;
        }
    }

    public void add(int index, float targetValue, int modifier) {
        int currIndex = this.findIndex(index);
        if (currIndex == -1) {
            this.list.add(new FitnessConstraintEntry(index, targetValue, modifier));
        } else {
            this.list.get((int)currIndex).modifier = modifier;
            this.list.get((int)currIndex).targetValue = targetValue;
        }
    }

    public void remove(int index) {
        int currIndex = this.findIndex(index);
        if (index != -1) {
            this.list.remove(currIndex);
        }
    }

    public int findIndex(int index) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get((int)i).index != index) continue;
            return i;
        }
        return -1;
    }

    public boolean isValid(int value, int index) {
        return this.list.get(index).isValid(value);
    }

    public double getNormalizedDifference(int value, int index) {
        return (double)Math.abs(this.list.get(index).getDifference(value)) / (double)Math.max((float)value, this.list.get((int)index).targetValue);
    }

    public int size() {
        return this.list.size();
    }

    class FitnessConstraintEntry {
        int index;
        int modifier;
        float targetValue;
        final float minAccuracy = 0.01f;

        public FitnessConstraintEntry(int index, float value, int modifier) {
            this.index = index;
            this.modifier = modifier;
            this.targetValue = value;
        }

        public boolean isValid(float currValue) {
            float difference = currValue - this.targetValue;
            if (Math.abs(difference) < 0.01f && this.modifier == 0) {
                return true;
            }
            if (difference > 0.01f && this.modifier > 0) {
                return true;
            }
            return difference < -0.01f && this.modifier < 0;
        }

        public float getDifference(float currValue) {
            return currValue - this.targetValue;
        }
    }
}

