/*
 * Decompiled with CFR 0.152.
 */
package strategymap.constraints;

import java.util.Vector;

public class TileConstraints {
    TileConstraintEntry[][] tileConstraints;

    public TileConstraints(int sizeX, int sizeY) {
        this.tileConstraints = new TileConstraintEntry[sizeX][sizeY];
        for (int x = 0; x < this.tileConstraints.length; ++x) {
            for (int y = 0; y < this.tileConstraints[0].length; ++y) {
                this.tileConstraints[x][y] = new TileConstraintEntry();
            }
        }
    }

    protected boolean isWithinBounds(int x, int y) {
        return x >= 0 && x < this.tileConstraints.length && y >= 0 && y < this.tileConstraints[0].length;
    }

    public Vector<Type> getConstraints(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            return this.tileConstraints[x][y].constraints;
        }
        return null;
    }

    public boolean[][] getTilesWithConstraint(Type constraint) {
        boolean[][] result = new boolean[this.tileConstraints.length][this.tileConstraints[0].length];
        for (int x = 0; x < this.tileConstraints.length; ++x) {
            for (int y = 0; y < this.tileConstraints[0].length; ++y) {
                if (!this.tileConstraints[x][y].hasConstraint(constraint)) continue;
                result[x][y] = true;
            }
        }
        return result;
    }

    public void addConstraint(int x, int y, Type constraint) {
        if (this.isWithinBounds(x, y)) {
            this.tileConstraints[x][y].addConstraint(constraint);
        }
    }

    public void removeConstraint(int x, int y, Type constraint) {
        if (this.isWithinBounds(x, y)) {
            this.tileConstraints[x][y].removeConstraint(constraint);
        }
    }

    public boolean hasConstraint(int x, int y, Type constraint) {
        if (this.isWithinBounds(x, y)) {
            return this.tileConstraints[x][y].hasConstraint(constraint);
        }
        return false;
    }

    public void removeAllConstraintsAt(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            this.tileConstraints[x][y].constraints.clear();
        }
    }

    public void removeAllConstraints(Type constraint) {
        for (int x = 0; x < this.tileConstraints.length; ++x) {
            for (int y = 0; y < this.tileConstraints[0].length; ++y) {
                this.tileConstraints[x][y].removeConstraint(constraint);
            }
        }
    }

    public void addAllConstraints(Type constraint) {
        for (int x = 0; x < this.tileConstraints.length; ++x) {
            for (int y = 0; y < this.tileConstraints[0].length; ++y) {
                this.tileConstraints[x][y].addConstraint(constraint);
            }
        }
    }

    public int countConstraints(Type constraint) {
        int result = 0;
        for (int x = 0; x < this.tileConstraints.length; ++x) {
            for (int y = 0; y < this.tileConstraints[0].length; ++y) {
                if (!this.tileConstraints[x][y].hasConstraint(constraint)) continue;
                ++result;
            }
        }
        return result;
    }

    class TileConstraintEntry {
        final int maxConstraints = 4;
        Vector<Type> constraints = new Vector();

        public TileConstraintEntry() {
        }

        public TileConstraintEntry(Type constraint) {
            this();
            this.constraints.add(constraint);
        }

        public void addConstraint(Type constraint) {
            if (!this.constraints.contains((Object)constraint) && !this.hasConstraint(Type.UNCHANGED)) {
                this.constraints.add(constraint);
            }
            if (constraint == Type.RANDOMIZE && this.hasConstraint(Type.UNCHANGED)) {
                this.constraints.remove((Object)Type.UNCHANGED);
            }
            if (constraint == Type.UNCHANGED && this.hasConstraint(Type.RANDOMIZE)) {
                this.constraints.remove((Object)Type.RANDOMIZE);
            }
            if (constraint == Type.CHOKEPOINT && this.hasConstraint(Type.DEADEND)) {
                this.constraints.remove((Object)Type.DEADEND);
            }
            if (constraint == Type.DEADEND && this.hasConstraint(Type.CHOKEPOINT)) {
                this.constraints.remove((Object)Type.CHOKEPOINT);
            }
            if (constraint == Type.OPENAREA && this.hasConstraint(Type.CHOKEPOINT)) {
                this.constraints.remove((Object)Type.CHOKEPOINT);
            }
            if (constraint == Type.CHOKEPOINT && this.hasConstraint(Type.OPENAREA)) {
                this.constraints.remove((Object)Type.CHOKEPOINT);
            }
            if (constraint == Type.OPENAREA && this.hasConstraint(Type.DEADEND)) {
                this.constraints.remove((Object)Type.DEADEND);
            }
            if (constraint == Type.DEADEND && this.hasConstraint(Type.OPENAREA)) {
                this.constraints.remove((Object)Type.OPENAREA);
            }
            if (constraint == Type.UNSAFESPACE && this.hasConstraint(Type.SAFESPACE)) {
                this.constraints.remove((Object)Type.SAFESPACE);
            }
            if (constraint == Type.SAFESPACE && this.hasConstraint(Type.UNSAFESPACE)) {
                this.constraints.remove((Object)Type.UNSAFESPACE);
            }
            if (this.constraints.size() > 4) {
                this.constraints.removeElementAt(0);
            }
        }

        public void removeConstraint(Type constraint) {
            if (this.constraints.contains((Object)constraint)) {
                this.constraints.remove((Object)constraint);
            }
        }

        public boolean hasConstraint(Type constraint) {
            return this.constraints.contains((Object)constraint);
        }

        public int indexOf(Type constraint) {
            return this.constraints.indexOf((Object)constraint);
        }
    }

    public static enum Type {
        UNCHANGED,
        SAFESPACE,
        UNSAFESPACE,
        DEADEND,
        CHOKEPOINT,
        OPENAREA,
        UNUSEDSPACE,
        RANDOMIZE;

    }
}

