/*
 * Decompiled with CFR 0.152.
 */
package strategymap.genetic;

import genetic.Embryogeny;
import strategymap.StrategySketch;

public class StrategySketchEmbryogeny
implements Embryogeny<boolean[], StrategySketch> {
    int mapSizeX;
    int mapSizeY;
    static final int tileBits = 3;
    boolean[][][] frozenAreas;

    public StrategySketchEmbryogeny(int mapSizeX, int mapSizeY) {
        this.mapSizeX = mapSizeX;
        this.mapSizeY = mapSizeY;
        this.frozenAreas = null;
    }

    public void addToFrozenArea(int x, int y, boolean impassable, boolean base, boolean resource) {
        if (this.frozenAreas == null) {
            this.resetFrozenArea();
        }
        this.frozenAreas[x][y] = new boolean[]{impassable, base, resource};
    }

    public void resetFrozenArea() {
        this.frozenAreas = new boolean[this.mapSizeX][this.mapSizeY][];
        for (int x = 0; x < this.frozenAreas.length; ++x) {
            for (int y = 0; y < this.frozenAreas[0].length; ++y) {
                this.frozenAreas[x][y] = null;
            }
        }
    }

    public StrategySketch createPhenotype(boolean[] genotype) {
        StrategySketch result = new StrategySketch(this.mapSizeX, this.mapSizeY);
        int tileLength = (int)Math.floor(genotype.length / 3);
        for (int i = 0; i < tileLength; ++i) {
            int x = i % this.mapSizeX;
            int y = (int)Math.floor(i / this.mapSizeX);
            if (this.frozenAreas == null || this.frozenAreas[x][y] == null) {
                if (genotype[3 * i]) {
                    result.setImpassable(x, y);
                }
                if (genotype[3 * i + 1]) {
                    result.addBase(x, y);
                }
                if (!genotype[3 * i + 2]) continue;
                result.addResource(x, y);
                continue;
            }
            if (this.frozenAreas[x][y][0]) {
                result.setImpassable(x, y);
            }
            if (this.frozenAreas[x][y][1]) {
                result.addBase(x, y);
            }
            if (!this.frozenAreas[x][y][2]) continue;
            result.addResource(x, y);
        }
        result.finalizeSketch();
        return result;
    }
}

