/*
 * Decompiled with CFR 0.152.
 */
package strategymap.genetic;

import genetic.Gene;
import java.util.Vector;
import util.collections.ParameterCollection;
import util.statics.LogManager;
import util.statics.RandomNumberManager;

public class StrategySketchGene
extends Gene<boolean[]> {
    static final int tileBits = 3;
    int mapSizeX;
    int mapSizeY;

    public StrategySketchGene(int mapSizeX, int mapSizeY, ParameterCollection gaParams) {
        this.parameters = gaParams;
        this.phenotype = null;
        this.fitness = 0.0;
        this.mapSizeX = mapSizeX;
        this.mapSizeY = mapSizeY;
        this.genotype = new boolean[3 * mapSizeX * mapSizeY];
    }

    public StrategySketchGene(Gene copy) {
        if (!(copy instanceof StrategySketchGene)) {
            LogManager.writeError("Error", (Object)this, "combining genes of different types");
            return;
        }
        StrategySketchGene ba_copy = (StrategySketchGene)copy;
        this.parameters = ba_copy.parameters;
        this.phenotype = null;
        this.fitness = 0.0;
        this.mapSizeX = ba_copy.mapSizeX;
        this.mapSizeY = ba_copy.mapSizeY;
        this.genotype = new boolean[((boolean[])ba_copy.genotype).length];
        for (int i = 0; i < ((boolean[])this.genotype).length; ++i) {
            ((boolean[])this.genotype)[i] = ((boolean[])ba_copy.genotype)[i];
        }
    }

    public StrategySketchGene(boolean[] genotype, int mapSizeX, int mapSizeY, ParameterCollection gaParams) {
        this.parameters = gaParams;
        this.phenotype = null;
        this.fitness = 0.0;
        this.mapSizeX = mapSizeX;
        this.mapSizeY = mapSizeY;
        this.genotype = new boolean[genotype.length];
        for (int i = 0; i < genotype.length; ++i) {
            ((boolean[])this.genotype)[i] = genotype[i];
        }
    }

    public void randomize() {
        int bases = 0;
        int resources = 0;
        for (int i = 0; i < ((boolean[])this.genotype).length; ++i) {
            if (i % 3 == 0) {
                ((boolean[])this.genotype)[i] = RandomNumberManager.getRandomBoolean();
                continue;
            }
            if (i % 3 == 1 && !((boolean[])this.genotype)[i - 1]) {
                ((boolean[])this.genotype)[i] = RandomNumberManager.getRandomBoolean();
                ++bases;
                continue;
            }
            if (i % 3 != 2 || ((boolean[])this.genotype)[i - 2] || ((boolean[])this.genotype)[i - 1]) continue;
            ((boolean[])this.genotype)[i] = RandomNumberManager.getRandomBoolean();
            ++resources;
        }
        this.repairGenotype();
    }

    public static StrategySketchGene loadFromString(String xml, int mapSizeX, int mapSizeY, ParameterCollection gaParams) {
        String localXml = new String(xml);
        localXml.replace("<gene>", "");
        localXml.replace("<array>", "");
        localXml.replace("</array>", "");
        localXml.replace("</gene>", "");
        String[] allelesStr = localXml.split(";");
        boolean[] alleles = new boolean[allelesStr.length];
        for (int i = 0; i < alleles.length; ++i) {
            alleles[i] = Boolean.parseBoolean(allelesStr[i]);
        }
        return new StrategySketchGene(alleles, mapSizeX, mapSizeY, gaParams);
    }

    public StrategySketchGene clone() {
        return new StrategySketchGene(this);
    }

    public String toXML() {
        String result = "";
        result = result + "<gene>";
        result = result + "<array>";
        for (int i = 0; i < ((boolean[])this.genotype).length; ++i) {
            result = result + ((boolean[])this.genotype)[i];
            if (i >= ((boolean[])this.genotype).length - 1) continue;
            result = result + ";";
        }
        result = result + "</array>";
        result = result + "</gene>";
        return result;
    }

    public Vector<Gene> produceOffspring(Gene other) {
        Vector<Gene> result = new Vector<Gene>();
        if (!(other instanceof StrategySketchGene)) {
            LogManager.writeError("Error", (Object)this, "combining genes of different types");
            return result;
        }
        StrategySketchGene ba_other = (StrategySketchGene)other;
        boolean[] offspring1Array = new boolean[((boolean[])this.genotype).length];
        boolean[] offspring2Array = new boolean[((boolean[])this.genotype).length];
        if (((boolean[])this.genotype).length != ((boolean[])ba_other.genotype).length) {
            LogManager.writeError("Error", (Object)this, "recombining genes of different length");
            return null;
        }
        if (((boolean[])this.genotype).length == 0 || ((boolean[])ba_other.genotype).length == 0) {
            LogManager.writeError("Error", (Object)this, "one or more of the genes are empty");
            return null;
        }
        int crossoverPoints = 0;
        if (this.parameters.contains("crossoverPoints")) {
            crossoverPoints = this.parameters.getInteger("crossoverPoints");
        }
        if (crossoverPoints <= 0) {
            double chanceToCopyOther = 0.5;
            if (ba_other.getFitness() + this.fitness > 0.0) {
                chanceToCopyOther = ba_other.getFitness() / (ba_other.getFitness() + this.fitness);
            }
            for (int i = 0; i < offspring1Array.length; ++i) {
                if (RandomNumberManager.getRandomDouble() < chanceToCopyOther) {
                    offspring1Array[i] = ((boolean[])this.genotype)[i];
                    offspring2Array[i] = ((boolean[])ba_other.genotype)[i];
                    continue;
                }
                offspring1Array[i] = ((boolean[])ba_other.genotype)[i];
                offspring2Array[i] = ((boolean[])this.genotype)[i];
            }
        } else if (crossoverPoints > 0) {
            int[] crossoverLocations = new int[crossoverPoints];
            crossoverLocations[0] = RandomNumberManager.getRandomInt(1, (int)Math.floor(offspring1Array.length / 3) - crossoverPoints);
            for (int c = 1; c < crossoverPoints; ++c) {
                crossoverLocations[c] = RandomNumberManager.getRandomInt(crossoverLocations[c - 1], (int)Math.floor(offspring1Array.length / 3) - c);
            }
            int currCrossover = 0;
            for (int i = 0; i < offspring1Array.length; ++i) {
                if (currCrossover < crossoverLocations.length && i >= 3 * crossoverLocations[currCrossover]) {
                    ++currCrossover;
                }
                if (currCrossover % 2 == 0) {
                    offspring1Array[i] = ((boolean[])this.genotype)[i];
                    offspring2Array[i] = ((boolean[])ba_other.genotype)[i];
                    continue;
                }
                offspring1Array[i] = ((boolean[])ba_other.genotype)[i];
                offspring2Array[i] = ((boolean[])this.genotype)[i];
            }
        }
        StrategySketchGene offspring1 = new StrategySketchGene(offspring1Array, this.mapSizeX, this.mapSizeY, this.parameters);
        offspring1.repairGenotype();
        result.add(offspring1);
        StrategySketchGene offspring2 = new StrategySketchGene(offspring2Array, this.mapSizeX, this.mapSizeY, this.parameters);
        offspring2.repairGenotype();
        result.add(offspring2);
        return result;
    }

    public StrategySketchGene mutate() {
        StrategySketchGene result = new StrategySketchGene((boolean[])this.genotype, this.mapSizeX, this.mapSizeY, this.parameters);
        int minBases = 0;
        int maxBases = 0;
        int maxResources = 0;
        int minResources = 0;
        int mutateTile = 0;
        int mutateBase = 0;
        int mutateResource = 0;
        int mutateShift = 0;
        int mutateDiagonal = 0;
        int mutateTileMinNumber = 0;
        int mutateTileMaxNumber = 1;
        if (this.parameters.contains("mutateTile")) {
            mutateTile = this.parameters.getInteger("mutateTile");
        }
        if (this.parameters.contains("mutateBase")) {
            mutateBase = this.parameters.getInteger("mutateBase");
        }
        if (this.parameters.contains("mutateResource")) {
            mutateResource = this.parameters.getInteger("mutateResource");
        }
        if (this.parameters.contains("mutateShift")) {
            mutateShift = this.parameters.getInteger("mutateShift");
        }
        if (this.parameters.contains("mutateDiagonal")) {
            mutateDiagonal = this.parameters.getInteger("mutateDiagonal");
        }
        if (this.parameters.contains("mutateTileMinNumber")) {
            mutateTileMinNumber = this.parameters.getInteger("mutateTileMinNumber");
        }
        if (this.parameters.contains("mutateTileMaxNumber")) {
            mutateTileMaxNumber = this.parameters.getInteger("mutateTileMaxNumber");
        }
        if (this.parameters.contains("minBases")) {
            minBases = this.parameters.getInteger("minBases");
        }
        if (this.parameters.contains("maxBases")) {
            maxBases = this.parameters.getInteger("maxBases");
        }
        if (this.parameters.contains("minResources")) {
            minResources = this.parameters.getInteger("minResources");
        }
        if (this.parameters.contains("maxResources")) {
            maxResources = this.parameters.getInteger("maxResources");
        }
        int tileLength = (int)Math.floor(((boolean[])result.genotype).length / 3);
        if (RandomNumberManager.getRandomInt(0, 100) < mutateDiagonal) {
            for (int i = 0; i < tileLength / 2; ++i) {
                for (int b = 0; b < 3; ++b) {
                    boolean temp = ((boolean[])result.genotype)[3 * i + b];
                    ((boolean[])result.genotype)[3 * i + b] = ((boolean[])result.genotype)[((boolean[])result.genotype).length - 3 * (i + 1) + b];
                    ((boolean[])result.genotype)[((boolean[])result.genotype).length - 3 * (i + 1) + b] = temp;
                }
            }
        } else {
            int tries = 100000;
            Vector<Integer> mutatedIndexes = new Vector<Integer>();
            int bitsToMutate = RandomNumberManager.getRandomInt(mutateTileMinNumber, mutateTileMaxNumber);
            while (mutatedIndexes.size() < ((boolean[])result.genotype).length && mutatedIndexes.size() < bitsToMutate && tries > 0) {
                for (int i = 0; i < tileLength && mutatedIndexes.size() < bitsToMutate && mutatedIndexes.size() < ((boolean[])result.genotype).length && tries > 0; --tries, ++i) {
                    int b;
                    if (mutatedIndexes.contains(i)) continue;
                    if (RandomNumberManager.getRandomInt(0, 100) < mutateTile) {
                        if (((boolean[])result.genotype)[3 * i]) {
                            mutatedIndexes.add(i);
                            ((boolean[])result.genotype)[3 * i] = false;
                            for (int b2 = 1; b2 < 3; ++b2) {
                                ((boolean[])result.genotype)[3 * i + b2] = false;
                            }
                            continue;
                        }
                        boolean occupied = false;
                        for (b = 1; b < 3; ++b) {
                            if (!((boolean[])result.genotype)[3 * i + b]) continue;
                            occupied = true;
                            break;
                        }
                        if (occupied) continue;
                        mutatedIndexes.add(i);
                        ((boolean[])result.genotype)[3 * i] = true;
                        for (b = 1; b < 3; ++b) {
                            ((boolean[])result.genotype)[3 * i + b] = false;
                        }
                        continue;
                    }
                    if (RandomNumberManager.getRandomInt(0, 100) < mutateBase) {
                        if (((boolean[])result.genotype)[3 * i]) continue;
                        boolean occupied = false;
                        for (b = 1; b < 3; ++b) {
                            if (!((boolean[])result.genotype)[3 * i + b]) continue;
                            occupied = true;
                            break;
                        }
                        if (occupied) continue;
                        mutatedIndexes.add(i);
                        ((boolean[])result.genotype)[3 * i + 1] = true;
                        for (b = 2; b < 3; ++b) {
                            ((boolean[])result.genotype)[3 * i + b] = false;
                        }
                        continue;
                    }
                    if (RandomNumberManager.getRandomInt(0, 100) < mutateResource) {
                        if (((boolean[])result.genotype)[3 * i]) continue;
                        boolean occupied = false;
                        for (b = 1; b < 3; ++b) {
                            if (!((boolean[])result.genotype)[3 * i + b]) continue;
                            occupied = true;
                            break;
                        }
                        if (occupied) continue;
                        mutatedIndexes.add(i);
                        ((boolean[])result.genotype)[3 * i + 2] = true;
                        for (b = 3; b < 3; ++b) {
                            ((boolean[])result.genotype)[3 * i + b] = false;
                        }
                        continue;
                    }
                    if (RandomNumberManager.getRandomInt(0, 100) >= mutateShift) continue;
                    Vector<Integer> possibleDirections = new Vector<Integer>();
                    if (i % this.mapSizeX > 0) {
                        possibleDirections.add(-1);
                    }
                    if (i % this.mapSizeX < this.mapSizeX - 1) {
                        possibleDirections.add(1);
                    }
                    if (i > this.mapSizeX) {
                        possibleDirections.add(-this.mapSizeX);
                    }
                    if (i < tileLength - this.mapSizeX) {
                        possibleDirections.add(this.mapSizeX);
                    }
                    if (possibleDirections.isEmpty()) continue;
                    mutatedIndexes.add(i);
                    int direction = (Integer)possibleDirections.get(RandomNumberManager.getRandomInt(0, possibleDirections.size()));
                    for (int b3 = 0; b3 < 3; ++b3) {
                        boolean temp = ((boolean[])result.genotype)[3 * i + b3];
                        if (3 * (i + direction) + b3 >= ((boolean[])result.genotype).length || 3 * i + b3 >= ((boolean[])result.genotype).length) {
                            System.out.println("b=" + b3 + ", i=" + i + ", direction=" + direction);
                        }
                        ((boolean[])result.genotype)[3 * i + b3] = ((boolean[])result.genotype)[3 * (i + direction) + b3];
                        ((boolean[])result.genotype)[3 * (i + direction) + b3] = temp;
                    }
                }
            }
        }
        result.repairGenotype();
        return result;
    }

    public float getDifference(Gene other) {
        if (!(other instanceof StrategySketchGene)) {
            LogManager.writeError("Error", (Object)this, "comparing genes of different types");
            return 0.0f;
        }
        StrategySketchGene ba_other = (StrategySketchGene)other;
        if (((boolean[])this.genotype).length != ((boolean[])ba_other.genotype).length) {
            LogManager.writeError("Error", (Object)this, "comparing genes of different length");
            return 0.0f;
        }
        float result = 0.0f;
        for (int i = 0; i < ((boolean[])this.genotype).length; ++i) {
            if (((boolean[])this.genotype)[i] == ((boolean[])ba_other.genotype)[i]) continue;
            result += 1.0f;
        }
        return result;
    }

    public void repairGenotype() {
        this.repairGenotype(false);
    }

    public void repairGenotype(boolean initialValues) {
        int rndTile;
        int roll;
        int rndTile2;
        int roll2;
        if (!this.parameters.contains("repair") || this.parameters.getInteger("repair") == 0) {
            return;
        }
        boolean genotypeInteger = false;
        Vector<Integer> passable = new Vector<Integer>();
        Vector<Integer> bases = new Vector<Integer>();
        Vector<Integer> resources = new Vector<Integer>();
        for (int i = 0; i < ((boolean[])this.genotype).length; ++i) {
            if (i % 3 == 0 && !((boolean[])this.genotype)[i]) {
                passable.add(i / 3);
            }
            if (i % 3 == 1 && ((boolean[])this.genotype)[i]) {
                bases.add((i - 1) / 3);
            }
            if (i % 3 != 2 || !((boolean[])this.genotype)[i]) continue;
            resources.add((i - 2) / 3);
        }
        int genotypeMinValue = 0;
        int genotypeMaxValue = 0;
        if (initialValues && this.parameters.contains("genotypeMinInitialBases")) {
            genotypeMinValue = this.parameters.getInteger("genotypeMinInitialBases");
        }
        if (initialValues && this.parameters.contains("genotypeMaxInitialBases")) {
            genotypeMaxValue = this.parameters.getInteger("genotypeMaxInitialBases");
        }
        if (!(initialValues && this.parameters.contains("genotypeMinInitialBases") || !this.parameters.contains("genotypeMinBases"))) {
            genotypeMinValue = this.parameters.getInteger("genotypeMinBases");
        }
        if (!(initialValues && this.parameters.contains("genotypeMaxInitialBases") || !this.parameters.contains("genotypeMaxBases"))) {
            genotypeMaxValue = this.parameters.getInteger("genotypeMaxBases");
        }
        while (bases.size() > genotypeMaxValue) {
            roll2 = RandomNumberManager.getRandomInt(0, bases.size());
            rndTile2 = (Integer)bases.get(roll2);
            ((boolean[])this.genotype)[3 * rndTile2 + 1] = false;
            bases.removeElementAt(roll2);
        }
        while (bases.size() < genotypeMinValue) {
            if (!passable.isEmpty()) {
                roll = RandomNumberManager.getRandomInt(0, passable.size());
                rndTile = (Integer)passable.get(roll);
                passable.removeElement(roll);
            } else {
                rndTile = RandomNumberManager.getRandomInt(0, (int)Math.floor((float)((boolean[])this.genotype).length / 3.0f));
            }
            if (((boolean[])this.genotype)[3 * rndTile + 1] || ((boolean[])this.genotype)[3 * rndTile + 2]) continue;
            ((boolean[])this.genotype)[3 * rndTile] = false;
            ((boolean[])this.genotype)[3 * rndTile + 1] = true;
            bases.add(rndTile);
        }
        genotypeMinValue = 0;
        genotypeMaxValue = 0;
        if (initialValues && this.parameters.contains("genotypeMinInitialResources")) {
            genotypeMinValue = this.parameters.getInteger("genotypeMinInitialResources");
        }
        if (initialValues && this.parameters.contains("genotypeMaxInitialResources")) {
            genotypeMaxValue = this.parameters.getInteger("genotypeMaxInitialResources");
        }
        if (!(initialValues && this.parameters.contains("genotypeMinInitialResources") || !this.parameters.contains("genotypeMinResources"))) {
            genotypeMinValue = this.parameters.getInteger("genotypeMinResources");
        }
        if (!(initialValues && this.parameters.contains("genotypeMaxInitialResources") || !this.parameters.contains("genotypeMaxResources"))) {
            genotypeMaxValue = this.parameters.getInteger("genotypeMaxResources");
        }
        while (resources.size() > genotypeMaxValue) {
            roll2 = RandomNumberManager.getRandomInt(0, resources.size());
            rndTile2 = (Integer)resources.get(roll2);
            ((boolean[])this.genotype)[3 * rndTile2 + 2] = false;
            resources.removeElementAt(roll2);
        }
        while (resources.size() < genotypeMinValue) {
            rndTile = RandomNumberManager.getRandomInt(0, (int)Math.floor((float)((boolean[])this.genotype).length / 3.0f));
            if (!passable.isEmpty()) {
                roll = RandomNumberManager.getRandomInt(0, passable.size());
                rndTile = (Integer)passable.get(roll);
                passable.removeElement(roll);
            }
            if (((boolean[])this.genotype)[3 * rndTile + 1] || ((boolean[])this.genotype)[3 * rndTile + 2]) continue;
            ((boolean[])this.genotype)[3 * rndTile] = false;
            ((boolean[])this.genotype)[3 * rndTile + 2] = true;
            resources.add(rndTile);
        }
    }

    public boolean[] getGenotype() {
        boolean[] result = new boolean[((boolean[])this.genotype).length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((boolean[])this.genotype)[i];
        }
        return result;
    }
}

