/*
 * Decompiled with CFR 0.152.
 */
package strategymap.genetic;

import strategymap.StrategySketch;
import strategymap.genetic.StrategySketchGene;
import util.collections.ParameterCollection;

public class StrategySketchGeneConverter {
    public static StrategySketchGene getGene(StrategySketch sketch, ParameterCollection gaParams) {
        int tileIndex;
        int i;
        boolean[] alleles = new boolean[3 * sketch.getMapSizeX() * sketch.getMapSizeY()];
        for (int x = 0; x < sketch.getMapSizeX(); ++x) {
            for (int y = 0; y < sketch.getMapSizeY(); ++y) {
                int tileIndex2 = (x + y * sketch.getMapSizeX()) * 3;
                alleles[tileIndex2] = !sketch.isPassable(x, y);
                for (int b = 1; b < 3; ++b) {
                    alleles[tileIndex2 + b] = false;
                }
            }
        }
        for (i = 0; i < sketch.getBaseLength(); ++i) {
            tileIndex = ((int)sketch.getBase((int)i).x + (int)sketch.getBase((int)i).y * sketch.getMapSizeX()) * 3;
            alleles[tileIndex + 1] = true;
        }
        for (i = 0; i < sketch.getResourceLength(); ++i) {
            tileIndex = ((int)sketch.getResource((int)i).x + (int)sketch.getResource((int)i).y * sketch.getMapSizeX()) * 3;
            alleles[tileIndex + 2] = true;
        }
        return new StrategySketchGene(alleles, sketch.getMapSizeX(), sketch.getMapSizeY(), gaParams);
    }
}

