/*
 * Decompiled with CFR 0.152.
 */
package strategymap.genetic;

import genetic.Embryogeny;
import genetic.FI2PopTrainer;
import genetic.GeneticAlgorithm;
import genetic.GeneticAlgorithmTrainer;
import genetic.GeneticAlgorithmTrainerGeneric;
import genetic.NoveltyTrainer;
import genetic.fitness.DifferenceFitness;
import genetic.fitness.Fitness;
import java.util.Vector;
import strategymap.StrategySketch;
import strategymap.constraints.StrategyConstraints;
import strategymap.genetic.StrategySketchEmbryogeny;
import strategymap.genetic.StrategySketchGene;
import strategymap.genetic.StrategySketchGeneConverter;
import strategymap.genetic.StrategySketchGeneticAlgorithm;
import strategymap.genetic.StrategySketchSymmetricEmbryogeny;
import strategymap.genetic.fitness.FeasibleFitness;
import strategymap.genetic.fitness.InfeasibleFitness;
import strategymap.genetic.fitness.SketchDifferenceFitness;
import util.collections.ParameterCollection;

public class StrategySketchSuggestions {
    ParameterCollection gaParameters;
    Vector<StrategySketch> suggestions = new Vector();
    Vector<String> suggestionLabels = new Vector();
    Vector<FI2PopTrainer> gaTrainers;
    Vector<Thread> gaThreads;
    int defaultMinBases;
    int defaultMaxBases;
    int defaultMinResources;
    int defaultMaxResources;
    StrategySketchSuggestionsPreparation prep;
    StrategySketch baseMap;
    Thread prepThread;

    public void initParameters(int mapSizeX, int mapSizeY, int minBases, int maxBases, int minResources, int maxResources) {
        this.defaultMinBases = minBases;
        this.defaultMaxBases = maxBases;
        this.defaultMinResources = minResources;
        this.defaultMaxResources = maxResources;
        this.gaParameters = new ParameterCollection("./resources/parameters/suggestions.xml");
        this.gaParameters.setParameter("mapSizeX", mapSizeX);
        this.gaParameters.setParameter("mapSizeY", mapSizeY);
        this.gaParameters.setParameter("genotypeMinResources", minResources);
        this.gaParameters.setParameter("genotypeMaxResources", maxResources);
        this.gaParameters.setParameter("genotypeMinBases", minBases);
        this.gaParameters.setParameter("genotypeMaxBases", maxBases);
        this.gaParameters.setParameter("mutateTileMinNumber", mapSizeX * mapSizeY / 20);
        this.gaParameters.setParameter("mutateTileMaxNumber", mapSizeX * mapSizeY / 5);
    }

    public void customizeParameters(int userBases, int userResources) {
        if (this.gaThreads != null || this.prepThread != null) {
            return;
        }
        this.gaParameters.setParameter("genotypeMaxResources", Math.max(userResources, this.defaultMaxResources));
        this.gaParameters.setParameter("genotypeMaxBases", Math.max(userBases, this.defaultMaxBases));
    }

    public StrategySketch getSuggestion(int index) {
        return this.suggestions.get(index);
    }

    public Vector<StrategySketch> getSuggestions() {
        return this.suggestions;
    }

    public String getSuggestionLabel(int index) {
        return this.suggestionLabels.get(index);
    }

    public Vector<String> getSuggestionLabels() {
        return this.suggestionLabels;
    }

    public double[] getFitnesses(int index) {
        double[] result = new double[FeasibleFitness.labels.length];
        for (int j = 0; j < result.length; ++j) {
            FeasibleFitness fn = new FeasibleFitness(j);
            result[j] = fn.evaluate(this.suggestions.get(index));
        }
        return result;
    }

    public Vector<double[]> getFitnesses() {
        Vector<double[]> result = new Vector<double[]>();
        for (int i = 0; i < this.suggestions.size(); ++i) {
            result.add(this.getFitnesses(i));
        }
        return result;
    }

    public int size() {
        return this.suggestions == null ? 0 : this.suggestions.size();
    }

    public void clearSuggestions() {
        this.suggestions.clear();
    }

    public void createSuggestions(StrategySketch baseMap, StrategyConstraints sketchConstraints, int suggestionsNumber) {
        StrategySketchGene baseGene = StrategySketchGeneConverter.getGene(baseMap, this.gaParameters);
        InfeasibleFitness ifn = new InfeasibleFitness(this.gaParameters.getInteger("genotypeMinBases"), this.gaParameters.getInteger("genotypeMaxBases"), this.gaParameters.getInteger("genotypeMinResources"), this.gaParameters.getInteger("genotypeMaxResources"));
        StrategySketchEmbryogeny sse = new StrategySketchEmbryogeny(baseMap.getMapSizeX(), baseMap.getMapSizeY());
        while (this.suggestions.size() < suggestionsNumber) {
            StrategySketchGene initialGene = baseGene.clone();
            StrategySketch phenotype = sse.createPhenotype((initialGene = initialGene.mutate()).getGenotype());
            if (ifn.evaluate(phenotype) != 0.0) continue;
            this.suggestions.add(phenotype);
        }
    }

    public void initNoveltyTraining(StrategySketch baseMap, StrategyConstraints sketchConstraints) {
        if (this.gaThreads != null || this.prepThread != null) {
            return;
        }
        this.baseMap = baseMap;
        this.prep = new StrategySketchNoveltyPreparation(baseMap, sketchConstraints, this.gaParameters);
        this.prepThread = new Thread(this.prep);
        this.prepThread.start();
    }

    public void initFitnessTraining(StrategySketch baseMap, StrategyConstraints sketchConstraints) {
        if (this.gaThreads != null || this.prepThread != null) {
            return;
        }
        this.baseMap = baseMap;
        this.prep = new StrategySketchFitnessPreparation(baseMap, sketchConstraints, this.gaParameters);
        this.prepThread = new Thread(this.prep);
        this.prepThread.start();
    }

    public void initCompositeTraining(StrategySketch baseMap, StrategyConstraints sketchConstraints) {
        if (this.gaThreads != null || this.prepThread != null) {
            return;
        }
        this.baseMap = baseMap;
        this.prep = new StrategySketchCompositePreparation(baseMap, sketchConstraints, this.gaParameters);
        this.prepThread = new Thread(this.prep);
        this.prepThread.start();
    }

    public void interruptTraining() {
        if (this.prepThread != null && this.prepThread.isAlive()) {
            this.prepThread.interrupt();
            this.prepThread = null;
        }
        if (this.gaThreads != null) {
            for (int i = 0; i < this.gaThreads.size(); ++i) {
                if (this.gaThreads.get(i) == null || !this.gaThreads.get(i).isAlive()) continue;
                this.gaThreads.get(i).interrupt();
            }
            this.gaThreads = null;
        }
    }

    public boolean isTraining() {
        return this.prepThread != null || this.gaThreads != null;
    }

    public boolean updateTraining() {
        if (this.prepThread != null && !this.prepThread.isAlive()) {
            int i;
            this.gaTrainers = this.prep.getTrainers();
            this.gaThreads = new Vector();
            for (i = 0; i < this.gaTrainers.size(); ++i) {
                this.gaThreads.add(new Thread((Runnable)this.gaTrainers.get(i)));
            }
            for (i = 0; i < this.gaThreads.size(); ++i) {
                this.gaThreads.get(i).start();
            }
            this.prepThread = null;
        }
        if (this.gaThreads != null) {
            int completedThreads = 0;
            for (int i = 0; i < this.gaThreads.size(); ++i) {
                if (this.gaThreads.get(i) == null || this.gaThreads.get(i).isAlive()) continue;
                ++completedThreads;
            }
            if (completedThreads > 0 && completedThreads == this.gaThreads.size()) {
                this.suggestions.clear();
                for (int j = 0; j < this.gaThreads.size(); ++j) {
                    if (this.gaTrainers.get(j).getBestFeasibleIndividual() == null) continue;
                    if (this.gaTrainers.get(j).getFeasibleTrainer() instanceof NoveltyTrainer) {
                        int shownMaps = this.gaThreads.size() == 1 ? 12 : 6;
                        Vector maps = this.gaTrainers.get(j).getBestFeasiblePhenotypes(shownMaps);
                        for (int i = 0; i < maps.size(); ++i) {
                            StrategySketch temp = (StrategySketch)maps.get(i);
                            if (this.baseMap.getTileDifference(temp) <= 0) continue;
                            boolean addMap = true;
                            for (StrategySketch s : this.suggestions) {
                                if (s.getTileDifference(temp) != 0) continue;
                                addMap = false;
                                break;
                            }
                            if (!addMap) continue;
                            this.suggestions.add(temp);
                            this.suggestionLabels.add("noveltySearch");
                        }
                        continue;
                    }
                    if (this.gaTrainers.get(j).getFeasibleTrainer() instanceof GeneticAlgorithmTrainer) {
                        StrategySketch temp = (StrategySketch)this.gaTrainers.get(j).getBestFeasibleIndividual().getPhenotype();
                        if (this.baseMap.getTileDifference(temp) <= 0) continue;
                        boolean addMap = true;
                        for (StrategySketch s : this.suggestions) {
                            if (s.getTileDifference(temp) != 0) continue;
                            addMap = false;
                            break;
                        }
                        if (!addMap) continue;
                        this.suggestions.add(temp);
                        this.suggestionLabels.add(((GeneticAlgorithmTrainer)this.gaTrainers.get(j).getFeasibleTrainer()).getFitnessFunction().getLabel());
                        continue;
                    }
                    StrategySketch temp = (StrategySketch)this.gaTrainers.get(j).getBestFeasibleIndividual().getPhenotype();
                    if (this.baseMap.getTileDifference(temp) <= 0) continue;
                    boolean addMap = true;
                    for (StrategySketch s : this.suggestions) {
                        if (s.getTileDifference(temp) != 0) continue;
                        addMap = false;
                        break;
                    }
                    if (!addMap) continue;
                    this.suggestions.add(temp);
                    this.suggestionLabels.add("unknown");
                }
                this.gaThreads = null;
                return true;
            }
        }
        return false;
    }

    class StrategySketchNoveltyPreparation
    extends StrategySketchSuggestionsPreparation {
        public StrategySketchNoveltyPreparation(StrategySketch baseMap, StrategyConstraints sketchConstraints, ParameterCollection gaParameters) {
            super(baseMap, sketchConstraints, gaParameters);
        }

        @Override
        public void run() {
            if (StrategySketchSuggestions.this.gaThreads != null) {
                return;
            }
            InfeasibleFitness ifn = new InfeasibleFitness(this.gaParameters.getInteger("genotypeMinBases"), this.gaParameters.getInteger("genotypeMaxBases"), this.gaParameters.getInteger("genotypeMinResources"), this.gaParameters.getInteger("genotypeMaxResources"));
            StrategySketchEmbryogeny sme = new StrategySketchEmbryogeny(this.gaParameters.getInteger("mapSizeX"), this.gaParameters.getInteger("mapSizeY"));
            StrategySketchGene baseGene = StrategySketchGeneConverter.getGene(this.baseMap, this.gaParameters);
            SketchDifferenceFitness dfn = new SketchDifferenceFitness();
            int populationSize = this.gaParameters.getInteger("population");
            Vector<StrategySketchGene> population_1 = new Vector<StrategySketchGene>();
            for (int j = 0; j < populationSize; ++j) {
                StrategySketchGene initialGene = baseGene.clone();
                population_1.add(initialGene.mutate());
            }
            Vector<StrategySketchGene> population_2 = new Vector<StrategySketchGene>();
            for (int j = 0; j < populationSize; ++j) {
                StrategySketchGene initialGene = baseGene.clone();
                population_2.add(initialGene.mutate());
            }
            StrategySketchGeneticAlgorithm ga = new StrategySketchGeneticAlgorithm(this.gaParameters);
            ga.initializePopulation();
            ga.replacePopulation(population_1);
            StrategySketchGeneticAlgorithm iga = new StrategySketchGeneticAlgorithm(this.gaParameters);
            iga.initializePopulation();
            iga.replacePopulation(population_2);
            NoveltyTrainer fgaTrainer = new NoveltyTrainer((DifferenceFitness)dfn, (Embryogeny)sme, (GeneticAlgorithm)ga, this.gaParameters);
            GeneticAlgorithmTrainer igaTrainer = new GeneticAlgorithmTrainer((Fitness)ifn, (Embryogeny)sme, (GeneticAlgorithm)iga, this.gaParameters);
            StrategySketchSuggestions.this.gaThreads = new Vector();
            this.gaTrainers = new Vector();
            FI2PopTrainer trainer = new FI2PopTrainer((Fitness)ifn, (GeneticAlgorithmTrainerGeneric)fgaTrainer, (GeneticAlgorithmTrainerGeneric)igaTrainer, this.gaParameters);
            trainer.shufflePopulations();
            this.gaTrainers.add(trainer);
        }
    }

    class StrategySketchFitnessPreparation
    extends StrategySketchSuggestionsPreparation {
        public StrategySketchFitnessPreparation(StrategySketch baseMap, StrategyConstraints sketchConstraints, ParameterCollection gaParameters) {
            super(baseMap, sketchConstraints, gaParameters);
        }

        @Override
        public void run() {
            if (StrategySketchSuggestions.this.gaThreads != null) {
                return;
            }
            InfeasibleFitness ifn = new InfeasibleFitness(this.gaParameters.getInteger("genotypeMinBases"), this.gaParameters.getInteger("genotypeMaxBases"), this.gaParameters.getInteger("genotypeMinResources"), this.gaParameters.getInteger("genotypeMaxResources"));
            Vector<FeasibleFitness> sfn = new Vector<FeasibleFitness>();
            for (int i = 0; i < 6; ++i) {
                sfn.add(new FeasibleFitness(i));
            }
            StrategySketchEmbryogeny sme = new StrategySketchEmbryogeny(this.gaParameters.getInteger("mapSizeX"), this.gaParameters.getInteger("mapSizeY"));
            StrategySketchSuggestions.this.gaThreads = new Vector();
            this.gaTrainers = new Vector();
            StrategySketchGene baseGene = StrategySketchGeneConverter.getGene(this.baseMap, this.gaParameters);
            for (int i = 0; i < sfn.size(); ++i) {
                int populationSize = this.gaParameters.getInteger("population");
                Vector<StrategySketchGene> population_1 = new Vector<StrategySketchGene>();
                for (int j = 0; j < populationSize; ++j) {
                    StrategySketchGene initialGene = baseGene.clone();
                    population_1.add(initialGene.mutate());
                }
                Vector<StrategySketchGene> population_2 = new Vector<StrategySketchGene>();
                for (int j = 0; j < populationSize; ++j) {
                    StrategySketchGene initialGene = baseGene.clone();
                    population_2.add(initialGene.mutate());
                }
                StrategySketchGeneticAlgorithm ga = new StrategySketchGeneticAlgorithm(this.gaParameters);
                ga.initializePopulation();
                ga.replacePopulation(population_1);
                StrategySketchGeneticAlgorithm iga = new StrategySketchGeneticAlgorithm(this.gaParameters);
                iga.initializePopulation();
                iga.replacePopulation(population_2);
                FI2PopTrainer trainer = new FI2PopTrainer((Fitness)sfn.get(i), (Fitness)ifn, (Embryogeny)sme, (GeneticAlgorithm)ga, (GeneticAlgorithm)iga, this.gaParameters);
                trainer.shufflePopulations();
                this.gaTrainers.add(trainer);
            }
        }
    }

    class StrategySketchCompositePreparation
    extends StrategySketchSuggestionsPreparation {
        public StrategySketchCompositePreparation(StrategySketch baseMap, StrategyConstraints sketchConstraints, ParameterCollection gaParameters) {
            super(baseMap, sketchConstraints, gaParameters);
        }

        @Override
        public void run() {
            StrategySketchGeneticAlgorithm iga;
            StrategySketchGene initialGene;
            StrategySketchGene initialGene2;
            Vector<StrategySketchGene> population_1;
            int populationSize;
            ParameterCollection customParameters;
            StrategySketchEmbryogeny custom_sme;
            int bestSymmetry = -1;
            if (StrategySketchSuggestions.this.gaThreads != null) {
                return;
            }
            InfeasibleFitness ifn = new InfeasibleFitness(this.gaParameters.getInteger("genotypeMinBases"), this.gaParameters.getInteger("genotypeMaxBases"), this.gaParameters.getInteger("genotypeMinResources"), this.gaParameters.getInteger("genotypeMaxResources"));
            Vector<FeasibleFitness> sfn = new Vector<FeasibleFitness>();
            for (int i = 0; i < FeasibleFitness.labels.length; ++i) {
                sfn.add(new FeasibleFitness(i));
            }
            StrategySketchGene baseGene = StrategySketchGeneConverter.getGene(this.baseMap, this.gaParameters);
            if (bestSymmetry == -1) {
                custom_sme = new StrategySketchEmbryogeny(this.gaParameters.getInteger("mapSizeX"), this.gaParameters.getInteger("mapSizeY"));
                customParameters = this.gaParameters;
            } else {
                custom_sme = new StrategySketchSymmetricEmbryogeny(this.gaParameters.getInteger("mapSizeX"), this.gaParameters.getInteger("mapSizeY"), bestSymmetry);
                customParameters = StrategySketchSymmetricEmbryogeny.convertGeneticParameters(this.baseMap, bestSymmetry, this.gaParameters);
                baseGene = StrategySketchSymmetricEmbryogeny.getSymmetricVersion(baseGene, this.baseMap.getMapSizeX(), this.baseMap.getMapSizeY(), bestSymmetry, customParameters);
            }
            StrategySketchSuggestions.this.gaThreads = new Vector();
            this.gaTrainers = new Vector();
            for (int i = 0; i < sfn.size(); ++i) {
                populationSize = customParameters.getInteger("population");
                population_1 = new Vector<StrategySketchGene>();
                for (int j = 0; j < populationSize; ++j) {
                    initialGene2 = baseGene.clone();
                    population_1.add(initialGene2.mutate());
                }
                Vector<StrategySketchGene> population_2 = new Vector<StrategySketchGene>();
                for (int j = 0; j < populationSize; ++j) {
                    initialGene = baseGene.clone();
                    population_2.add(initialGene.mutate());
                }
                StrategySketchGeneticAlgorithm ga = new StrategySketchGeneticAlgorithm(customParameters);
                ga.initializePopulation();
                ga.replacePopulation(population_1);
                iga = new StrategySketchGeneticAlgorithm(customParameters);
                iga.initializePopulation();
                iga.replacePopulation(population_2);
                FI2PopTrainer trainer = new FI2PopTrainer((Fitness)sfn.get(i), (Fitness)ifn, (Embryogeny)custom_sme, (GeneticAlgorithm)ga, (GeneticAlgorithm)iga, customParameters);
                trainer.shufflePopulations();
                this.gaTrainers.add(trainer);
            }
            SketchDifferenceFitness dfn = new SketchDifferenceFitness();
            populationSize = customParameters.getInteger("population");
            population_1 = new Vector();
            for (int j = 0; j < populationSize; ++j) {
                initialGene2 = baseGene.clone();
                population_1.add(initialGene2.mutate());
            }
            Vector<StrategySketchGene> population_2 = new Vector<StrategySketchGene>();
            for (int j = 0; j < populationSize; ++j) {
                initialGene = baseGene.clone();
                population_2.add(initialGene.mutate());
            }
            StrategySketchGeneticAlgorithm ga = new StrategySketchGeneticAlgorithm(customParameters);
            ga.initializePopulation();
            ga.replacePopulation(population_1);
            iga = new StrategySketchGeneticAlgorithm(customParameters);
            iga.initializePopulation();
            iga.replacePopulation(population_2);
            NoveltyTrainer fgaTrainer = new NoveltyTrainer((DifferenceFitness)dfn, (Embryogeny)custom_sme, (GeneticAlgorithm)ga, customParameters);
            GeneticAlgorithmTrainer igaTrainer = new GeneticAlgorithmTrainer((Fitness)ifn, (Embryogeny)custom_sme, (GeneticAlgorithm)iga, customParameters);
            FI2PopTrainer trainer = new FI2PopTrainer((Fitness)ifn, (GeneticAlgorithmTrainerGeneric)fgaTrainer, (GeneticAlgorithmTrainerGeneric)igaTrainer, customParameters);
            trainer.shufflePopulations();
            this.gaTrainers.add(trainer);
        }
    }

    abstract class StrategySketchSuggestionsPreparation
    implements Runnable {
        StrategySketch baseMap;
        StrategyConstraints sketchConstraints;
        ParameterCollection gaParameters;
        Vector<FI2PopTrainer> gaTrainers;

        public StrategySketchSuggestionsPreparation(StrategySketch baseMap, StrategyConstraints sketchConstraints, ParameterCollection gaParameters) {
            this.baseMap = baseMap;
            this.sketchConstraints = sketchConstraints;
            this.gaParameters = gaParameters;
        }

        public Vector<FI2PopTrainer> getTrainers() {
            return this.gaTrainers;
        }
    }
}

