/*
 * Decompiled with CFR 0.152.
 */
package strategymap.genetic;

import strategymap.StrategySketch;
import strategymap.genetic.StrategySketchEmbryogeny;
import strategymap.genetic.StrategySketchGene;
import util.collections.ParameterCollection;
import util.math2d.Matrix2D;

public class StrategySketchSymmetricEmbryogeny
extends StrategySketchEmbryogeny {
    int symmetryMode;

    public StrategySketchSymmetricEmbryogeny(int mapSizeX, int mapSizeY, int symmetryMode) {
        super(mapSizeX, mapSizeY);
        this.symmetryMode = symmetryMode;
    }

    public void setSymmetryMode(int value) {
        this.symmetryMode = value;
    }

    public static double getSymmetryFidelity(StrategySketch sample, int symmetryType) {
        return StrategySketchSymmetricEmbryogeny.getSymmetryFidelity(sample, StrategySketchSymmetricEmbryogeny.getSymmetricVersion(sample, symmetryType));
    }

    public static double getSymmetryFidelity(StrategySketch sample, StrategySketch symMap) {
        boolean[][] impassableMap = sample.getImpassableArray();
        boolean[][] resourceMap = sample.getResourceArray();
        boolean[][] baseMap = sample.getBaseArray();
        boolean[][] sym_impassableMap = symMap.getImpassableArray();
        boolean[][] sym_resourceMap = symMap.getResourceArray();
        boolean[][] sym_baseMap = symMap.getBaseArray();
        boolean[][] xor_impassableMap = Matrix2D.xor(sym_impassableMap, impassableMap);
        boolean[][] xor_resourceMap = Matrix2D.xor(sym_resourceMap, resourceMap);
        boolean[][] xor_baseMap = Matrix2D.xor(sym_baseMap, baseMap);
        boolean[][] union_impassableMap = Matrix2D.union(sym_impassableMap, impassableMap);
        boolean[][] union_resourceMap = Matrix2D.union(sym_resourceMap, resourceMap);
        boolean[][] union_baseMap = Matrix2D.union(sym_baseMap, baseMap);
        double result = 0.0;
        int xor_impassableCount = Matrix2D.count(xor_impassableMap);
        int xor_resCount = Matrix2D.count(xor_resourceMap);
        int xor_baseCount = Matrix2D.count(xor_baseMap);
        int union_impassableCount = Matrix2D.count(union_impassableMap);
        int union_resCount = Matrix2D.count(union_resourceMap);
        int union_baseCount = Matrix2D.count(union_baseMap);
        int typeCount = 0;
        if (union_impassableCount > 0) {
            result += 1.0 - (double)xor_impassableCount / (double)union_impassableCount;
            ++typeCount;
        }
        if (union_resCount > 0) {
            result += 1.0 - (double)xor_resCount / (double)union_resCount;
            ++typeCount;
        }
        if (union_baseCount > 0) {
            result += 1.0 - (double)xor_baseCount / (double)union_baseCount;
            ++typeCount;
        }
        if (typeCount > 0) {
            result /= (double)typeCount;
        }
        return result;
    }

    public static int getClosestSymmetry(StrategySketch sample, double threshold) {
        int[] symTypes = new int[]{11, 12, 13, 14, 21, 22, 23, 24};
        int bestSymmetry = -1;
        double closestFitValue = -1.0;
        for (int i = 0; i < symTypes.length; ++i) {
            StrategySketch symMap = StrategySketchSymmetricEmbryogeny.getSymmetricVersion(sample, symTypes[i]);
            double currFitValue = StrategySketchSymmetricEmbryogeny.getSymmetryFidelity(sample, symMap);
            if (!(currFitValue > closestFitValue)) continue;
            bestSymmetry = symTypes[i];
            closestFitValue = currFitValue;
        }
        if (closestFitValue >= threshold) {
            return bestSymmetry;
        }
        return -1;
    }

    public static StrategySketch getSymmetricVersion(StrategySketch sample, int symmetryMode) {
        StrategySketch result;
        block44: {
            int x;
            int y;
            int mapSizeY;
            int mapSizeX;
            block43: {
                mapSizeX = sample.getMapSizeX();
                mapSizeY = sample.getMapSizeY();
                result = new StrategySketch(mapSizeX, mapSizeY);
                if (symmetryMode == 11) {
                    for (y = 0; y < mapSizeY; ++y) {
                        for (x = 0; x < mapSizeX / 2; ++x) {
                            if (!sample.isPassable(x, y)) {
                                result.setImpassable(x, y);
                                result.setImpassable(mapSizeX - 1 - x, y);
                            }
                            if (sample.isBase(x, y)) {
                                result.addBase(x, y);
                                result.addBase(mapSizeX - 1 - x, y);
                            }
                            if (!sample.isResource(x, y)) continue;
                            result.addResource(x, y);
                            result.addResource(mapSizeX - 1 - x, y);
                        }
                    }
                } else if (symmetryMode == 12) {
                    for (y = 0; y < mapSizeY; ++y) {
                        for (x = mapSizeX / 2; x < mapSizeX; ++x) {
                            if (!sample.isPassable(x, y)) {
                                result.setImpassable(x, y);
                                result.setImpassable(mapSizeX - 1 - x, y);
                            }
                            if (sample.isBase(x, y)) {
                                result.addBase(x, y);
                                result.addBase(mapSizeX - 1 - x, y);
                            }
                            if (!sample.isResource(x, y)) continue;
                            result.addResource(x, y);
                            result.addResource(mapSizeX - 1 - x, y);
                        }
                    }
                } else if (symmetryMode == 13) {
                    for (y = 0; y < mapSizeY; ++y) {
                        for (x = 0; x < mapSizeX / 2; ++x) {
                            if (!sample.isPassable(x, y)) {
                                result.setImpassable(x, y);
                                result.setImpassable(mapSizeX - 1 - x, mapSizeY - 1 - y);
                            }
                            if (sample.isBase(x, y)) {
                                result.addBase(x, y);
                                result.addBase(mapSizeX - 1 - x, mapSizeY - 1 - y);
                            }
                            if (!sample.isResource(x, y)) continue;
                            result.addResource(x, y);
                            result.addResource(mapSizeX - 1 - x, mapSizeY - 1 - y);
                        }
                    }
                } else if (symmetryMode == 14) {
                    for (y = 0; y < mapSizeY; ++y) {
                        for (x = mapSizeX / 2; x < mapSizeX; ++x) {
                            if (!sample.isPassable(x, y)) {
                                result.setImpassable(x, y);
                                result.setImpassable(mapSizeX - 1 - x, mapSizeY - 1 - y);
                            }
                            if (sample.isBase(x, y)) {
                                result.addBase(x, y);
                                result.addBase(mapSizeX - 1 - x, mapSizeY - 1 - y);
                            }
                            if (!sample.isResource(x, y)) continue;
                            result.addResource(x, y);
                            result.addResource(mapSizeX - 1 - x, mapSizeY - 1 - y);
                        }
                    }
                } else if (symmetryMode == 21) {
                    for (y = 0; y < mapSizeY / 2; ++y) {
                        for (x = 0; x < mapSizeX; ++x) {
                            if (!sample.isPassable(x, y)) {
                                result.setImpassable(x, y);
                                result.setImpassable(x, mapSizeY - 1 - y);
                            }
                            if (sample.isBase(x, y)) {
                                result.addBase(x, y);
                                result.addBase(x, mapSizeY - 1 - y);
                            }
                            if (!sample.isResource(x, y)) continue;
                            result.addResource(x, y);
                            result.addResource(x, mapSizeY - 1 - y);
                        }
                    }
                } else if (symmetryMode == 22) {
                    for (y = mapSizeY / 2; y < mapSizeY; ++y) {
                        for (x = 0; x < mapSizeX; ++x) {
                            if (!sample.isPassable(x, y)) {
                                result.setImpassable(x, y);
                                result.setImpassable(x, mapSizeY - 1 - y);
                            }
                            if (sample.isBase(x, y)) {
                                result.addBase(x, y);
                                result.addBase(x, mapSizeY - 1 - y);
                            }
                            if (!sample.isResource(x, y)) continue;
                            result.addResource(x, y);
                            result.addResource(x, mapSizeY - 1 - y);
                        }
                    }
                }
                if (symmetryMode != 23) break block43;
                for (y = 0; y < mapSizeY / 2; ++y) {
                    for (x = 0; x < mapSizeX; ++x) {
                        if (!sample.isPassable(x, y)) {
                            result.setImpassable(x, y);
                            result.setImpassable(mapSizeX - 1 - x, mapSizeY - 1 - y);
                        }
                        if (sample.isBase(x, y)) {
                            result.addBase(x, y);
                            result.addBase(mapSizeX - 1 - x, mapSizeY - 1 - y);
                        }
                        if (!sample.isResource(x, y)) continue;
                        result.addResource(x, y);
                        result.addResource(mapSizeX - 1 - x, mapSizeY - 1 - y);
                    }
                }
                break block44;
            }
            if (symmetryMode != 24) break block44;
            for (y = mapSizeY / 2; y < mapSizeY; ++y) {
                for (x = 0; x < mapSizeX; ++x) {
                    if (!sample.isPassable(x, y)) {
                        result.setImpassable(x, y);
                        result.setImpassable(mapSizeX - 1 - x, mapSizeY - 1 - y);
                    }
                    if (sample.isBase(x, y)) {
                        result.addBase(x, y);
                        result.addBase(mapSizeX - 1 - x, mapSizeY - 1 - y);
                    }
                    if (!sample.isResource(x, y)) continue;
                    result.addResource(x, y);
                    result.addResource(mapSizeX - 1 - x, mapSizeY - 1 - y);
                }
            }
        }
        return result;
    }

    public static StrategySketchGene getSymmetricVersion(StrategySketchGene sample, int mapSizeX, int mapSizeY, int symmetryMode, ParameterCollection symmetricalParameters) {
        int j;
        int j2;
        int y;
        int x;
        int i;
        int midPoint;
        StrategySketchGene result = null;
        boolean[] sampleAlleles = sample.getGenotype();
        int geneSize = 0;
        if (symmetryMode >= 10 && symmetryMode < 20) {
            geneSize = (int)Math.ceil(mapSizeX / 2) * mapSizeY * 3;
        } else if (symmetryMode >= 20 && symmetryMode < 30) {
            geneSize = (int)Math.ceil(mapSizeY / 2) * mapSizeX * 3;
        }
        boolean[] resultAlleles = new boolean[geneSize];
        int tileLength = (int)Math.floor(sample.getGenotype().length / 3);
        int count = 0;
        if (symmetryMode == 11 || symmetryMode == 13) {
            midPoint = (int)Math.ceil(mapSizeX / 2);
            for (i = 0; i < tileLength; ++i) {
                x = i % mapSizeX;
                y = (int)Math.floor(i / mapSizeX);
                if ((midPoint % 2 != 0 || x >= midPoint) && (midPoint % 2 != 1 || x > midPoint)) continue;
                for (j2 = 0; j2 < 3; ++j2) {
                    resultAlleles[(x + y * midPoint) * 3 + j2] = sampleAlleles[(x + y * mapSizeX) * 3 + j2];
                }
                ++count;
            }
            result = new StrategySketchGene(resultAlleles, mapSizeX / 2, mapSizeY, symmetricalParameters);
        }
        if (symmetryMode == 12 || symmetryMode == 14) {
            midPoint = (int)Math.ceil(mapSizeX / 2);
            for (i = 0; i < tileLength; ++i) {
                int symX;
                x = i % mapSizeX;
                y = (int)Math.floor(i / mapSizeX);
                int n = symX = midPoint % 2 == 0 ? mapSizeX - 1 - x : mapSizeX - 1 - x;
                if ((midPoint % 2 != 0 || symX >= midPoint) && (midPoint % 2 != 1 || symX > midPoint)) continue;
                for (j = 0; j < 3; ++j) {
                    resultAlleles[(symX + y * midPoint) * 3 + j] = sampleAlleles[(x + y * mapSizeX) * 3 + j];
                }
                ++count;
            }
            result = new StrategySketchGene(resultAlleles, mapSizeX / 2, mapSizeY, symmetricalParameters);
        }
        if (symmetryMode == 21 || symmetryMode == 23) {
            midPoint = (int)Math.ceil(mapSizeY / 2);
            for (i = 0; i < tileLength; ++i) {
                x = i % mapSizeX;
                y = (int)Math.floor(i / mapSizeX);
                if ((midPoint % 2 != 0 || y >= midPoint) && (midPoint % 2 != 1 || y > midPoint)) continue;
                for (j2 = 0; j2 < 3; ++j2) {
                    resultAlleles[(x + y * mapSizeX) * 3 + j2] = sampleAlleles[(x + y * mapSizeX) * 3 + j2];
                }
                ++count;
            }
            result = new StrategySketchGene(resultAlleles, mapSizeX, mapSizeY / 2, symmetricalParameters);
        }
        if (symmetryMode == 22 || symmetryMode == 24) {
            midPoint = (int)Math.ceil(mapSizeY / 2);
            for (i = 0; i < tileLength; ++i) {
                int symY;
                x = i % mapSizeX;
                y = (int)Math.floor(i / mapSizeX);
                int n = symY = midPoint % 2 == 0 ? mapSizeY - 1 - y : mapSizeY - 1 - y;
                if ((midPoint % 2 != 0 || symY >= midPoint) && (midPoint % 2 != 1 || symY > midPoint)) continue;
                for (j = 0; j < 3; ++j) {
                    resultAlleles[(x + symY * mapSizeX) * 3 + j] = sampleAlleles[(x + y * mapSizeX) * 3 + j];
                }
                ++count;
            }
            result = new StrategySketchGene(resultAlleles, mapSizeX, mapSizeY / 2, symmetricalParameters);
        }
        return result;
    }

    public static ParameterCollection convertGeneticParameters(StrategySketch sample, int symmetryMode, ParameterCollection originalParameters) {
        int x;
        int y;
        int mapSizeX = sample.getMapSizeX();
        int mapSizeY = sample.getMapSizeY();
        if (symmetryMode == 2 || symmetryMode == 3 || symmetryMode == 21 || symmetryMode == 22) {
            mapSizeX = (int)Math.ceil(mapSizeX / 2);
        }
        if (symmetryMode == 1 || symmetryMode == 3 || symmetryMode == 11 || symmetryMode == 12) {
            mapSizeY = (int)Math.ceil(mapSizeY / 2);
        }
        ParameterCollection result = new ParameterCollection(originalParameters);
        result.setParameter("mapSizeX", mapSizeX);
        result.setParameter("mapSizeY", mapSizeY);
        boolean[][] res_map = sample.getResourceArray();
        boolean[][] base_map = sample.getBaseArray();
        int totalBases = Math.max(2, sample.getBaseLength());
        int totalResources = Math.max(2, sample.getResourceLength());
        int symBases = symmetryMode == 3 || symmetryMode > 30 ? totalBases / 4 : totalBases / 2;
        int symResources = symmetryMode == 3 || symmetryMode > 30 ? totalResources / 4 : totalResources / 2;
        int res_tlQuad = 0;
        int res_trQuad = 0;
        int res_blQuad = 0;
        int res_brQuad = 0;
        int base_tlQuad = 0;
        int base_trQuad = 0;
        int base_blQuad = 0;
        int base_brQuad = 0;
        for (y = 0; y < res_map.length / 2; ++y) {
            for (x = 0; x < res_map.length / 2; ++x) {
                if (res_map[x][y]) {
                    ++res_tlQuad;
                }
                if (!base_map[x][y]) continue;
                ++base_tlQuad;
            }
            for (x = res_map.length / 2; x < res_map.length; ++x) {
                if (res_map[x][y]) {
                    ++res_trQuad;
                }
                if (!base_map[x][y]) continue;
                ++base_trQuad;
            }
        }
        for (y = res_map.length / 2; y < res_map.length; ++y) {
            for (x = 0; x < res_map.length / 2; ++x) {
                if (res_map[x][y]) {
                    ++res_blQuad;
                }
                if (!base_map[x][y]) continue;
                ++base_blQuad;
            }
            for (x = res_map.length / 2; x < res_map.length; ++x) {
                if (res_map[x][y]) {
                    ++res_brQuad;
                }
                if (!base_map[x][y]) continue;
                ++base_brQuad;
            }
        }
        int bases = 0;
        int resources = 0;
        if (symmetryMode == 21) {
            resources = res_tlQuad + res_trQuad;
            bases = base_brQuad + base_trQuad;
        }
        if (symmetryMode == 22) {
            resources = res_blQuad + res_brQuad;
            resources = base_blQuad + base_brQuad;
        }
        if (symmetryMode == 11) {
            resources = res_tlQuad + res_blQuad;
            resources = base_tlQuad + base_blQuad;
        }
        if (symmetryMode == 12) {
            resources = res_trQuad + res_brQuad;
            bases = base_trQuad + base_brQuad;
        }
        result.setParameter("genotypeMinResources", Math.min(symResources, resources));
        result.setParameter("genotypeMaxResources", Math.max(symResources, resources));
        result.setParameter("genotypeMinInitialResources", Math.min(symResources, resources));
        result.setParameter("genotypeMaxInitialResources", Math.max(symResources, resources));
        result.setParameter("genotypeMinBases", Math.min(symBases, bases));
        result.setParameter("genotypeMaxBases", Math.max(symBases, bases));
        result.setParameter("genotypeMinInitialBases", Math.min(symBases, bases));
        result.setParameter("genotypeMaxInitialBases", Math.max(symBases, bases));
        return result;
    }

    @Override
    public StrategySketch createPhenotype(boolean[] genotype) {
        int j;
        int y;
        int x;
        int i;
        int midPoint;
        StrategySketch result = new StrategySketch(this.mapSizeX, this.mapSizeY);
        int tileLength = (int)Math.floor(genotype.length / 3);
        if (this.symmetryMode == 1 || this.symmetryMode >= 10 && this.symmetryMode < 20) {
            midPoint = (int)Math.ceil(this.mapSizeX / 2);
            for (i = 0; i < tileLength; ++i) {
                x = i % midPoint;
                y = (int)Math.floor(i / midPoint);
                for (j = 0; j < 3; ++j) {
                    if (!genotype[i * 3 + j]) continue;
                    if (j == 0) {
                        result.setImpassable(x, y);
                        if (this.symmetryMode == 11 || this.symmetryMode == 12) {
                            result.setImpassable(this.mapSizeX - 1 - x, y);
                            continue;
                        }
                        if (this.symmetryMode != 13 && this.symmetryMode != 14) continue;
                        result.setImpassable(this.mapSizeX - 1 - x, this.mapSizeY - 1 - y);
                        continue;
                    }
                    if (j == 1) {
                        result.addBase(x, y);
                        if (this.symmetryMode == 11 || this.symmetryMode == 12) {
                            result.addBase(this.mapSizeX - 1 - x, y);
                            continue;
                        }
                        if (this.symmetryMode != 13 && this.symmetryMode != 14) continue;
                        result.addBase(this.mapSizeX - 1 - x, this.mapSizeY - 1 - y);
                        continue;
                    }
                    if (j != 2) continue;
                    result.addResource(x, y);
                    if (this.symmetryMode == 11 || this.symmetryMode == 12) {
                        result.addResource(this.mapSizeX - 1 - x, y);
                        continue;
                    }
                    if (this.symmetryMode != 13 && this.symmetryMode != 14) continue;
                    result.addResource(this.mapSizeX - 1 - x, this.mapSizeY - 1 - y);
                }
            }
        }
        if (this.symmetryMode == 2 || this.symmetryMode >= 20 && this.symmetryMode < 30) {
            for (int i2 = 0; i2 < tileLength; ++i2) {
                int x2 = i2 % this.mapSizeX;
                int y2 = (int)Math.floor(i2 / this.mapSizeX);
                for (int j2 = 0; j2 < 3; ++j2) {
                    if (!genotype[i2 * 3 + j2]) continue;
                    if (j2 == 0) {
                        result.setImpassable(x2, y2);
                        if (this.symmetryMode == 21 || this.symmetryMode == 22) {
                            result.setImpassable(x2, this.mapSizeY - 1 - y2);
                            continue;
                        }
                        if (this.symmetryMode != 23 && this.symmetryMode != 24) continue;
                        result.setImpassable(this.mapSizeX - 1 - x2, this.mapSizeY - 1 - y2);
                        continue;
                    }
                    if (j2 == 1) {
                        result.addBase(x2, y2);
                        if (this.symmetryMode == 21 || this.symmetryMode == 22) {
                            result.addBase(x2, this.mapSizeY - 1 - y2);
                            continue;
                        }
                        if (this.symmetryMode != 23 && this.symmetryMode != 24) continue;
                        result.addBase(this.mapSizeX - 1 - x2, this.mapSizeY - 1 - y2);
                        continue;
                    }
                    if (j2 != 2) continue;
                    result.addResource(x2, y2);
                    if (this.symmetryMode == 21 || this.symmetryMode == 22) {
                        result.addResource(x2, this.mapSizeY - 1 - y2);
                        continue;
                    }
                    if (this.symmetryMode != 23 && this.symmetryMode != 24) continue;
                    result.addResource(this.mapSizeX - 1 - x2, this.mapSizeY - 1 - y2);
                }
            }
        }
        if (this.symmetryMode == 3 || this.symmetryMode >= 30 && this.symmetryMode < 40) {
            midPoint = (int)Math.ceil(this.mapSizeX / 2);
            for (i = 0; i < tileLength; ++i) {
                x = i % midPoint;
                y = (int)Math.floor(i / midPoint);
                for (j = 0; j < 3; ++j) {
                    if (!genotype[i * 3 + j]) continue;
                    if (j == 0) {
                        result.setImpassable(x, y);
                        result.setImpassable(x, this.mapSizeY - 1 - y);
                        result.setImpassable(this.mapSizeX - 1 - x, y);
                        result.setImpassable(this.mapSizeX - 1 - x, this.mapSizeY - 1 - y);
                        continue;
                    }
                    if (j == 1) {
                        result.addBase(x, y);
                        result.addBase(x, this.mapSizeY - 1 - y);
                        result.addBase(this.mapSizeX - 1 - x, y);
                        result.addBase(this.mapSizeX - 1 - x, this.mapSizeY - 1 - y);
                        continue;
                    }
                    if (j != 2) continue;
                    result.addResource(x, y);
                    result.addResource(x, this.mapSizeY - 1 - y);
                    result.addResource(this.mapSizeX - 1 - x, y);
                    result.addResource(this.mapSizeX - 1 - x, this.mapSizeY - 1 - y);
                }
            }
        }
        result.finalizeSketch();
        return result;
    }
}

