/*
 * Decompiled with CFR 0.152.
 */
package strategymap.genetic.fitness;

import genetic.fitness.Fitness;
import genetic.fitness.WeightedFitness;
import strategymap.StrategySketch;
import strategymap.constraints.DataConstraints;
import strategymap.constraints.FitnessConstraints;
import strategymap.constraints.StrategyConstraints;
import strategymap.constraints.TileConstraints;
import util.image.processing.Thresholding;
import util.math2d.Matrix2D;

public class ConstraintFitness
extends WeightedFitness {
    public ConstraintFitness(StrategyConstraints constraints, float minSafety) {
        this.add(0.05, new ChokePointFitness(constraints.getTileConstraints()));
        this.add(0.05, new DeadEndFitness(constraints.getTileConstraints()));
        this.add(0.05, new OpenAreaFitness(constraints.getTileConstraints()));
        this.add(0.05, new UnusedSpaceFitness(constraints.getTileConstraints()));
        this.add(0.1, new SafeSpaceFitness(constraints.getTileConstraints(), minSafety));
        this.add(0.35, new DataFidelityFitness(constraints.getDataConstraints()));
        this.add(0.35, new FitnessFidelityFitness(constraints.getFitnessConstraints()));
    }

    class FitnessFidelityFitness
    extends Fitness<StrategySketch> {
        FitnessConstraints constraints;

        public FitnessFidelityFitness(FitnessConstraints constraints) {
            this.constraints = constraints;
        }

        public double evaluateSpecific(StrategySketch phenotype) {
            double result = 0.0;
            int[] metrics = phenotype.getMetrics().getDataArray();
            for (int i = 0; i < metrics.length; ++i) {
                int c_index = this.constraints.findIndex(i);
                if (c_index == -1 || !this.constraints.isValid(metrics[i], c_index)) continue;
                double currFitness = this.constraints.getNormalizedDifference(metrics[i], c_index);
                result += currFitness;
            }
            return result /= (double)this.constraints.size();
        }
    }

    class DataFidelityFitness
    extends Fitness<StrategySketch> {
        DataConstraints constraints;

        public DataFidelityFitness(DataConstraints constraints) {
            this.constraints = constraints;
        }

        public double evaluateSpecific(StrategySketch phenotype) {
            double result = 0.0;
            int[] metrics = phenotype.getMetrics().getDataArray();
            for (int i = 0; i < metrics.length; ++i) {
                int c_index = this.constraints.findIndex(i);
                if (c_index == -1 || !this.constraints.isValid(metrics[i], c_index)) continue;
                double currFitness = this.constraints.getNormalizedDifference(metrics[i], c_index);
                result += currFitness;
            }
            return result /= (double)this.constraints.size();
        }
    }

    class SafeSpaceFitness
    extends TileFidelityFitness {
        float minSafety;

        public SafeSpaceFitness(TileConstraints constraints, float minSafety) {
            super(constraints);
            this.minSafety = minSafety;
        }

        @Override
        public double evaluateSpecific(StrategySketch phenotype) {
            boolean[][] safeAreas = new boolean[phenotype.getMapSizeX()][phenotype.getMapSizeY()];
            for (int i = 0; i < phenotype.getBaseLength(); ++i) {
                safeAreas = Matrix2D.union(safeAreas, Thresholding.getArrayAboveValue(phenotype.getPaths().getSafetyMatrix(i), this.minSafety));
            }
            return this.evaluateSafetyTable(safeAreas);
        }

        protected double evaluateSafetyTable(boolean[][] lookupTable) {
            int successCount = 0;
            int allCount = 0;
            for (int x = 0; x < lookupTable.length; ++x) {
                for (int y = 0; y < lookupTable[0].length; ++y) {
                    if (this.constraints.hasConstraint(x, y, TileConstraints.Type.SAFESPACE)) {
                        if (lookupTable[x][y]) {
                            ++successCount;
                        }
                        ++allCount;
                        continue;
                    }
                    if (!this.constraints.hasConstraint(x, y, TileConstraints.Type.UNSAFESPACE)) continue;
                    if (!lookupTable[x][y]) {
                        ++successCount;
                    }
                    ++allCount;
                }
            }
            if (allCount == 0 || allCount == successCount) {
                return 0.0;
            }
            return (double)(allCount - successCount) / (double)allCount;
        }
    }

    class UnusedSpaceFitness
    extends TileFidelityFitness {
        public UnusedSpaceFitness(TileConstraints constraints) {
            super(constraints);
        }

        @Override
        public double evaluateSpecific(StrategySketch phenotype) {
            return this.evaluateLookupTable(phenotype.getPaths().getUnusedSpaces(), TileConstraints.Type.UNUSEDSPACE);
        }
    }

    class OpenAreaFitness
    extends TileFidelityFitness {
        public OpenAreaFitness(TileConstraints constraints) {
            super(constraints);
        }

        @Override
        public double evaluateSpecific(StrategySketch phenotype) {
            return this.evaluateLookupTable(phenotype.getPaths().getOpenAreas(), TileConstraints.Type.OPENAREA);
        }
    }

    class DeadEndFitness
    extends TileFidelityFitness {
        public DeadEndFitness(TileConstraints constraints) {
            super(constraints);
        }

        @Override
        public double evaluateSpecific(StrategySketch phenotype) {
            return this.evaluateLookupTable(phenotype.getPaths().getDeadEnds(), TileConstraints.Type.DEADEND);
        }
    }

    class ChokePointFitness
    extends TileFidelityFitness {
        public ChokePointFitness(TileConstraints constraints) {
            super(constraints);
        }

        @Override
        public double evaluateSpecific(StrategySketch phenotype) {
            return this.evaluateLookupTable(phenotype.getPaths().getChokePoints(), TileConstraints.Type.CHOKEPOINT);
        }
    }

    abstract class TileFidelityFitness
    extends Fitness<StrategySketch> {
        TileConstraints constraints;

        public TileFidelityFitness(TileConstraints constraints) {
            this.constraints = constraints;
        }

        protected double evaluateLookupTable(boolean[][] lookupTable, TileConstraints.Type constraint) {
            int successCount = 0;
            int allCount = 0;
            for (int x = 0; x < lookupTable.length; ++x) {
                for (int y = 0; y < lookupTable[0].length; ++y) {
                    if (!this.constraints.hasConstraint(x, y, constraint)) continue;
                    if (lookupTable[x][y]) {
                        ++successCount;
                    }
                    ++allCount;
                }
            }
            if (allCount == 0 || allCount == successCount) {
                return 0.0;
            }
            return (double)(allCount - successCount) / (double)allCount;
        }

        public abstract double evaluateSpecific(StrategySketch var1);
    }
}

