/*
 * Decompiled with CFR 0.152.
 */
package strategymap.genetic.fitness;

import genetic.fitness.Fitness;
import genetic.fitness.WeightedFitness;
import strategymap.StrategySketch;

public class InfeasibleFitness
extends WeightedFitness<StrategySketch> {
    public InfeasibleFitness(int minBases, int maxBases, int minResources, int maxResources) {
        this.add(-0.25, new BasesFitness(minBases, maxBases));
        this.add(-0.25, new ResourcesFitness(minResources, maxResources));
        this.add(-0.25, new BaseReachabilityFitness());
        this.add(-0.25, new ResourceReachabilityFitness());
        this.label = "infeasibility";
    }

    class ResourceReachabilityFitness
    extends Fitness<StrategySketch> {
        ResourceReachabilityFitness() {
        }

        public double evaluateSpecific(StrategySketch phenotype) {
            int resourcePairs = phenotype.getBaseLength() * phenotype.getResourceLength();
            if (resourcePairs == 0) {
                return 0.0;
            }
            double result = (double)(resourcePairs - phenotype.getPaths().getResourcePathLength()) / (double)resourcePairs;
            return result;
        }
    }

    class BaseReachabilityFitness
    extends Fitness<StrategySketch> {
        BaseReachabilityFitness() {
        }

        public double evaluateSpecific(StrategySketch phenotype) {
            if (phenotype.getBaseLength() <= 1) {
                return 0.0;
            }
            int basePairs = phenotype.getBaseLength() * (phenotype.getBaseLength() - 1) / 2;
            double result = (double)(basePairs - phenotype.getPaths().getBasePathLength()) / (double)basePairs;
            return result;
        }
    }

    class ResourcesFitness
    extends Fitness<StrategySketch> {
        final int minResources;
        final int maxResources;

        public ResourcesFitness(int minResources, int maxResources) {
            this.minResources = minResources;
            this.maxResources = maxResources;
        }

        public double evaluateSpecific(StrategySketch phenotype) {
            double result = 0.0;
            if (phenotype.getResourceLength() > this.maxResources) {
                result = (double)(phenotype.getResourceLength() - this.maxResources) / (double)this.maxResources;
            } else if (phenotype.getResourceLength() < this.minResources) {
                result = (double)(this.minResources - phenotype.getResourceLength()) / (double)this.minResources;
            }
            return result;
        }
    }

    class BasesFitness
    extends Fitness<StrategySketch> {
        final int minBases;
        final int maxBases;

        public BasesFitness(int minBases, int maxBases) {
            this.minBases = minBases;
            this.maxBases = maxBases;
        }

        public double evaluateSpecific(StrategySketch phenotype) {
            double result = 0.0;
            if (phenotype.getBaseLength() > this.maxBases) {
                result = (double)(phenotype.getBaseLength() - this.maxBases) / (double)this.maxBases;
            } else if (phenotype.getBaseLength() < this.minBases) {
                result = (double)(this.minBases - phenotype.getBaseLength()) / (double)this.minBases;
            }
            return result;
        }
    }
}

