/*
 * Decompiled with CFR 0.152.
 */
package strategymap.visualization;

import common.PathLibrary;
import java.util.Vector;
import processing.core.PApplet;
import renderer.Render2D;
import strategymap.DetailConverter;
import util.math2d.Point2D;

public class Map3DVisualizer {
    public static Render2D renderHeightmap(PApplet p, DetailConverter converter, int imgSizeX, int imgSizeY) {
        int i;
        int i2;
        int layers = 10;
        int[] colors = new int[]{20, 80, 120, 160, 200};
        boolean[][] impassable = converter.getMapPatterns();
        Render2D renderer = new Render2D(p, impassable.length, impassable[0].length, imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(colors[0]), p.color(0));
        for (i2 = 1; i2 < colors.length; ++i2) {
            for (int j = 0; j < layers; ++j) {
                impassable = DetailConverter.runCellularFilter(impassable);
                renderer.renderTiles(impassable, p.color(colors[i2] + 3 * j));
            }
            impassable = DetailConverter.runSparseRandomizeFilter(impassable);
        }
        for (i2 = 0; i2 < converter.getMap().getResourceLength(); ++i2) {
            renderer.renderMidpoint(converter.getMap().getResource(i2), p.color(0), 7);
        }
        int gridModX = converter.getMap().getMapSizeX() / converter.getSketch().getMapSizeX();
        int gridModY = converter.getMap().getMapSizeY() / converter.getSketch().getMapSizeY();
        for (i = 0; i < converter.getSketch().getBaseLength(); ++i) {
            Point2D tile = converter.getSketch().getBase(i);
            renderer.renderMidpoint((int)((0.5 + tile.x) * (double)gridModX), (int)((0.5 + tile.y) * (double)gridModY), p.color(0), 25);
        }
        if (converter.getSketch().getPaths().getBasePaths() != null) {
            for (i = 0; i < converter.getSketch().getPaths().getBasePathLength(); ++i) {
                Vector<Point2D> path = PathLibrary.transformPath(converter.getSketch().getPaths().getBasePaths().get(i));
                for (int j = 0; j < path.size(); ++j) {
                    path.get((int)j).x = (0.5 + path.get((int)j).x) * (double)gridModX;
                    path.get((int)j).y = (0.5 + path.get((int)j).y) * (double)gridModY;
                }
                renderer.renderPath(path, p.color(0), 7.0f);
            }
        }
        return renderer;
    }

    public static Render2D renderTerrainAlpha(PApplet p, DetailConverter converter, int imgSizeX, int imgSizeY) {
        int i;
        int layers = 10;
        int[] colors = new int[]{20, 80, 120, 160, 200};
        boolean[][] impassable = converter.getMapPatterns();
        Render2D renderer = new Render2D(p, impassable.length, impassable[0].length, imgSizeX, imgSizeY);
        renderer.renderTiles(impassable, p.color(0, 255, 0), p.color(colors[0], 255 - colors[0], 0));
        for (int i2 = 1; i2 < colors.length; ++i2) {
            for (int j = 0; j < layers; ++j) {
                int redHue = colors[i2] + 3 * j;
                impassable = DetailConverter.runCellularFilter(impassable);
                renderer.renderTiles(impassable, p.color(redHue, 255 - redHue * 2, 0));
            }
            impassable = DetailConverter.runSparseRandomizeFilter(impassable);
        }
        int gridModX = converter.getMap().getMapSizeX() / converter.getSketch().getMapSizeX();
        int gridModY = converter.getMap().getMapSizeY() / converter.getSketch().getMapSizeY();
        if (converter.getSketch().getPaths().getBasePaths() != null) {
            for (i = 0; i < converter.getSketch().getPaths().getBasePathLength(); ++i) {
                Vector<Point2D> path = PathLibrary.transformPath(converter.getSketch().getPaths().getBasePaths().get(i));
                for (int j = 0; j < path.size(); ++j) {
                    path.get((int)j).x = (0.5 + path.get((int)j).x) * (double)gridModX;
                    path.get((int)j).y = (0.5 + path.get((int)j).y) * (double)gridModY;
                }
                renderer.renderPath(path, p.color(0, 0, 255), 5.0f);
            }
        }
        for (i = 0; i < converter.getMap().getResourceLength(); ++i) {
            renderer.renderMidpoint(converter.getMap().getResource(i), p.color(0, 0, 255), 7);
        }
        for (i = 0; i < converter.getSketch().getBaseLength(); ++i) {
            Point2D tile = converter.getSketch().getBase(i);
            renderer.renderMidpoint((int)((0.5 + tile.x) * (double)gridModX), (int)((0.5 + tile.y) * (double)gridModY), p.color(0, 0, 255), 25);
        }
        return renderer;
    }
}

