/*
 * Decompiled with CFR 0.152.
 */
package strategymap.visualization;

import ai.pathfinder.Connector;
import ai.pathfinder.Node;
import ai.pathfinder.Pathfinder;
import common.PathLibrary;
import java.util.ArrayList;
import java.util.Vector;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import renderer.Render2D;
import renderer.SpriteRender2D;
import strategymap.DetailConverter;
import strategymap.StrategySketch;
import strategymap.constraints.StrategyConstraints;
import strategymap.constraints.TileConstraints;
import util.image.processing.ImageProcessing;
import util.image.processing.Thresholding;
import util.math2d.Matrix2D;
import util.math2d.Point2D;
import util.math2d.Vector2D;

public class MapVisualizer {
    static final int[][] baseColors = new int[][]{{255, 0, 0}, {0, 0, 255}, {64, 255, 64}, {128, 0, 255}, {255, 255, 0}, {0, 255, 255}, {255, 255, 255}, {0, 0, 0}};
    static int explorationIndex = 0;

    public static Render2D renderThumbnail(PApplet p, StrategySketch map) {
        return MapVisualizer.renderThumbnail(p, map, map.getMapSizeX(), map.getMapSizeY());
    }

    public static Render2D renderThumbnail(PApplet p, StrategySketch map, int imgSizeX, int imgSizeY) {
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] resources = map.getResourceArray();
        boolean[][] bases = map.getBaseArray();
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(45, 20, 0), p.color(206, 103, 0));
        renderer.renderTiles(resources, p.color(100, 200, 200));
        renderer.renderTiles(bases, p.color(255, 255, 255));
        return renderer;
    }

    public static Render2D renderHeightmap(PApplet p, DetailConverter converter, int imgSizeX, int imgSizeY) {
        int layers = 10;
        int[] colors = new int[]{20, 80, 120, 160, 200};
        boolean[][] impassable = converter.getMapPatterns();
        Render2D renderer = new Render2D(p, impassable.length, impassable[0].length, imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(colors[0]), p.color(0));
        for (int i = 1; i < colors.length; ++i) {
            for (int j = 0; j < layers; ++j) {
                impassable = DetailConverter.runCellularFilter(impassable);
                renderer.renderTiles(impassable, p.color(colors[i] + 3 * j));
            }
            impassable = DetailConverter.runSparseRandomizeFilter(impassable);
        }
        return renderer;
    }

    public static Render2D renderGradient(PApplet p, DetailConverter converter, int imgSizeX, int imgSizeY) {
        int layers = 10;
        int[] colors = new int[]{10, 20, 30, 40, 50};
        boolean[][] impassable = converter.getMapPatterns();
        Render2D renderer = new Render2D(p, impassable.length, impassable[0].length, imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(180, 80, 0), p.color(206, 103, 0));
        for (int i = 1; i < colors.length; ++i) {
            for (int j = 0; j < layers; ++j) {
                impassable = DetailConverter.runCellularFilter(impassable);
                int hue = colors[colors.length - i] + 3 * j;
                renderer.renderTiles(impassable, p.color(hue, hue / 2, 0));
            }
            impassable = DetailConverter.runSparseRandomizeFilter(impassable);
        }
        boolean[][] resources = converter.getMap().getResourceArray();
        boolean[][] bases = converter.getMap().getBaseArray();
        renderer.renderTiles(resources, p.color(100, 200, 200));
        renderer.renderTiles(bases, p.color(255, 255, 255));
        return renderer;
    }

    public static Render2D renderWaterworks(PApplet p, StrategySketch map, DetailConverter converter, int imgSizeX, int imgSizeY) {
        int[] colors = new int[]{p.color(0, 200, 0), p.color(100, 255, 0), p.color(0, 200, 255), p.color(0, 100, 255), p.color(0, 0, 255), p.color(0, 0, 180)};
        int layers = 10;
        boolean[][] impassable = converter.getMapPatterns();
        boolean[][] resources = converter.getMap().getResourceArray();
        boolean[][] bases = converter.getMap().getBaseArray();
        Render2D renderer = new Render2D(p, impassable.length, impassable[0].length, imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, colors[1], colors[0]);
        for (int i = 2; i < colors.length; ++i) {
            for (int j = 0; j < layers; ++j) {
                impassable = DetailConverter.runCellularFilter(impassable);
                renderer.renderTiles(impassable, colors[i]);
            }
            impassable = DetailConverter.runSparseRandomizeFilter(impassable);
        }
        float bridgeWidth = 3 * Math.min(renderer.getGridSizeX(), renderer.getGridSizeY());
        boolean[][] chokePoints = map.getPaths().getChokePoints();
        if (map.getPaths() != null && map.getPaths().getAStar() != null) {
            Pathfinder astar = map.getPaths().getAStar();
            for (int i = 0; i < astar.nodes.size(); ++i) {
                Node n = (Node)astar.nodes.get(i);
                if (!n.walkable) continue;
                Connector conn = null;
                for (int j = 0; j < n.links.size(); ++j) {
                    conn = (Connector)n.links.get(j);
                    if (!chokePoints[(int)n.x][(int)n.y] || map.isBase((int)n.x, (int)n.y) || map.isResource((int)n.x, (int)n.y)) continue;
                    Point2D start = PathLibrary.transformNode(n);
                    start.x += 0.5;
                    start.x *= (double)converter.getGridSizeX();
                    start.y += 0.5;
                    start.y *= (double)converter.getGridSizeY();
                    Point2D end = Vector2D.interpolate(PathLibrary.transformNode(n), PathLibrary.transformNode(conn.n), 0.3f);
                    end.x += 0.5;
                    end.x *= (double)converter.getGridSizeX();
                    end.y += 0.5;
                    end.y *= (double)converter.getGridSizeY();
                    renderer.renderLine(start, end, p.color(120, 40, 0), bridgeWidth);
                    renderer.renderMidpoint(start, p.color(120, 40, 0), (int)bridgeWidth);
                }
            }
        }
        renderer.renderTiles(resources, p.color(200, 0, 100));
        renderer.renderTiles(bases, p.color(255, 255, 255));
        return renderer;
    }

    public static Render2D renderDungeon(PApplet p, StrategySketch map, int imgSizeX, int imgSizeY) {
        Point2D end;
        Point2D start;
        int j;
        Connector conn;
        int j2;
        int i;
        int y;
        int x;
        int gridSize = 10;
        boolean wallSize = true;
        int doorSize = 4;
        int[] color = new int[]{p.color(0), p.color(255), p.color(120, 40, 0), p.color(200, 0, 100), p.color(255, 255, 0)};
        boolean[][] resources = map.getResourceArray();
        boolean[][] bases = map.getBaseArray();
        boolean[][] passable = map.getPassableArray();
        boolean[][] chokePoints = map.getPaths().getChokePoints();
        boolean[][] openAreas = map.getPaths().getOpenAreas();
        Render2D renderer = new Render2D(p, map.getMapSizeX() * gridSize, map.getMapSizeY() * gridSize, imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderBackground(color[0]);
        for (x = 0; x < passable.length; ++x) {
            for (y = 0; y < passable[x].length; ++y) {
                if (!passable[x][y] || chokePoints[x][y] && !bases[x][y] && !resources[x][y]) continue;
                for (i = 1; i < gridSize - 1; ++i) {
                    for (j2 = 1; j2 < gridSize - 1; ++j2) {
                        renderer.renderTile(x * gridSize + i, y * gridSize + j2, color[1]);
                    }
                }
            }
        }
        for (x = 0; x < passable.length; ++x) {
            for (y = 0; y < passable[x].length; ++y) {
                if (!openAreas[x][y]) continue;
                for (i = -gridSize + 1; i < 2 * gridSize - 1; ++i) {
                    for (j2 = -gridSize + 1; j2 < 2 * gridSize - 1; ++j2) {
                        renderer.renderTile(x * gridSize + i, y * gridSize + j2, color[1]);
                    }
                }
            }
        }
        float corridorWidth = Math.min(renderer.getGridSizeX(), renderer.getGridSizeY()) * gridSize / 3;
        if (map.getPaths() != null && map.getPaths().getAStar() != null) {
            Pathfinder astar = map.getPaths().getAStar();
            for (i = 0; i < astar.nodes.size(); ++i) {
                Node n = (Node)astar.nodes.get(i);
                if (!n.walkable) continue;
                conn = null;
                for (j = 0; j < n.links.size(); ++j) {
                    conn = (Connector)n.links.get(j);
                    start = PathLibrary.transformNode(n);
                    end = Vector2D.interpolate(PathLibrary.transformNode(n), PathLibrary.transformNode(conn.n), 0.5f);
                    if (start.x != end.x && start.y != end.y) continue;
                    start.x = (start.x + 0.5) * (double)gridSize;
                    start.y = (start.y + 0.5) * (double)gridSize;
                    end.x = (end.x + 0.5) * (double)gridSize;
                    end.y = (end.y + 0.5) * (double)gridSize;
                    renderer.renderLine(start, end, color[1], corridorWidth);
                    renderer.renderMidrect(start, color[1], (int)corridorWidth, (int)corridorWidth);
                }
            }
        }
        if (map.getPaths() != null && map.getPaths().getAStar() != null) {
            Pathfinder astar = map.getPaths().getAStar();
            for (i = 0; i < astar.nodes.size(); ++i) {
                Node n = (Node)astar.nodes.get(i);
                if (!n.walkable) continue;
                conn = null;
                for (j = 0; j < n.links.size(); ++j) {
                    conn = (Connector)n.links.get(j);
                    start = PathLibrary.transformNode(n);
                    end = Vector2D.interpolate(PathLibrary.transformNode(n), PathLibrary.transformNode(conn.n), 0.5f);
                    if (start.x == end.x || start.y == end.y) continue;
                    start.x *= (double)gridSize;
                    start.y *= (double)gridSize;
                    end.x = (end.x + 1.5) * (double)gridSize;
                    end.y = (end.y + 1.5) * (double)gridSize;
                    int x2 = (int)start.x + 1;
                    while ((double)x2 < end.x - 1.0) {
                        int y2 = (int)start.y + 1;
                        while ((double)y2 < end.y - 1.0) {
                            renderer.renderTile(x2, y2, color[1]);
                            ++y2;
                        }
                        ++x2;
                    }
                }
            }
        }
        int locationDiameter = Math.min(renderer.getGridSizeX(), renderer.getGridSizeY()) * gridSize / 2;
        for (int x3 = 0; x3 < bases.length; ++x3) {
            for (int y3 = 0; y3 < bases[x3].length; ++y3) {
                if (bases[x3][y3]) {
                    renderer.renderMidNgon((int)(((double)x3 + 0.5) * (double)gridSize), (int)(((double)y3 + 0.5) * (double)gridSize), color[3], locationDiameter, 3, true);
                }
                if (!resources[x3][y3]) continue;
                renderer.renderMidpoint((int)(((double)x3 + 0.5) * (double)gridSize), (int)(((double)y3 + 0.5) * (double)gridSize), color[4], locationDiameter, true);
            }
        }
        return renderer;
    }

    public static Render2D renderNavmeshThumbnail(PApplet p, StrategySketch map) {
        return MapVisualizer.renderNavmeshThumbnail(p, map, map.getMapSizeX(), map.getMapSizeY());
    }

    public static Render2D renderNavmeshThumbnail(PApplet p, StrategySketch map, int imgSizeX, int imgSizeY) {
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] resources = map.getResourceArray();
        boolean[][] bases = map.getBaseArray();
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(45, 20, 0), p.color(206, 103, 0));
        boolean[][] deadEnds = map.getPaths().getDeadEnds();
        boolean[][] chokePoints = map.getPaths().getChokePoints();
        boolean[][] openSpaces = map.getPaths().getOpenAreas();
        renderer.renderTiles(deadEnds, p.color(0, 0, 0, 75));
        renderer.renderTiles(chokePoints, p.color(255, 0, 128, 75));
        renderer.renderTiles(openSpaces, p.color(255, 255, 0, 75));
        if (map.getPaths() != null && map.getPaths().getAStar() != null) {
            Pathfinder astar = map.getPaths().getAStar();
            for (int i = 0; i < astar.nodes.size(); ++i) {
                Node n = (Node)astar.nodes.get(i);
                if (!n.walkable) continue;
                Connector conn = null;
                for (int j = 0; j < n.links.size(); ++j) {
                    conn = (Connector)n.links.get(j);
                    renderer.renderLine(PathLibrary.transformNode(conn.n), PathLibrary.transformNode(n), p.color(0, 255, 0), 2.0f);
                    int pointColor = p.color(0, 255, 0);
                    if (openSpaces[(int)conn.n.x][(int)conn.n.y]) {
                        pointColor = p.color(255, 255, 0);
                    }
                    if (chokePoints[(int)conn.n.x][(int)conn.n.y]) {
                        pointColor = p.color(255, 0, 128);
                    }
                    if (deadEnds[(int)conn.n.x][(int)conn.n.y]) {
                        pointColor = p.color(0, 0, 0);
                    }
                    renderer.renderMidpoint(PathLibrary.transformNode(conn.n), pointColor, 10);
                    pointColor = p.color(0, 255, 0);
                    if (openSpaces[(int)n.x][(int)n.y]) {
                        pointColor = p.color(255, 255, 0);
                    }
                    if (deadEnds[(int)n.x][(int)n.y]) {
                        pointColor = p.color(0, 0, 0);
                    }
                    if (chokePoints[(int)n.x][(int)n.y]) {
                        pointColor = p.color(255, 0, 128);
                    }
                    renderer.renderMidpoint(PathLibrary.transformNode(n), pointColor, 10);
                }
            }
        }
        return renderer;
    }

    public static Render2D renderUnusedSpaceThumbnail(PApplet p, StrategySketch map) {
        return MapVisualizer.renderUnusedSpaceThumbnail(p, map, map.getMapSizeX(), map.getMapSizeY());
    }

    public static Render2D renderUnusedSpaceThumbnail(PApplet p, StrategySketch map, int imgSizeX, int imgSizeY) {
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] resources = map.getResourceArray();
        boolean[][] bases = map.getBaseArray();
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(45, 20, 0), p.color(206, 103, 0));
        renderer.renderTiles(resources, p.color(100, 200, 200));
        renderer.renderTiles(bases, p.color(255, 255, 255));
        if (map.getPaths() != null && map.getPaths().getResourcePaths() != null && map.getPaths().getBasePaths() != null) {
            int i;
            boolean[][] unusedSpace = map.getPaths().getUnusedSpaces();
            renderer.renderTiles(unusedSpace, p.color(255, 127, 39));
            for (i = 0; i < map.getPaths().getResourcePaths().size(); ++i) {
                ArrayList path = map.getPaths().getResourcePaths().get(i);
                Vector<Point2D> points = PathLibrary.transformPath(path);
                renderer.renderPath(points, p.color(0, 0, 255), 2.0f);
            }
            for (i = 0; i < map.getPaths().getBasePaths().size(); ++i) {
                renderer.renderPath(PathLibrary.transformPath(map.getPaths().getBasePaths().get(i)), p.color(200), 5.0f);
            }
        }
        return renderer;
    }

    public static Render2D renderSegmentsThumbnail(PApplet p, StrategySketch map) {
        return MapVisualizer.renderSegmentsThumbnail(p, map, map.getMapSizeX(), map.getMapSizeY());
    }

    public static Render2D renderSegmentsThumbnail(PApplet p, StrategySketch map, int imgSizeX, int imgSizeY) {
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] resources = map.getResourceArray();
        boolean[][] bases = map.getBaseArray();
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(45, 20, 0), p.color(206, 103, 0));
        renderer.renderTiles(resources, p.color(100, 200, 200));
        renderer.renderTiles(bases, p.color(255, 255, 255));
        boolean[][] altImpassable = Matrix2D.copy(impassable);
        boolean[][] chokePoints = map.getPaths().getChokePoints();
        altImpassable = Matrix2D.union(altImpassable, chokePoints);
        altImpassable = Matrix2D.invert(altImpassable);
        Vector<boolean[][]> segments = ImageProcessing.getSegments(altImpassable, 0);
        for (int i = 0; i < segments.size(); ++i) {
            int cIndex = Math.min(i, baseColors.length - 1);
            renderer.renderTiles(segments.get(i), p.color(baseColors[cIndex][0], baseColors[cIndex][1], baseColors[cIndex][2], 160));
        }
        return renderer;
    }

    public static Render2D renderSafeSegmentsThumbnail(PApplet p, StrategySketch map) {
        return MapVisualizer.renderSafeSegmentsThumbnail(p, map, map.getMapSizeX(), map.getMapSizeY());
    }

    public static Render2D renderSafeSegmentsThumbnail(PApplet p, StrategySketch map, int imgSizeX, int imgSizeY) {
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] resources = map.getResourceArray();
        boolean[][] bases = map.getBaseArray();
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(45, 20, 0), p.color(206, 103, 0));
        renderer.renderTiles(resources, p.color(100, 200, 200));
        renderer.renderTiles(bases, p.color(255, 255, 255));
        boolean[][] altImpassable = Matrix2D.copy(impassable);
        boolean[][] chokePoints = map.getPaths().getChokePoints();
        altImpassable = Matrix2D.union(altImpassable, chokePoints);
        for (int j = 0; j < map.getBaseLength(); ++j) {
            altImpassable = Matrix2D.subtract(altImpassable, Thresholding.getArrayAboveValue(map.getPaths().getSafetyMatrix(j), 0.35f));
        }
        altImpassable = Matrix2D.invert(altImpassable);
        System.out.println(Matrix2D.print(altImpassable));
        Vector<boolean[][]> segments = ImageProcessing.getSegments(altImpassable, 0);
        for (int i = 0; i < segments.size(); ++i) {
            int cIndex = Math.min(i, baseColors.length - 1);
            renderer.renderTiles(segments.get(i), p.color(baseColors[cIndex][0], baseColors[cIndex][1], baseColors[cIndex][2], 160));
        }
        return renderer;
    }

    public static Render2D renderExplorationThumbnail(PApplet p, StrategySketch map) {
        return MapVisualizer.renderExplorationThumbnail(p, map, map.getMapSizeX(), map.getMapSizeY());
    }

    public static Render2D renderExplorationThumbnail(PApplet p, StrategySketch map, int imgSizeX, int imgSizeY) {
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] resources = map.getResourceArray();
        boolean[][] bases = map.getBaseArray();
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderTiles(impassable, p.color(0), p.color(255));
        renderer.renderTiles(resources, p.color(100, 200, 200));
        renderer.renderTiles(bases, p.color(255, 255, 255));
        int i = ++explorationIndex % map.getBaseLength();
        float[][] temp = map.getPaths().getExplorationMatrix(i);
        System.out.println(Matrix2D.print(Thresholding.getArrayAboveValue(temp, 0.2f)));
        int c_on = p.color(baseColors[i][0], baseColors[i][1], baseColors[i][2], 160);
        renderer.renderTiles(temp, c_on);
        return renderer;
    }

    public static Render2D renderPathsThumbnail(PApplet p, StrategySketch map) {
        return MapVisualizer.renderPathsThumbnail(p, map, map.getMapSizeX(), map.getMapSizeY());
    }

    public static Render2D renderPathsThumbnail(PApplet p, StrategySketch map, int imgSizeX, int imgSizeY) {
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] resources = map.getResourceArray();
        boolean[][] bases = map.getBaseArray();
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(45, 20, 0), p.color(206, 103, 0));
        renderer.renderTiles(resources, p.color(100, 200, 200));
        renderer.renderTiles(bases, p.color(255, 255, 255));
        if (map.getPaths() != null) {
            int i;
            int gridSizeY;
            int gridSizeX;
            if (map.getPaths().getBasePaths() != null) {
                gridSizeX = imgSizeX / map.getMapSizeX();
                gridSizeY = imgSizeY / map.getMapSizeY();
                for (i = 0; i < map.getPaths().getBasePaths().size(); ++i) {
                    renderer.renderPath(PathLibrary.transformPath(map.getPaths().getBasePaths().get(i)), p.color(200), 5.0f);
                }
            }
            if (map.getPaths().getResourcePaths() != null) {
                gridSizeX = imgSizeX / map.getMapSizeX();
                gridSizeY = imgSizeY / map.getMapSizeY();
                for (i = 0; i < map.getPaths().getResourcePaths().size(); ++i) {
                    renderer.renderPath(PathLibrary.transformPath(map.getPaths().getResourcePaths().get(i)), p.color(0, 0, 255), 2.0f);
                }
            }
        }
        return renderer;
    }

    public static Render2D renderChokePointThumbnail(PApplet p, StrategySketch map) {
        return MapVisualizer.renderPathsThumbnail(p, map, map.getMapSizeX(), map.getMapSizeY());
    }

    public static Render2D renderChokePointThumbnail(PApplet p, StrategySketch map, int imgSizeX, int imgSizeY) {
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] resources = map.getResourceArray();
        boolean[][] bases = map.getBaseArray();
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(45, 20, 0), p.color(206, 103, 0));
        renderer.renderTiles(resources, p.color(100, 200, 200));
        renderer.renderTiles(bases, p.color(255, 255, 255));
        if (map.getPaths() != null && map.getPaths().getBasePaths() != null) {
            for (int i = 0; i < map.getPaths().getBasePaths().size(); ++i) {
                ArrayList path = map.getPaths().getBasePaths().get(i);
                Node start = (Node)path.get(0);
                Node end = (Node)path.get(path.size() - 1);
                Vector<Point2D> chokePoints = map.getPaths().calculateChokePoints(path);
                renderer.renderPath(PathLibrary.transformPath(path), p.color(200), 5.0f);
                renderer.renderTiles(map.getArray(chokePoints), p.color(200, 0, 0, 75));
                for (int j = 0; j < chokePoints.size(); ++j) {
                    boolean[][] altImpassable = Matrix2D.copy(impassable);
                    altImpassable[(int)chokePoints.get((int)j).x][(int)chokePoints.get((int)j).y] = true;
                    ArrayList altPath = PathLibrary.getPath((int)start.x, (int)start.y, (int)end.x, (int)end.y, altImpassable);
                    if (altPath == null) continue;
                    renderer.renderPath(PathLibrary.transformPath(altPath), p.color(0, 200, 0), 3.0f);
                }
            }
        }
        return renderer;
    }

    public static Render2D renderNearbyResourcesThumbnail(PApplet p, StrategySketch map) {
        return MapVisualizer.renderNearbyResourcesThumbnail(p, map, map.getMapSizeX(), map.getMapSizeY());
    }

    public static Render2D renderNearbyResourcesThumbnail(PApplet p, StrategySketch map, int imgSizeX, int imgSizeY) {
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] resources = map.getResourceArray();
        boolean[][] bases = map.getBaseArray();
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(45, 20, 0), p.color(206, 103, 0));
        renderer.renderTiles(bases, p.color(255, 255, 255));
        renderer.renderTiles(resources, p.color(100, 200, 200));
        for (int j = 0; j < map.getResourceLength(); ++j) {
            float[] resourceSafety = map.getPaths().getResourceSafety(j);
            for (int i = 0; i < resourceSafety.length; ++i) {
                if (!(resourceSafety[i] > 0.35f)) continue;
                ArrayList path = map.getPaths().getResourcePath(i, j);
                renderer.renderPath(PathLibrary.transformPath(path), p.color(0, 155, 0), 3.0f);
                renderer.renderTile(map.getResource(j), p.color(0.0f, 255.0f, 0.0f, 255.0f * (resourceSafety[i] - 0.35f) / 0.65f));
            }
        }
        return renderer;
    }

    public static Render2D renderDFSPathsThumbnail(PApplet p, StrategySketch map) {
        return MapVisualizer.renderDFSPathsThumbnail(p, map, map.getMapSizeX(), map.getMapSizeY());
    }

    public static Render2D renderDFSPathsThumbnail(PApplet p, StrategySketch map, int imgSizeX, int imgSizeY) {
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] resources = map.getResourceArray();
        boolean[][] bases = map.getBaseArray();
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(45, 20, 0), p.color(206, 103, 0));
        renderer.renderTiles(bases, p.color(255, 255, 255));
        renderer.renderTiles(resources, p.color(100, 200, 200));
        for (int i = 0; i < map.getBaseLength(); ++i) {
            for (int j = i + 1; j < map.getBaseLength(); ++j) {
                Vector<ArrayList> allPaths = map.getPaths().calculateDFSPaths(map.getBase(i), map.getBase(j));
                for (int k = 0; k < allPaths.size(); ++k) {
                    renderer.renderPath(PathLibrary.transformPath(allPaths.get(k)), p.color(0, 0, 0), 1.0f);
                }
            }
        }
        return renderer;
    }

    public static Render2D renderSafetyMatrix(PApplet p, StrategySketch map) {
        return MapVisualizer.renderSafetyMatrix(p, map, map.getMapSizeX(), map.getMapSizeY());
    }

    public static Render2D renderSafetyMatrix(PApplet p, StrategySketch map, int imgSizeX, int imgSizeY) {
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] resources = map.getResourceArray();
        boolean[][] bases = map.getBaseArray();
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(45, 20, 0), p.color(206, 103, 0));
        renderer.renderTiles(bases, p.color(255, 255, 255));
        renderer.renderTiles(resources, p.color(100, 200, 200));
        for (int j = 0; j < map.getBaseLength(); ++j) {
            int c_on = p.color(baseColors[j][0], baseColors[j][1], baseColors[j][2], 160);
            renderer.renderTiles(Thresholding.getArrayAboveValue(map.getPaths().getSafetyMatrix(j), 0.35f), c_on);
        }
        return renderer;
    }

    public static Render2D renderMap(PApplet p, StrategySketch map) {
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] resources = map.getResourceArray();
        boolean[][] bases = map.getBaseArray();
        PImage passableTile = p.loadImage("./resources/tilesets/simple/ground.png");
        PImage impassableTile = p.loadImage("./resources/tilesets/simple/impassable.png");
        PImage resourceTile = p.loadImage("./resources/tilesets/simple/mineral.png");
        PImage baseTile = p.loadImage("./resources/tilesets/simple/base5.png");
        int imgSizeX = map.getMapSizeX() * passableTile.width;
        int imgSizeY = map.getMapSizeY() * passableTile.height;
        SpriteRender2D renderer = new SpriteRender2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, impassableTile, passableTile);
        renderer.renderTiles(resources, resourceTile);
        renderer.renderTiles(bases, baseTile);
        return renderer;
    }

    public static Render2D renderTileConstraints(Render2D renderer, StrategyConstraints constraints) {
        if (constraints == null) {
            return renderer;
        }
        PGraphics pg = renderer.getGraphics();
        pg.beginDraw();
        for (int x = 0; x < constraints.getMapSizeX(); ++x) {
            for (int y = 0; y < constraints.getMapSizeY(); ++y) {
                Vector<TileConstraints.Type> tileConstraints = constraints.getTileConstraints().getConstraints(x, y);
                if (tileConstraints.isEmpty()) continue;
                int tlc_X = x * renderer.getGridSizeX();
                int tlc_Y = y * renderer.getGridSizeY();
                int brc_X = tlc_X + renderer.getGridSizeX();
                int brc_Y = tlc_Y + renderer.getGridSizeY();
                int[] color = new int[4];
                int colorIndex = 0;
                for (int i = 0; i < tileConstraints.size() && colorIndex < 4; ++i) {
                    if (tileConstraints.get(i) == TileConstraints.Type.UNCHANGED) {
                        color[colorIndex++] = pg.color(195);
                    }
                    if (tileConstraints.get(i) == TileConstraints.Type.RANDOMIZE) {
                        color[colorIndex++] = pg.color(255, 0, 255);
                    }
                    if (tileConstraints.get(i) == TileConstraints.Type.CHOKEPOINT) {
                        color[colorIndex++] = pg.color(255, 0, 0);
                    }
                    if (tileConstraints.get(i) == TileConstraints.Type.DEADEND) {
                        color[colorIndex++] = pg.color(0);
                    }
                    if (tileConstraints.get(i) == TileConstraints.Type.OPENAREA) {
                        color[colorIndex++] = pg.color(255, 255, 0);
                    }
                    if (tileConstraints.get(i) == TileConstraints.Type.UNUSEDSPACE) {
                        color[colorIndex++] = pg.color(255, 127, 39);
                    }
                    if (tileConstraints.get(i) == TileConstraints.Type.SAFESPACE) {
                        color[colorIndex++] = pg.color(0, 255, 0);
                    }
                    if (tileConstraints.get(i) == TileConstraints.Type.UNSAFESPACE) {
                        color[colorIndex++] = pg.color(0, 0, 255);
                    }
                    if (colorIndex == 1) {
                        color[1] = color[0];
                        color[2] = color[1];
                        color[3] = color[2];
                        continue;
                    }
                    if (colorIndex == 2) {
                        color[2] = color[0];
                        color[3] = color[1];
                        continue;
                    }
                    if (colorIndex != 3) continue;
                    color[3] = color[2];
                }
                pg.fill(color[0]);
                pg.triangle(tlc_X, tlc_Y, tlc_X + renderer.getGridSizeX() / 3, tlc_Y, tlc_X, tlc_Y + renderer.getGridSizeY() / 3);
                pg.fill(color[1]);
                pg.triangle(brc_X, tlc_Y, brc_X - renderer.getGridSizeX() / 3, tlc_Y, brc_X, tlc_Y + renderer.getGridSizeY() / 3);
                pg.fill(color[2]);
                pg.triangle(tlc_X, brc_Y, tlc_X + renderer.getGridSizeX() / 3, brc_Y, tlc_X, brc_Y - renderer.getGridSizeY() / 3);
                pg.fill(color[3]);
                pg.triangle(brc_X, brc_Y, brc_X - renderer.getGridSizeX() / 3, brc_Y, brc_X, brc_Y - renderer.getGridSizeY() / 3);
                pg.stroke(0);
                pg.strokeWeight(1.0f);
                pg.noFill();
                pg.line(tlc_X, tlc_Y, brc_X, tlc_Y);
                pg.line(tlc_X, tlc_Y, tlc_X, brc_Y);
                pg.line(tlc_X, brc_Y, brc_X, brc_Y);
                pg.line(brc_X, tlc_Y, brc_X, brc_Y);
                pg.stroke(color[0]);
                pg.line(tlc_X + 1, tlc_Y + 1, tlc_X + renderer.getGridSizeX() / 2, tlc_Y + 1);
                pg.line(tlc_X + 1, tlc_Y + 1, tlc_X + 1, tlc_Y + renderer.getGridSizeY() / 2);
                pg.stroke(color[1]);
                pg.line(tlc_X + renderer.getGridSizeX() / 2, tlc_Y + 1, brc_X - 1, tlc_Y + 1);
                pg.line(brc_X - 1, tlc_Y + 1, brc_X - 1, tlc_Y + renderer.getGridSizeY() / 2);
                pg.stroke(color[2]);
                pg.line(tlc_X + 1, tlc_Y + renderer.getGridSizeY() / 2, tlc_X + 1, brc_Y - 1);
                pg.line(tlc_X + 1, brc_Y - 1, tlc_X + renderer.getGridSizeX() / 2, brc_Y - 1);
                pg.stroke(color[3]);
                pg.line(brc_X - 1, tlc_Y + renderer.getGridSizeY() / 2, brc_X - 1, brc_Y - 1);
                pg.line(tlc_X + renderer.getGridSizeX() / 2, brc_Y - 1, brc_X - 1, brc_Y - 1);
                pg.stroke(0);
                pg.line(tlc_X + 2, tlc_Y + 2, brc_X - 2, tlc_Y + 2);
                pg.line(tlc_X + 2, tlc_Y + 2, tlc_X + 2, brc_Y - 2);
                pg.line(tlc_X + 2, brc_Y - 2, brc_X - 2, brc_Y - 2);
                pg.line(brc_X - 2, tlc_Y + 2, brc_X - 2, brc_Y - 2);
                pg.noStroke();
            }
        }
        pg.endDraw();
        return renderer;
    }
}

