/*
 * Decompiled with CFR 0.152.
 */
package strategysketch.screens.components;

import java.util.Arrays;
import strategymap.StrategySketch;
import strategymap.constraints.FitnessConstraints;
import ui.BaseApplet;
import ui.components.UIButton;
import ui.components.UIButtonImage;
import ui.components.UIComparativeProgressBar;
import ui.components.UILabel;
import ui.components.UIToggleButtonGroup;
import ui.screens.UIContainer;
import util.math2d.Point2D;

public class StatsPanel
extends UIContainer {
    double[] evaluationScores;
    int[] dataScores;
    String[] evaluationLabels = new String[]{"Resource_Safety", "Safe_Area", "Exploration", "Resource_Safety_Fairness", "Safe_Area_Fairness", "Exploration_Fairness"};
    int[][] evaluationColors = new int[][]{{0, 0, 255}, {255, 0, 128}, {0, 255, 0}, {0, 0, 128}, {128, 0, 64}, {0, 128, 0}};
    String[] dataLabels = new String[]{"Bases", "Resources", "Used_Space", "Max_Base_Distance", "Avg_Base_Distance", "Min_Base_Distance", "Choke_Points", "Dead_Ends", "Open_Areas"};

    public void updateSingleData(int data, int index) {
        UILabel l = (UILabel)this.getComponent(this.dataLabels[index] + "Data_Label");
        if (index == 2) {
            l.setCaption("" + data + "%");
        } else {
            l.setCaption("" + data);
        }
    }

    public void updateSingleEvaluation(double evaluationScore, int index) {
        if (this.evaluationScores[index] == -1.0) {
            this.show(this.evaluationLabels[index] + "None_Label");
            this.hide(this.evaluationLabels[index] + "_Bar");
        } else {
            this.hide(this.evaluationLabels[index] + "None_Label");
            this.show(this.evaluationLabels[index] + "_Bar");
        }
        UIComparativeProgressBar pb = (UIComparativeProgressBar)this.getComponent(this.evaluationLabels[index] + "_Bar");
        pb.setProgress(this.evaluationScores[index]);
    }

    public void updateEvaluations(StrategySketch map, double[] evaluationScores) {
        int i;
        this.evaluationScores = Arrays.copyOf(evaluationScores, evaluationScores.length);
        for (i = 0; i < this.evaluationLabels.length; ++i) {
            this.updateSingleEvaluation(evaluationScores[i], i);
        }
        this.dataScores = map.getMetrics().getDataArray();
        for (i = 0; i < this.dataScores.length; ++i) {
            this.updateSingleData(this.dataScores[i], i);
        }
    }

    public StatsPanel(BaseApplet p, int x, int y) {
        super(p);
        this.initialize(x, y);
    }

    protected void initializeSingleEvaluation(int positionX, int positionY, int index) {
        UIComparativeProgressBar pb = new UIComparativeProgressBar(this.p, 0, 0, 100, 20);
        pb.setTopLeftPosition(positionX, positionY);
        pb.setColor(this.p.color(this.evaluationColors[index][0], this.evaluationColors[index][1], this.evaluationColors[index][2]));
        this.addComponent(this.evaluationLabels[index] + "_Bar", pb);
        UILabel l = new UILabel(this.p, "N/A", pb.getPositionX(), pb.getPositionY());
        this.addComponent(this.evaluationLabels[index] + "None_Label", l);
        this.hide(this.evaluationLabels[index] + "None_Label");
        l = new UILabel(this.p, this.evaluationLabels[index].replace("_", " "), pb.getPositionX(), pb.getPositionY() - pb.getHeight());
        this.addComponent(this.evaluationLabels[index] + "_Label", l);
        l = new UILabel(this.p, "++", 0, 0, "Large");
        l.setTextColor(this.p.color(0, 255, 0));
        l.setTopLeftPosition(pb.getTopRightCorner());
        l.setCaption("");
        this.addComponent(this.evaluationLabels[index] + "Plus_Label", l);
        l = new UILabel(this.p, "--", 0, 0, "Large");
        l.setTextColor(this.p.color(255, 0, 0));
        l.setBottomRightPosition(pb.getBottomLeftCorner());
        l.setCaption("");
        this.addComponent(this.evaluationLabels[index] + "Minus_Label", l);
        l = (UILabel)this.getComponent(this.evaluationLabels[index] + "_Label");
        Point2D trp = l.getTopRightCorner();
        this.addComponent(this.evaluationLabels[index] + "ConstraintsPanel", new StatsConstraintPanel(this.p, pb.getPositionX() + pb.getWidth() / 2 + 20, (int)trp.y, true));
        this.hide(this.evaluationLabels[index] + "ConstraintsPanel");
    }

    protected void initializeSingleData(int positionX, int positionY, int index) {
        UILabel l = new UILabel(this.p, this.dataLabels[index].replace("_", " ") + ": ", 0, 0, "Large");
        l.setTopRightPosition(positionX, positionY);
        this.addComponent(this.dataLabels[index] + "_Label", l);
        l = new UILabel(this.p, "XXX", 0, 0, "Large");
        l.setTextCenter(1);
        l.setTopLeftPosition(positionX - 19, positionY);
        l.setCaption("");
        this.addComponent(this.dataLabels[index] + "Data_Label", l);
        l = new UILabel(this.p, "XXX", 0, 0, "Large");
        l.setTextCenter(1);
        l.setTopLeftPosition(positionX + 23, positionY);
        l.setCaption("");
        this.addComponent(this.dataLabels[index] + "Other_Label", l);
        l = (UILabel)this.getComponent(this.dataLabels[index] + "_Label");
        this.addComponent(this.dataLabels[index] + "ConstraintsPanel", new StatsConstraintPanel(this.p, positionX + 100, positionY, false));
    }

    protected void initialize(int positionX, int positionY) {
        int i;
        int x = positionX;
        int y = positionY;
        for (i = 0; i < this.evaluationLabels.length; ++i) {
            if (i == this.evaluationLabels.length / 2) {
                x += 195;
                y = positionY;
            }
            this.initializeSingleEvaluation(x, y, i);
            y += 60;
        }
        x = positionX + 170;
        y = positionY += 170;
        for (i = 0; i < this.dataLabels.length; ++i) {
            this.initializeSingleData(x, y, i);
            y += 35;
        }
    }

    public void removeSingleComparison(int index) {
        UILabel l = (UILabel)this.getComponent(this.evaluationLabels[index] + "Plus_Label");
        l.setCaption("");
        l = (UILabel)this.getComponent(this.evaluationLabels[index] + "Minus_Label");
        l.setCaption("");
        UIComparativeProgressBar pb = (UIComparativeProgressBar)this.getComponent(this.evaluationLabels[index] + "_Bar");
        pb.setAltProgress(-1.0);
    }

    public void removeSingleData(int index) {
        UILabel l = (UILabel)this.getComponent(this.dataLabels[index] + "Other_Label");
        l.setCaption("");
    }

    public void removeComparisons() {
        int i;
        for (i = 0; i < this.evaluationLabels.length; ++i) {
            this.removeSingleComparison(i);
        }
        for (i = 0; i < this.dataLabels.length; ++i) {
            this.removeSingleData(i);
        }
    }

    public void updateSingleDataComparison(int otherData, int index) {
        UILabel l = (UILabel)this.getComponent(this.dataLabels[index] + "Other_Label");
        if (otherData > this.dataScores[index]) {
            l.setTextColor(this.p.color(0, 255, 0));
        } else if (otherData < this.dataScores[index]) {
            l.setTextColor(this.p.color(255, 0, 0));
        } else {
            l.setTextColor(this.p.color(128));
        }
        if (index == 2) {
            l.setCaption("" + otherData + "%");
        } else {
            l.setCaption("" + otherData);
        }
    }

    public void updateSingleComparison(double comparativeScore, int index) {
        UILabel l = (UILabel)this.getComponent(this.evaluationLabels[index] + "Plus_Label");
        if (comparativeScore > 0.2) {
            l.setCaption("++");
        } else if (comparativeScore > 0.01) {
            l.setCaption("+");
        } else {
            l.setCaption("");
        }
        l = (UILabel)this.getComponent(this.evaluationLabels[index] + "Minus_Label");
        if (comparativeScore < -0.2) {
            l.setCaption("--");
        } else if (comparativeScore < -0.01) {
            l.setCaption("-");
        } else {
            l.setCaption("");
        }
        UIComparativeProgressBar pb = (UIComparativeProgressBar)this.getComponent(this.evaluationLabels[index] + "_Bar");
        pb.setAltProgress(comparativeScore + this.evaluationScores[index]);
    }

    public void updateComparisons(StrategySketch otherMap, double[] comparativeScores) {
        if (comparativeScores == null || otherMap == null) {
            this.removeComparisons();
        } else {
            for (int i = 0; i < this.evaluationLabels.length; ++i) {
                if (this.evaluationScores[i] == -1.0) continue;
                this.updateSingleComparison(comparativeScores[i], i);
            }
            int[] otherData = otherMap.getMetrics().getDataArray();
            for (int i = 0; i < otherData.length; ++i) {
                this.updateSingleDataComparison(otherData[i], i);
            }
        }
    }

    public void updateFitnessConstraints(FitnessConstraints currConstraints) {
        if (currConstraints == null) {
            currConstraints = new FitnessConstraints();
        }
        currConstraints.clear();
        for (int i = 0; i < this.evaluationLabels.length; ++i) {
            StatsConstraintPanel scp = (StatsConstraintPanel)this.getComponent(this.evaluationLabels[i] + "ConstraintsPanel");
            if (scp == null) continue;
            scp.updateFitnessConstraint(i, currConstraints);
        }
    }

    class StatsConstraintPanel
    extends UIContainer {
        public StatsConstraintPanel(BaseApplet p, int x, int y, boolean isFitnessBar) {
            super(p);
            if (isFitnessBar) {
                this.initializeFitnessConstraint(x, y);
            } else {
                this.initializeStatConstraint(x, y);
            }
        }

        protected void initializeFitnessConstraint(int x, int y) {
            UIToggleButtonGroup tbg = new UIToggleButtonGroup(this.p, x, y + 10, 10, 10);
            tbg.setOffset(0);
            tbg.setAllowUnselected(true);
            tbg.addButtonImage("resources/ui/modifier_increase.PNG", false);
            tbg.addButtonImage("resources/ui/modifier_lock.PNG", false);
            tbg.setOffset(10);
            tbg.addButtonImage("resources/ui/modifier_decrease.PNG", false);
            tbg.setSelectedIndex(-1);
            this.addComponent("Modifiers", tbg);
            UIButtonImage bi = new UIButtonImage(this.p, "resources/ui/modifier_abandon.PNG", x + 20, y + 10);
            this.addComponent("Abandon", bi);
        }

        protected void initializeStatConstraint(int x, int y) {
            UIToggleButtonGroup tbg = new UIToggleButtonGroup(this.p, x - 10, y, 10, 10);
            tbg.setOffset(0);
            tbg.setAllowUnselected(true);
            tbg.addButtonImage("resources/ui/modifier_increase.PNG", false);
            tbg.addButtonImageNextLine("resources/ui/modifier_lock.PNG", false);
            tbg.addButtonImageNextLine("resources/ui/modifier_decrease.PNG", false);
            tbg.setSelectedIndex(-1);
            this.addComponent("Modifiers", tbg);
            UIButtonImage bi = new UIButtonImage(this.p, "resources/ui/modifier_abandon.PNG", x, y + 10);
            this.addComponent("Abandon", bi);
        }

        @Override
        public void mouseClicked() {
            UIToggleButtonGroup tbg = (UIToggleButtonGroup)this.getComponent("Modifiers");
            UIButton b = (UIButton)this.getComponent("Abandon");
            if (b != null && b.getState() == UIButton.State.PRESSED) {
                tbg.setSelectedIndex(-1);
                b.reset();
            }
        }

        public void updateFitnessConstraint(int i, FitnessConstraints currConstraints) {
            UIToggleButtonGroup tbg = (UIToggleButtonGroup)this.getComponent("Modifiers");
            if (tbg.getSelectedIndex() != -1) {
                int selection = 1 - tbg.getSelectedIndex();
                currConstraints.add(i, (float)StatsPanel.this.evaluationScores[i], selection);
            }
        }
    }
}

