/*
 * Decompiled with CFR 0.152.
 */
package strategysketch.screens.tabbed;

import java.io.File;
import processing.core.PImage;
import renderer.Render2D;
import strategymap.DetailConverter;
import strategymap.StrategySketch;
import strategymap.constraints.FitnessConstraints;
import strategymap.constraints.StrategyConstraints;
import strategymap.constraints.TileConstraints;
import strategymap.genetic.StrategySketchSuggestions;
import strategymap.genetic.fitness.FeasibleFitness;
import strategymap.visualization.MapVisualizer;
import strategysketch.screens.components.StatsPanel;
import ui.BaseApplet;
import ui.components.UIButton;
import ui.components.UIImage;
import ui.components.UILabel;
import ui.components.UIToggleButtonGroup;
import ui.components.UIToggleButtonImage;
import ui.screens.Screen;
import util.math2d.Point2D;
import util.statics.LogManager;

public class Screen_Canvas
extends Screen {
    Point2D mouseOverTile;
    Point2D startTile;
    boolean editMode;
    DetailConverter converter;
    final int mapSizeX = 8;
    final int mapSizeY = 8;
    final int gridSizeX = 64;
    final int gridSizeY = 64;
    final int thumbSizeX = 80;
    final int thumbSizeY = 80;
    final int cellularSizeX = 10;
    final int cellularSizeY = 10;
    final int evaluationSize = 6;
    double[] evaluationScores;
    StrategySketchSuggestions suggestions;
    final int suggestionsNumber = 6;
    StrategySketch sketch;
    StrategyConstraints sketchConstraints;
    StrategySketch completeMap;
    static String filePath;

    public Screen_Canvas(BaseApplet p) {
        super(p);
        this.resetStartTile();
        this.resetSketch();
        this.converter = new DetailConverter(this.sketch, 10, 10);
        this.completeMap = null;
        this.editMode = true;
        filePath = this.findLogLocation();
        LogManager.addLogfile("Time", filePath + "/time.log");
        this.suggestions = new StrategySketchSuggestions();
        UIImage img = new UIImage(p, this.showMap(), 0, 0);
        img.setPosition(img.getWidth() / 2 + 10, img.getHeight() / 2 + 50);
        this.addComponent("Canvas", img);
        this.addComponent("Title", new UILabel(p, "Draw the map you would like to start from", p.width / 2, 20, "Huge"));
        this.addComponent("Randomize_Button", new UIButton(p, "Randomize", img.getPositionY() + img.getHeight() / 2 + 5, 190, 80, 18, "Large"));
        this.addComponent("Reset_Button", new UIButton(p, "Clear Map", img.getPositionY() + img.getHeight() / 2 + 88, 190, 75, 18, "Large"));
        this.addComponent("ClearConstraints_Button", new UIButton(p, "Clear Constraints", img.getPositionY() + img.getHeight() / 2 + 190, 190, 115, 18, "Large"));
        this.addComponent("Generate_Label", new UILabel(p, "This map is unplayable.", img.getPositionY() + img.getHeight() / 2 + 190, img.getPositionY() + img.getHeight() / 2 - 60, "Large"));
        this.hide("Generate_Label");
        this.addComponent("Generate_Button", new UIButton(p, "Show Detailed View", img.getPositionY() + img.getHeight() / 2 + 35, img.getPositionY() + img.getHeight() / 2 - 30, 135, "Large"));
        this.addComponent("ReturnToEdit_Button", new UIButton(p, "Return to Edit Mode", img.getPositionY() + img.getHeight() / 2 + 175, img.getPositionY() + img.getHeight() / 2 - 30, 135, "Large"));
        this.hide("ReturnToEdit_Button");
        UIToggleButtonGroup t = null;
        t = new UIToggleButtonGroup(p, img.getPositionX() + img.getWidth() / 2 + 50, 225, 90, 20);
        t.setAllowUnselected(false);
        t.addButtonNextLine("Simple");
        t.addButton("Navmesh");
        t.addButton("Segments");
        t.addButtonNextLine("Unused Space");
        t.addButton("Choke Points");
        t.addButton("Safe Segments");
        t.addButtonNextLine("Resource Safety");
        t.addButton("Safety Matrix");
        t.addButton("Exploration");
        t.setSelectedIndex(0);
        this.addComponent("ViewingMode_Group", t);
        t = new UIToggleButtonGroup(p, img.getPositionX() + img.getWidth() / 2 + 60, 195, 90, 20);
        t.setAllowUnselected(false);
        t.addButtonNextLine("Simple");
        t.addButtonNextLine("HeightMap");
        t.setSelectedIndex(0);
        this.addComponent("ViewingModeRender_Group", t);
        this.hide(t);
        t = new UIToggleButtonGroup(p, img.getPositionX() + img.getWidth() / 2 + 25, 75, 20, 20);
        t.setAllowUnselected(false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/ground.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/mineral.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/base1.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/impassable.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/impassable_rect.png", false);
        t.addVerticalSpacing(50);
        t.addButtonImageNextLine("resources/tilesets/simple/Paint_Group/ground.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/constraint_freeze.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/constraint_randomize.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/constraint_chokepoint.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/constraint_deadend.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/constraint_openspace.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/constraint_unusedspace.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/constraint_nearbyResource.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/constraint_unsafeResource.png", false);
        t.setSelectedIndex(0);
        for (int i = 0; i < t.size(); ++i) {
            ((UIToggleButtonImage)t.getButton(i)).setUseFrame(true);
        }
        this.addComponent("Paint_Group", t);
        String[] caption = this.findPaintLabel(t.getSelectedIndex());
        this.addComponent("Paint_Label", new UILabel(p, caption[0], img.getPositionX() + img.getWidth() / 2 + 75, 100, "Large"));
        this.addComponent("Paint_Label2", new UILabel(p, caption[1], img.getPositionX() + img.getWidth() / 2 + 75, 120, "Large"));
        this.addComponent("StatsPanel", new StatsPanel(p, img.getPositionX() + img.getWidth() / 2 + 25, 320));
        this.addComponent("AskSuggestion_Button", new UIButton(p, "Ask for Suggestion", img.getPositionX() - img.getWidth() / 2 + 70, img.getPositionY() + img.getHeight() / 2 + 20, 130, "Large"));
        this.addComponent("MoreSuggestion_Button", new UIButton(p, "More Suggestions", img.getPositionX() - img.getWidth() / 2 + 70, img.getPositionY() + img.getHeight() / 2 + 20, 130, "Large"));
        this.hide("MoreSuggestion_Button");
        this.addComponent("CancelSuggestion_Button", new UIButton(p, "Cancel Suggestions", img.getPositionX() - img.getWidth() / 2 + 215, img.getPositionY() + img.getHeight() / 2 + 20, "Large"));
        this.hide("CancelSuggestion_Button");
        this.addComponent("ApplySuggestion_Button", new UIButton(p, "Apply Suggestion", img.getPositionX() - img.getWidth() / 2 + 360, img.getPositionY() + img.getHeight() / 2 + 20, 130, "Large"));
        this.hide("ApplySuggestion_Button");
        this.addComponent("NoSuggestions_Label", new UILabel(p, "No Suggestions Found", 180, p.height - 74, 120, "Huge"));
        this.hide("NoSuggestions_Label");
        t = new UIToggleButtonGroup(p, 74, p.height - 74, 120, 120);
        this.addComponent("Suggestions_Group", t);
        this.updateSketch();
    }

    protected void resetStartTile() {
        this.startTile = null;
    }

    protected void setStartTile(int gridX, int gridY) {
        this.startTile = new Point2D(gridX, gridY);
    }

    protected void resetSketch() {
        this.sketch = new StrategySketch(8, 8);
        this.sketchConstraints = new StrategyConstraints(8, 8);
        this.mouseOverTile = null;
    }

    @Override
    public void draw() {
        super.draw();
        if (this.editMode) {
            Point2D tlc;
            UIImage c;
            UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("Paint_Group");
            if (this.startTile != null) {
                c = (UIImage)this.getComponent("Canvas");
                tlc = c.getTopLeftCorner();
                this.p.stroke(40);
                this.p.strokeWeight(2.0f);
                if (this.mouseOverTile != null) {
                    double sX = Math.min(this.startTile.x, this.mouseOverTile.x);
                    double sY = Math.min(this.startTile.y, this.mouseOverTile.y);
                    double eX = Math.max(this.startTile.x, this.mouseOverTile.x);
                    double eY = Math.max(this.startTile.y, this.mouseOverTile.y);
                    this.p.rect((float)(tlc.x + sX * 64.0), (float)(tlc.y + sY * 64.0), (float)((eX - sX + 1.0) * 64.0), (float)((eY - sY + 1.0) * 64.0));
                } else {
                    this.p.rect((float)(tlc.x + this.startTile.x * 64.0), (float)(tlc.y + this.startTile.y * 64.0), 64.0f, 64.0f);
                }
                this.p.strokeWeight(1.0f);
                this.p.noStroke();
            }
            if (this.mouseOverTile != null) {
                c = (UIImage)this.getComponent("Canvas");
                tlc = c.getTopLeftCorner();
                this.p.stroke(0.0f, 255.0f, 0.0f);
                this.p.strokeWeight(2.0f);
                this.p.rect((float)(tlc.x + this.mouseOverTile.x * 64.0), (float)(tlc.y + this.mouseOverTile.y * 64.0), 64.0f, 64.0f);
                this.p.strokeWeight(1.0f);
                this.p.noStroke();
            }
        }
    }

    protected void switchMode() {
        boolean bl = this.editMode = !this.editMode;
        if (this.editMode) {
            UIButton b = (UIButton)this.getComponent("ReturnToEdit_Button");
            this.editMode = true;
            b.reset();
            ((UIButton)this.getComponent("Generate_Button")).setCaption("Show Detailed View");
            this.hide("ReturnToEdit_Button");
            this.show("Reset_Button");
            this.show("Randomize_Button");
            this.show("ViewingMode_Group");
            this.show("Paint_Group");
            this.show("Paint_Label");
            this.show("Paint_Label2");
            this.show("ClearConstraints_Button");
            this.show("AskSuggestion_Button");
            this.show("StatsPanel");
            this.hide("ViewingModeRender_Group");
        } else {
            UIButton b = (UIButton)this.getComponent("Generate_Button");
            this.completeMap = this.converter.getMap();
            b.setCaption("Regenerate");
            this.show("ViewingModeRender_Group");
            this.show("ReturnToEdit_Button");
            this.hideSuggestions();
            this.hide("AskSuggestion_Button");
            this.hide("Reset_Button");
            this.hide("ClearConstraints_Button");
            this.hide("Randomize_Button");
            this.hide("ViewingMode_Group");
            this.hide("Paint_Group");
            this.hide("Paint_Label");
            this.hide("Paint_Label2");
            this.hide("StatsPanel");
            this.show("ViewingModeRender_Group");
        }
        UIImage c = (UIImage)this.getComponent("Canvas");
        c.setImage(this.showMap(), false);
    }

    protected void updateComparisons(int selectedIndex) {
        StatsPanel sp = (StatsPanel)this.getComponent("StatsPanel");
        if (this.suggestions.getSuggestions() == null) {
            return;
        }
        if (this.evaluationScores == null) {
            this.updateEvaluations();
        }
        if (selectedIndex == -1) {
            sp.updateComparisons(null, null);
        } else {
            double[] comparativeScores = new double[6];
            double[] fitnessScores = this.suggestions.getFitnesses(selectedIndex);
            for (int i = 0; i < fitnessScores.length; ++i) {
                comparativeScores[i] = fitnessScores[i] - this.evaluationScores[i];
            }
            sp.updateComparisons(this.suggestions.getSuggestion(selectedIndex), comparativeScores);
        }
    }

    protected void updateEvaluations() {
        this.evaluationScores = new double[6];
        for (int i = 0; i < this.evaluationScores.length; ++i) {
            FeasibleFitness fn = new FeasibleFitness(i);
            this.evaluationScores[i] = fn.evaluate(this.sketch);
        }
        StatsPanel sp = (StatsPanel)this.getComponent("StatsPanel");
        sp.updateEvaluations(this.sketch, this.evaluationScores);
        FitnessConstraints b = null;
        sp.updateFitnessConstraints(b);
    }

    protected PImage showMap() {
        Render2D renderer = null;
        if (!this.editMode) {
            UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("ViewingModeRender_Group");
            if (t == null || t.getSelectedIndex() == 0) {
                renderer = MapVisualizer.renderThumbnail(this.p, this.completeMap, 512, 512);
            } else if (t.getSelectedIndex() == 1) {
                renderer = MapVisualizer.renderHeightmap(this.p, this.converter, 512, 512);
            }
        } else {
            UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("ViewingMode_Group");
            if (t == null || t.getSelectedCaption().equalsIgnoreCase("Simple")) {
                renderer = MapVisualizer.renderThumbnail(this.p, this.sketch, 512, 512);
            } else if (t.getSelectedCaption().equalsIgnoreCase("Navmesh")) {
                renderer = MapVisualizer.renderNavmeshThumbnail(this.p, this.sketch, 512, 512);
            } else if (t.getSelectedCaption().equalsIgnoreCase("All Paths")) {
                renderer = MapVisualizer.renderPathsThumbnail(this.p, this.sketch, 512, 512);
            } else if (t.getSelectedCaption().equalsIgnoreCase("Choke Points")) {
                renderer = MapVisualizer.renderChokePointThumbnail(this.p, this.sketch, 512, 512);
            } else if (t.getSelectedCaption().equalsIgnoreCase("Resource Safety")) {
                renderer = MapVisualizer.renderNearbyResourcesThumbnail(this.p, this.sketch, 512, 512);
            } else if (t.getSelectedCaption().equalsIgnoreCase("Safety Matrix")) {
                renderer = MapVisualizer.renderSafetyMatrix(this.p, this.sketch, 512, 512);
            } else if (t.getSelectedCaption().equalsIgnoreCase("Unused Space")) {
                renderer = MapVisualizer.renderUnusedSpaceThumbnail(this.p, this.sketch, 512, 512);
            } else if (t.getSelectedCaption().equalsIgnoreCase("Segments")) {
                renderer = MapVisualizer.renderSegmentsThumbnail(this.p, this.sketch, 512, 512);
            } else if (t.getSelectedCaption().equalsIgnoreCase("Safe Segments")) {
                renderer = MapVisualizer.renderSafeSegmentsThumbnail(this.p, this.sketch, 512, 512);
            } else if (t.getSelectedCaption().equalsIgnoreCase("Exploration")) {
                renderer = MapVisualizer.renderExplorationThumbnail(this.p, this.sketch, 512, 512);
            }
            MapVisualizer.renderTileConstraints(renderer, this.sketchConstraints);
        }
        return renderer.getImage();
    }

    @Override
    public void mouseClicked() {
        StrategySketch s;
        UIToggleButtonGroup sugGroup;
        super.mouseClicked();
        UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("Paint_Group");
        UIImage c = (UIImage)this.getComponent("Canvas");
        UIButton b = null;
        b = (UIButton)this.getComponent("Reset_Button");
        if (b != null && b.getState() == UIButton.State.PRESSED) {
            this.resetSketch();
            this.updateSketch();
            c.setImage(this.showMap(), false);
            this.hideSuggestions();
        }
        if ((b = (UIButton)this.getComponent("ClearConstraints_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.sketchConstraints = new StrategyConstraints(8, 8);
            this.updateSketch();
            c.setImage(this.showMap(), false);
            this.hideSuggestions();
        }
        if ((b = (UIButton)this.getComponent("Randomize_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.sketch.randomizeChunks(10);
            this.sketch.randomize(4, 6);
            this.updateSketch();
            c.setImage(this.showMap(), false);
            this.hideSuggestions();
        }
        if ((b = (UIButton)this.getComponent("Generate_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.converter.reset(this.sketch);
            this.converter.generateMap();
            this.completeMap = this.converter.getMap();
            if (this.editMode) {
                this.switchMode();
            }
            c.setImage(this.showMap(), false);
        }
        if ((b = (UIButton)this.getComponent("AskSuggestion_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.suggestions.createSuggestions(this.sketch, this.sketchConstraints, 6);
            this.showSuggestions();
            this.updateComparisons(-1);
        }
        if ((sugGroup = (UIToggleButtonGroup)this.getComponent("Suggestions_Group")) != null && sugGroup.isMouseOver()) {
            this.updateComparisons(sugGroup.getSelectedIndex());
        }
        if ((b = (UIButton)this.getComponent("ApplySuggestion_Button")) != null && b.getState() == UIButton.State.PRESSED && sugGroup.getSelectedIndex() != -1 && (s = this.suggestions.getSuggestion(sugGroup.getSelectedIndex())) != null) {
            this.sketch = s;
            this.updateSketch();
            this.updateComparisons(-1);
            this.hideSuggestions();
        }
        if ((b = (UIButton)this.getComponent("CancelSuggestion_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.hideSuggestions();
        }
        if ((b = (UIButton)this.getComponent("MoreSuggestion_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.suggestions.createSuggestions(this.sketch, this.sketchConstraints, 6);
            this.showSuggestions();
            this.updateComparisons(-1);
        }
        b = (UIButton)this.getComponent("ReturnToEdit_Button");
        if (!this.editMode && b != null && b.getState() == UIButton.State.PRESSED) {
            b.reset();
            this.switchMode();
            c.setImage(this.showMap(), false);
        }
        if (this.editMode && c.isMouseOver()) {
            int index = t.getSelectedIndex();
            if (t.getSelectedIndex() == 0) {
                this.sketch.setPassable((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                this.sketch.removeBase((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                this.sketch.removeResource((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
            } else if (t.getSelectedIndex() == 1) {
                if (!this.sketch.isBase((int)this.mouseOverTile.x, (int)this.mouseOverTile.y) && !this.sketch.isResource((int)this.mouseOverTile.x, (int)this.mouseOverTile.y) && this.sketch.isPassable((int)this.mouseOverTile.x, (int)this.mouseOverTile.y)) {
                    this.sketch.addResource((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                }
            } else if (t.getSelectedIndex() == 2) {
                if (!this.sketch.isBase((int)this.mouseOverTile.x, (int)this.mouseOverTile.y) && !this.sketch.isResource((int)this.mouseOverTile.x, (int)this.mouseOverTile.y) && this.sketch.isPassable((int)this.mouseOverTile.x, (int)this.mouseOverTile.y)) {
                    this.sketch.addBase((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                }
            } else if (t.getSelectedIndex() == 3) {
                if (!this.sketch.isBase((int)this.mouseOverTile.x, (int)this.mouseOverTile.y) && !this.sketch.isResource((int)this.mouseOverTile.x, (int)this.mouseOverTile.y)) {
                    this.sketch.setImpassable((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                }
            } else if (t.getSelectedIndex() == 4) {
                if (this.startTile == null) {
                    this.setStartTile((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                } else {
                    int sX = (int)Math.min(this.startTile.x, this.mouseOverTile.x);
                    int sY = (int)Math.min(this.startTile.y, this.mouseOverTile.y);
                    int eX = (int)Math.max(this.startTile.x, this.mouseOverTile.x);
                    int eY = (int)Math.max(this.startTile.y, this.mouseOverTile.y);
                    for (int x = sX; x <= eX; ++x) {
                        for (int y = sY; y <= eY; ++y) {
                            if (this.sketch.isBase(x, y) || this.sketch.isResource(x, y)) continue;
                            this.sketch.setImpassable(x, y);
                        }
                    }
                    this.resetStartTile();
                }
            } else if (t.getSelectedIndex() > 4) {
                if (t.getSelectedIndex() == 5) {
                    this.sketchConstraints.getTileConstraints().removeAllConstraintsAt((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                } else if (t.getSelectedIndex() == 6 || t.getSelectedIndex() == 7) {
                    if (this.startTile == null) {
                        this.setStartTile((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                    } else {
                        int sX = (int)Math.min(this.startTile.x, this.mouseOverTile.x);
                        int sY = (int)Math.min(this.startTile.y, this.mouseOverTile.y);
                        int eX = (int)Math.max(this.startTile.x, this.mouseOverTile.x);
                        int eY = (int)Math.max(this.startTile.y, this.mouseOverTile.y);
                        for (int x = sX; x <= eX; ++x) {
                            for (int y = sY; y <= eY; ++y) {
                                if (t.getSelectedIndex() == 6) {
                                    this.sketchConstraints.getTileConstraints().addConstraint(x, y, TileConstraints.Type.UNCHANGED);
                                    continue;
                                }
                                if (t.getSelectedIndex() != 7) continue;
                                this.sketchConstraints.getTileConstraints().addConstraint(x, y, TileConstraints.Type.RANDOMIZE);
                            }
                        }
                        this.resetStartTile();
                    }
                } else if (t.getSelectedIndex() == 8) {
                    this.sketchConstraints.getTileConstraints().addConstraint((int)this.mouseOverTile.x, (int)this.mouseOverTile.y, TileConstraints.Type.CHOKEPOINT);
                } else if (t.getSelectedIndex() == 9) {
                    this.sketchConstraints.getTileConstraints().addConstraint((int)this.mouseOverTile.x, (int)this.mouseOverTile.y, TileConstraints.Type.DEADEND);
                } else if (t.getSelectedIndex() == 10) {
                    this.sketchConstraints.getTileConstraints().addConstraint((int)this.mouseOverTile.x, (int)this.mouseOverTile.y, TileConstraints.Type.OPENAREA);
                } else if (t.getSelectedIndex() == 11) {
                    this.sketchConstraints.getTileConstraints().addConstraint((int)this.mouseOverTile.x, (int)this.mouseOverTile.y, TileConstraints.Type.UNUSEDSPACE);
                } else if (t.getSelectedIndex() == 12) {
                    this.sketchConstraints.getTileConstraints().addConstraint((int)this.mouseOverTile.x, (int)this.mouseOverTile.y, TileConstraints.Type.SAFESPACE);
                } else if (t.getSelectedIndex() == 13) {
                    this.sketchConstraints.getTileConstraints().addConstraint((int)this.mouseOverTile.x, (int)this.mouseOverTile.y, TileConstraints.Type.UNSAFESPACE);
                }
            }
            if (this.startTile == null) {
                this.updateSketch();
            }
        }
        c.setImage(this.showMap(), false);
        this.show("Generate_Button");
        this.hide("Generate_Label");
    }

    protected void updateSketch() {
        this.sketch.finalizeSketch();
        this.converter.reset(this.sketch);
        this.converter.generateMap();
        this.updateEvaluations();
        UIImage c = (UIImage)this.getComponent("Canvas");
        c.setImage(this.showMap(), false);
    }

    @Override
    public void mouseMoved() {
        UILabel l = (UILabel)this.getComponent("Paint_Label");
        UILabel l2 = (UILabel)this.getComponent("Paint_Label2");
        UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("Paint_Group");
        boolean isOver = false;
        for (int i = 0; i < t.size(); ++i) {
            if (!t.getButton(i).isMouseOver()) continue;
            isOver = true;
            String[] caption = this.findPaintLabel(i);
            l.setCaption(caption[0]);
            l2.setCaption(caption[1]);
        }
        if (!isOver) {
            String[] caption = this.findPaintLabel(t.getSelectedIndex());
            l.setCaption(caption[0]);
            l2.setCaption(caption[1]);
        }
        this.mouseOverTile = this.gridMouseOverToDiscrete();
    }

    protected Point2D gridContinuousToDiscrete(Point2D coords) {
        UIImage c = (UIImage)this.getComponent("Canvas");
        if (c == null || coords == null) {
            return null;
        }
        int gridX = (int)Math.round(coords.x * 8.0);
        int gridY = (int)Math.round(coords.y * 8.0);
        return new Point2D(gridX, gridY);
    }

    protected Point2D gridDiscreteToContinuous(Point2D coords) {
        UIImage c = (UIImage)this.getComponent("Canvas");
        if (c == null || coords == null) {
            return null;
        }
        double localX = Math.max(0.0, Math.min(1.0, coords.x / 8.0));
        double localY = Math.max(0.0, Math.min(1.0, coords.y / 8.0));
        return new Point2D(localX, localY);
    }

    protected Point2D gridMouseOverToDiscrete() {
        UIImage c = (UIImage)this.getComponent("Canvas");
        if (c == null || !c.isMouseOver()) {
            return null;
        }
        Point2D tlc = c.getTopLeftCorner();
        int gridX = (int)Math.floor(((double)this.p.mouseX - tlc.x) / 64.0);
        int gridY = (int)Math.floor(((double)this.p.mouseY - tlc.y) / 64.0);
        gridX = Math.min(7, gridX);
        gridY = Math.min(7, gridY);
        return new Point2D(gridX, gridY);
    }

    protected Point2D gridMouseOverToContinuous() {
        Point2D d = this.gridMouseOverToDiscrete();
        if (d == null) {
            return null;
        }
        return this.gridDiscreteToContinuous(d);
    }

    protected String[] findPaintLabel(int index) {
        String[] result = new String[]{"error"};
        if (index == 0) {
            result = new String[]{"Erase", ""};
        } else if (index == 1) {
            result = new String[]{"Resource", ""};
        } else if (index == 2) {
            result = new String[]{"Player base", ""};
        } else if (index == 3) {
            result = new String[]{"Impassable region", "(Line)"};
        } else if (index == 4) {
            result = new String[]{"Impassable region", "(Rectangle)"};
        } else if (index == 5) {
            result = new String[]{"Constraint:", "Clear"};
        } else if (index == 6) {
            result = new String[]{"Constraint:", "Unchanged tile"};
        } else if (index == 7) {
            result = new String[]{"Constraint:", "Randomize tile"};
        } else if (index == 8) {
            result = new String[]{"Constraint:", "Chokepoint"};
        } else if (index == 9) {
            result = new String[]{"Constraint:", "Deadend"};
        } else if (index == 10) {
            result = new String[]{"Constraint:", "Open Space"};
        } else if (index == 11) {
            result = new String[]{"Constraint:", "Unused Space"};
        } else if (index == 12) {
            result = new String[]{"Constraint:", "Safe Space"};
        } else if (index == 13) {
            result = new String[]{"Constraint:", "Unsafe Space"};
        }
        return result;
    }

    protected String findLogLocation() {
        String baseFile = "./logs/strategymap/draw/";
        int result = 0;
        File fp = null;
        while ((fp = new File("./logs/strategymap/draw/" + ++result)).exists()) {
        }
        return "./logs/strategymap/draw/" + result;
    }

    public void showSuggestions() {
        UIToggleButtonGroup sugGroup = (UIToggleButtonGroup)this.getComponent("Suggestions_Group");
        sugGroup.clear();
        for (int i = 0; i < Math.min(6, this.suggestions.size()); ++i) {
            sugGroup.addButtonImage(MapVisualizer.renderThumbnail(this.p, this.suggestions.getSuggestion(i), 80, 80).getGraphics(), true);
        }
        sugGroup.setSelectedIndex(-1);
        if (sugGroup.size() > 0) {
            this.show("ApplySuggestion_Button");
            this.show("MoreSuggestion_Button");
            this.show("CancelSuggestion_Button");
        } else {
            this.show("NoSuggestions_Label");
            this.hide("ApplySuggestion_Button");
            this.hide("MoreSuggestion_Button");
            this.hide("CancelSuggestion_Button");
        }
    }

    public void hideSuggestions() {
        UIToggleButtonGroup sugGroup = (UIToggleButtonGroup)this.getComponent("Suggestions_Group");
        sugGroup.clear();
        this.show("AskSuggestion_Button");
        this.hide("NoSuggestions_Label");
        this.hide("ApplySuggestion_Button");
        this.hide("MoreSuggestion_Button");
        this.hide("CancelSuggestion_Button");
    }
}

