/*
 * Decompiled with CFR 0.152.
 */
package strategysketch.screens.tabbed;

import java.io.File;
import processing.core.PImage;
import renderer.Render2D;
import strategymap.StrategySketch;
import strategymap.constraints.StrategyConstraints;
import strategymap.genetic.StrategySketchSuggestions;
import strategymap.genetic.fitness.FeasibleFitness;
import strategymap.visualization.MapVisualizer;
import strategysketch.screens.tabbed.Tab_DetailedView;
import strategysketch.screens.tabbed.Tab_Editor;
import strategysketch.screens.tabbed.Tab_Suggestions;
import ui.BaseApplet;
import ui.components.UIToggleButtonGroup;
import ui.screens.Screen;
import ui.screens.TabbedScreen;
import util.statics.LogManager;

public class Screen_TabContainer
extends TabbedScreen {
    StrategySketch sketch;
    StrategyConstraints sketchConstraints;
    StrategySketchSuggestions suggestions;
    public final int mapSizeX = 8;
    public final int mapSizeY = 8;
    public final int evaluationSize = 6;
    double[] evaluationScores;
    static String filePath;

    public Screen_TabContainer(BaseApplet p) {
        super(p);
        this.resetSketch();
        filePath = this.findLogLocation();
        this.suggestions = new StrategySketchSuggestions();
        this.suggestions.initParameters(8, 8, 4, 10, 2, 2);
        this.tabs.add(new Tab_Editor(p, this));
        this.tabs.add(new Tab_Suggestions(p, this));
        this.tabs.add(new Tab_DetailedView(p, this));
        this.setCurrentTab(0);
    }

    public PImage showMap(String label, int gridSizeX, int gridSizeY) {
        Render2D renderer = null;
        if (label.equalsIgnoreCase("suggestions_simple")) {
            renderer = MapVisualizer.renderThumbnail(this.p, this.sketch, 8 * gridSizeX, 8 * gridSizeY);
            renderer = MapVisualizer.renderTileConstraints(renderer, this.sketchConstraints);
        } else if (label.equalsIgnoreCase("editor_simple")) {
            renderer = MapVisualizer.renderThumbnail(this.p, this.sketch, 8 * gridSizeX, 8 * gridSizeY);
        } else if (label.equalsIgnoreCase("editor_navmesh")) {
            renderer = MapVisualizer.renderNavmeshThumbnail(this.p, this.sketch, 8 * gridSizeX, 8 * gridSizeY);
        } else if (label.equalsIgnoreCase("editor_allpaths")) {
            renderer = MapVisualizer.renderPathsThumbnail(this.p, this.sketch, 8 * gridSizeX, 8 * gridSizeY);
        } else if (label.equalsIgnoreCase("editor_chokepoints")) {
            renderer = MapVisualizer.renderChokePointThumbnail(this.p, this.sketch, 8 * gridSizeX, 8 * gridSizeY);
        } else if (label.equalsIgnoreCase("editor_resourcesafety")) {
            renderer = MapVisualizer.renderNearbyResourcesThumbnail(this.p, this.sketch, 8 * gridSizeX, 8 * gridSizeY);
        } else if (label.equalsIgnoreCase("editor_basesafety")) {
            renderer = MapVisualizer.renderSafetyMatrix(this.p, this.sketch, 8 * gridSizeX, 8 * gridSizeY);
        } else if (label.equalsIgnoreCase("editor_unusedspace")) {
            renderer = MapVisualizer.renderUnusedSpaceThumbnail(this.p, this.sketch, 8 * gridSizeX, 8 * gridSizeY);
        } else if (label.equalsIgnoreCase("editor_segments")) {
            renderer = MapVisualizer.renderSegmentsThumbnail(this.p, this.sketch, 8 * gridSizeX, 8 * gridSizeY);
        } else if (label.equalsIgnoreCase("editor_safesegments")) {
            renderer = MapVisualizer.renderSafeSegmentsThumbnail(this.p, this.sketch, 8 * gridSizeX, 8 * gridSizeY);
        } else if (label.equalsIgnoreCase("editor_exploration")) {
            renderer = MapVisualizer.renderExplorationThumbnail(this.p, this.sketch, 8 * gridSizeX, 8 * gridSizeY);
        } else {
            LogManager.writeError("Error", this, "label for map visualization not found");
        }
        return renderer.getImage();
    }

    public void resetConstraints() {
        this.sketchConstraints = new StrategyConstraints(8, 8);
    }

    public void resetSketch() {
        this.sketch = new StrategySketch(8, 8);
        this.sketchConstraints = new StrategyConstraints(8, 8);
    }

    public void updateSketch() {
        this.sketch.finalizeSketch();
        this.updateEvaluations();
    }

    public void randomizeSketch() {
        this.sketch.randomizeChunks(10);
        this.sketch.randomize(4, 6);
    }

    public void updateEvaluations() {
        this.evaluationScores = new double[6];
        for (int i = 0; i < this.evaluationScores.length; ++i) {
            FeasibleFitness fn = new FeasibleFitness(i);
            this.evaluationScores[i] = fn.evaluate(this.sketch);
        }
    }

    public void initializeTabs(Screen tab_screen) {
        UIToggleButtonGroup t = null;
        t = new UIToggleButtonGroup(this.p, this.p.width / 6, 15, this.p.width / 3, 30);
        t.setAllowUnselected(false);
        t.setOffset(0);
        t.addButton("Editor Tab");
        t.addButton("Suggestions Tab");
        t.addButton("Export Tab");
        for (int i = 0; i < t.size(); ++i) {
            t.getButton(i).setFont("Large", false);
            t.getButton(i).setHeight(30);
        }
        t.setSelectedIndex(0);
        tab_screen.addComponent("tabs_group", t);
    }

    @Override
    public void mouseClicked() {
        super.mouseClicked();
        UIToggleButtonGroup t = (UIToggleButtonGroup)((Screen)this.tabs.get(this.currentTab)).getComponent("tabs_group");
        if (t.getSelectedIndex() != this.currentTab) {
            this.setCurrentTab(t.getSelectedIndex());
            t.update();
            UIToggleButtonGroup curr_t = (UIToggleButtonGroup)((Screen)this.tabs.get(this.currentTab)).getComponent("tabs_group");
            curr_t.setSelectedIndex(this.currentTab);
            ((Screen)this.tabs.get(this.currentTab)).update();
        }
    }

    protected String findLogLocation() {
        String baseFile = "./logs/strategymap/draw/";
        int result = 0;
        File fp = null;
        while ((fp = new File("./logs/strategymap/draw/" + ++result)).exists()) {
        }
        return "./logs/strategymap/draw/" + result;
    }
}

