/*
 * Decompiled with CFR 0.152.
 */
package strategysketch.screens.tabbed;

import java.util.HashMap;
import java.util.Vector;
import processing.core.PImage;
import renderer.Render2D;
import strategymap.DetailConverter;
import strategymap.StrategySketch;
import strategymap.visualization.MapVisualizer;
import strategysketch.screens.tabbed.Screen_TabContainer;
import ui.BaseApplet;
import ui.components.UIButton;
import ui.components.UIImage;
import ui.components.UILabel;
import ui.components.UIToggleButtonGroup;
import ui.screens.Screen;

public class Tab_DetailedView
extends Screen {
    Screen_TabContainer parent;
    final int imgSizeX = 512;
    final int imgSizeY = 512;
    public final int cellularSizeX = 10;
    public final int cellularSizeY = 10;
    int gridSizeX;
    int gridSizeY;
    HashMap<String, DetailConverter> converters;
    Vector<PImage> detailedViews;

    public Tab_DetailedView(BaseApplet p, Screen_TabContainer parent) {
        super(p);
        this.parent = parent;
        this.converters = new HashMap();
        this.converters.put("classic", new DetailConverter(parent.sketch, 10, 10));
        this.converters.put("waterworks", new DetailConverter(this.createWaterWorksSketch(), 10, 10));
        this.remakeDetailedViews();
        this.initialize();
    }

    protected StrategySketch createWaterWorksSketch() {
        int i;
        StrategySketch wwSketch = new StrategySketch(this.parent.sketch.getMapSizeX(), this.parent.sketch.getMapSizeY());
        for (i = 0; i < this.parent.sketch.getBaseLength(); ++i) {
            wwSketch.addBase((int)this.parent.sketch.getBase((int)i).x, (int)this.parent.sketch.getBase((int)i).y);
        }
        for (i = 0; i < this.parent.sketch.getResourceLength(); ++i) {
            wwSketch.addResource((int)this.parent.sketch.getResource((int)i).x, (int)this.parent.sketch.getResource((int)i).y);
        }
        boolean[][] impassable = this.parent.sketch.getImpassableArray();
        boolean[][] chokePoints = this.parent.sketch.getPaths().getChokePoints();
        boolean[][] deadEnds = this.parent.sketch.getPaths().getDeadEnds();
        for (int x = 0; x < this.parent.sketch.getMapSizeX(); ++x) {
            for (int y = 0; y < this.parent.sketch.getMapSizeY(); ++y) {
                if (impassable[x][y]) {
                    wwSketch.setImpassable(x, y);
                }
                if (!chokePoints[x][y] || this.parent.sketch.isBase(x, y) || this.parent.sketch.isResource(x, y) || deadEnds[x][y]) continue;
                wwSketch.setImpassable(x, y);
            }
        }
        return wwSketch;
    }

    protected void initialize() {
        this.parent.initializeTabs(this);
        this.parent.getClass();
        this.gridSizeX = 512 / 8;
        this.parent.getClass();
        this.gridSizeY = 512 / 8;
        UIImage img = new UIImage(this.p, this.detailedViews.get(0), 0, 0);
        img.setPosition(img.getWidth() / 2 + 10, img.getHeight() / 2 + 90);
        this.addComponent("Canvas", img);
        int offset = 40;
        this.addComponent("Title", new UILabel(this.p, "Strategy Game Map Detailed View", this.p.width / 2, offset + 20, "Huge"));
        this.addComponent("ViewMode_Label", new UILabel(this.p, "Viewing Modes", img.getPositionX() + img.getWidth() / 2 + 57, offset + 205, "Large"));
        UIToggleButtonGroup t = new UIToggleButtonGroup(this.p, img.getPositionX() + img.getWidth() / 2 + 50, offset + 225, 90, 20);
        t.setAllowUnselected(false);
        t.addButton("Simple");
        t.addButtonNextLine("Heightmap");
        t.addButtonNextLine("Waterworks");
        t.addButtonNextLine("Dungeon");
        t.setSelectedIndex(0);
        this.addComponent("ViewingMode_Group", t);
        this.addComponent("Reset_Button", new UIButton(this.p, "Regenerate", img.getPositionX() - img.getWidth() / 2 + 50, img.getPositionY() + img.getHeight() / 2 + 40, "Large"));
    }

    @Override
    public void mouseClicked() {
        super.mouseClicked();
        UIButton b = null;
        b = (UIButton)this.getComponent("Reset_Button");
        if (b != null && b.getState() == UIButton.State.PRESSED) {
            this.remakeDetailedViews();
            this.showMap();
        }
        this.showMap();
    }

    @Override
    public void update() {
        this.remakeDetailedViews();
        this.showMap();
    }

    public void remakeDetailedViews() {
        this.detailedViews = new Vector();
        this.converters.get("classic").reset(this.parent.sketch);
        this.converters.get("classic").generateMap();
        Render2D renderer = MapVisualizer.renderThumbnail(this.p, this.converters.get("classic").getMap(), 512, 512);
        this.detailedViews.add(renderer.getImage());
        renderer = MapVisualizer.renderHeightmap(this.p, this.converters.get("classic"), 512, 512);
        this.detailedViews.add(renderer.getImage());
        this.converters.get("waterworks").reset(this.createWaterWorksSketch());
        this.converters.get("waterworks").generateMap();
        renderer = MapVisualizer.renderWaterworks(this.p, this.parent.sketch, this.converters.get("waterworks"), 512, 512);
        this.detailedViews.add(renderer.getImage());
        renderer = MapVisualizer.renderDungeon(this.p, this.parent.sketch, 512, 512);
        this.detailedViews.add(renderer.getImage());
    }

    protected void showMap() {
        UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("ViewingMode_Group");
        PImage mapImage = this.detailedViews.get(t.getSelectedIndex());
        UIImage c = (UIImage)this.getComponent("Canvas");
        c.setImage(mapImage, true);
    }
}

