/*
 * Decompiled with CFR 0.152.
 */
package strategysketch.screens.tabbed;

import processing.core.PImage;
import strategymap.StrategySketch;
import strategysketch.screens.components.StatsPanel_Editor;
import strategysketch.screens.tabbed.Screen_TabContainer;
import ui.BaseApplet;
import ui.components.UIButton;
import ui.components.UIImage;
import ui.components.UILabel;
import ui.components.UIToggleButtonGroup;
import ui.components.UIToggleButtonImage;
import ui.screens.Screen;
import util.math2d.Point2D;

public class Tab_Editor
extends Screen {
    Screen_TabContainer parent;
    Point2D mouseOverTile;
    Point2D startTile;
    final int imgSizeX = 512;
    final int imgSizeY = 512;
    int gridSizeX;
    int gridSizeY;

    public Tab_Editor(BaseApplet p, Screen_TabContainer parent) {
        super(p);
        this.parent = parent;
        this.initialize();
    }

    protected void initialize() {
        this.resetStartTile();
        this.parent.initializeTabs(this);
        this.parent.getClass();
        this.gridSizeX = 512 / 8;
        this.parent.getClass();
        this.gridSizeY = 512 / 8;
        UIImage img = new UIImage(this.p, this.parent.showMap("editor_simple", this.gridSizeX, this.gridSizeY), 0, 0);
        img.setPosition(img.getWidth() / 2 + 10, img.getHeight() / 2 + 90);
        this.addComponent("Canvas", img);
        int offset = 40;
        this.addComponent("Title", new UILabel(this.p, "Strategy Game Map Sketching", this.p.width / 2, offset + 20, "Huge"));
        this.addComponent("Randomize_Button", new UIButton(this.p, "Randomize", img.getPositionX() + img.getWidth() / 2 + 45, offset + 150, 80, 18, "Large"));
        this.addComponent("Reset_Button", new UIButton(this.p, "Clear Map", img.getPositionX() + img.getWidth() / 2 + 128, offset + 150, 75, 18, "Large"));
        UIToggleButtonGroup t = null;
        this.addComponent("ViewMode_Label", new UILabel(this.p, "Viewing Modes", img.getPositionX() + img.getWidth() / 2 + 57, offset + 205, "Large"));
        t = new UIToggleButtonGroup(this.p, img.getPositionX() + img.getWidth() / 2 + 50, offset + 225, 90, 20);
        t.setAllowUnselected(false);
        t.addButtonNextLine("Simple");
        t.addButton("Navmesh");
        t.addButtonNextLine("Resource Safety");
        t.addButton("Base Safety");
        t.addButtonNextLine("Unused Space");
        t.addButton("Segments");
        t.setSelectedIndex(0);
        this.addComponent("ViewingMode_Group", t);
        t = new UIToggleButtonGroup(this.p, img.getPositionX() + img.getWidth() / 2 + 25, offset + 75, 20, 20);
        t.setAllowUnselected(false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/passable.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/passable_rect.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/mineral.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/base.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/impassable.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/impassable_rect.png", false);
        t.setSelectedIndex(0);
        for (int i = 0; i < t.size(); ++i) {
            ((UIToggleButtonImage)t.getButton(i)).setUseFrame(true);
        }
        this.addComponent("Paint_Group", t);
        String[] caption = this.findPaintLabel(t.getSelectedIndex());
        this.addComponent("Paint_Label", new UILabel(this.p, caption[0], img.getPositionX() + img.getWidth() / 2 + 75, offset + 100, "Large"));
        this.addComponent("Paint_Label2", new UILabel(this.p, caption[1], img.getPositionX() + img.getWidth() / 2 + 75, offset + 120, "Large"));
        this.addComponent("StatsPanel", new StatsPanel_Editor(this.p, img.getPositionX() + img.getWidth() / 2 + 25, offset + 320));
        this.updateSketch();
    }

    protected void resetStartTile() {
        this.startTile = null;
    }

    protected void setStartTile(int gridX, int gridY) {
        this.startTile = new Point2D(gridX, gridY);
    }

    @Override
    public void update() {
        super.update();
        StatsPanel_Editor sp = (StatsPanel_Editor)this.getComponent("StatsPanel");
        sp.updateEvaluations(this.parent.sketch, this.parent.evaluationScores);
        UIImage c = (UIImage)this.getComponent("Canvas");
        this.showMap();
    }

    @Override
    public void mouseClicked() {
        super.mouseClicked();
        UIButton b = null;
        b = (UIButton)this.getComponent("Reset_Button");
        if (b != null && b.getState() == UIButton.State.PRESSED) {
            this.parent.resetSketch();
            this.updateSketch();
            this.showMap();
        }
        if ((b = (UIButton)this.getComponent("Randomize_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.parent.randomizeSketch();
            this.updateSketch();
            this.showMap();
        }
        UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("Paint_Group");
        UIImage c = (UIImage)this.getComponent("Canvas");
        if (c != null) {
            int index = t.getSelectedIndex();
            if (index != 1 && index != 5) {
                this.startTile = null;
            }
            if (c.isMouseOver()) {
                StrategySketch prevSketch = new StrategySketch(this.parent.sketch);
                if (index == 0) {
                    this.parent.sketch.setPassable((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                    this.parent.sketch.removeBase((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                    this.parent.sketch.removeResource((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                } else if (index == 1) {
                    if (this.startTile == null) {
                        this.setStartTile((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                    } else {
                        int sX = (int)Math.min(this.startTile.x, this.mouseOverTile.x);
                        int sY = (int)Math.min(this.startTile.y, this.mouseOverTile.y);
                        int eX = (int)Math.max(this.startTile.x, this.mouseOverTile.x);
                        int eY = (int)Math.max(this.startTile.y, this.mouseOverTile.y);
                        for (int x = sX; x <= eX; ++x) {
                            for (int y = sY; y <= eY; ++y) {
                                this.parent.sketch.setPassable(x, y);
                                this.parent.sketch.removeBase(x, y);
                                this.parent.sketch.removeResource(x, y);
                            }
                        }
                        this.resetStartTile();
                    }
                } else if (index == 2) {
                    if (!this.parent.sketch.isBase((int)this.mouseOverTile.x, (int)this.mouseOverTile.y) && !this.parent.sketch.isResource((int)this.mouseOverTile.x, (int)this.mouseOverTile.y) && this.parent.sketch.isPassable((int)this.mouseOverTile.x, (int)this.mouseOverTile.y)) {
                        this.parent.sketch.addResource((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                    }
                } else if (index == 3) {
                    if (!this.parent.sketch.isBase((int)this.mouseOverTile.x, (int)this.mouseOverTile.y) && !this.parent.sketch.isResource((int)this.mouseOverTile.x, (int)this.mouseOverTile.y) && this.parent.sketch.isPassable((int)this.mouseOverTile.x, (int)this.mouseOverTile.y)) {
                        this.parent.sketch.addBase((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                    }
                } else if (index == 4) {
                    if (!this.parent.sketch.isBase((int)this.mouseOverTile.x, (int)this.mouseOverTile.y) && !this.parent.sketch.isResource((int)this.mouseOverTile.x, (int)this.mouseOverTile.y)) {
                        this.parent.sketch.setImpassable((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                    }
                } else if (index == 5) {
                    if (this.startTile == null) {
                        this.setStartTile((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                    } else {
                        int sX = (int)Math.min(this.startTile.x, this.mouseOverTile.x);
                        int sY = (int)Math.min(this.startTile.y, this.mouseOverTile.y);
                        int eX = (int)Math.max(this.startTile.x, this.mouseOverTile.x);
                        int eY = (int)Math.max(this.startTile.y, this.mouseOverTile.y);
                        for (int x = sX; x <= eX; ++x) {
                            for (int y = sY; y <= eY; ++y) {
                                if (this.parent.sketch.isBase(x, y) || this.parent.sketch.isResource(x, y)) continue;
                                this.parent.sketch.setImpassable(x, y);
                            }
                        }
                        this.resetStartTile();
                    }
                }
                if (this.startTile == null && this.parent.sketch.getTileDifference(prevSketch) > 0) {
                    this.updateSketch();
                }
            }
        }
        this.showMap();
    }

    protected void showMap() {
        UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("ViewingMode_Group");
        PImage mapImage = this.parent.showMap("editor_" + t.getSelectedCaption().replace(" ", ""), this.gridSizeX, this.gridSizeY);
        UIImage c = (UIImage)this.getComponent("Canvas");
        c.setImage(mapImage, true);
    }

    protected void updateSketch() {
        this.parent.updateSketch();
        this.update();
    }

    @Override
    public void mouseMoved() {
        UILabel label1 = (UILabel)this.getComponent("Paint_Label");
        UILabel label2 = (UILabel)this.getComponent("Paint_Label2");
        UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("Paint_Group");
        boolean isOver = false;
        for (int i = 0; i < t.size(); ++i) {
            if (!t.getButton(i).isMouseOver()) continue;
            isOver = true;
            String[] caption = this.findPaintLabel(i);
            label1.setCaption(caption[0]);
            label2.setCaption(caption[1]);
        }
        if (!isOver) {
            String[] caption = this.findPaintLabel(t.getSelectedIndex());
            label1.setCaption(caption[0]);
            label2.setCaption(caption[1]);
        }
        this.mouseOverTile = this.gridMouseOverToDiscrete();
    }

    @Override
    public void draw() {
        Point2D tlc;
        UIImage c;
        super.draw();
        UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("Paint_Group");
        int index = t.getSelectedIndex();
        if (this.startTile != null) {
            c = (UIImage)this.getComponent("Canvas");
            tlc = c.getTopLeftCorner();
            this.p.stroke(40);
            this.p.strokeWeight(2.0f);
            this.p.noFill();
            if (this.mouseOverTile != null) {
                double sX = Math.min(this.startTile.x, this.mouseOverTile.x);
                double sY = Math.min(this.startTile.y, this.mouseOverTile.y);
                double eX = Math.max(this.startTile.x, this.mouseOverTile.x);
                double eY = Math.max(this.startTile.y, this.mouseOverTile.y);
                this.p.rect((float)(tlc.x + sX * (double)this.gridSizeX), (float)(tlc.y + sY * (double)this.gridSizeY), (float)((eX - sX + 1.0) * (double)this.gridSizeX), (float)((eY - sY + 1.0) * (double)this.gridSizeY));
            } else {
                this.p.rect((float)(tlc.x + this.startTile.x * (double)this.gridSizeX), (float)(tlc.y + this.startTile.y * (double)this.gridSizeY), this.gridSizeX, this.gridSizeY);
            }
            this.p.strokeWeight(1.0f);
            this.p.noStroke();
        }
        if (this.mouseOverTile != null) {
            c = (UIImage)this.getComponent("Canvas");
            tlc = c.getTopLeftCorner();
            this.p.stroke(0.0f, 255.0f, 0.0f);
            this.p.strokeWeight(2.0f);
            this.p.noFill();
            this.p.rect((float)(tlc.x + this.mouseOverTile.x * (double)this.gridSizeX), (float)(tlc.y + this.mouseOverTile.y * (double)this.gridSizeY), this.gridSizeX, this.gridSizeY);
            this.p.strokeWeight(1.0f);
            this.p.noStroke();
        }
    }

    protected Point2D gridContinuousToDiscrete(Point2D coords) {
        UIImage c = (UIImage)this.getComponent("Canvas");
        if (c == null || coords == null) {
            return null;
        }
        double d = coords.x;
        this.parent.getClass();
        int gridX = (int)Math.round(d * 8.0);
        double d2 = coords.y;
        this.parent.getClass();
        int gridY = (int)Math.round(d2 * 8.0);
        return new Point2D(gridX, gridY);
    }

    protected Point2D gridDiscreteToContinuous(Point2D coords) {
        UIImage c = (UIImage)this.getComponent("Canvas");
        if (c == null || coords == null) {
            return null;
        }
        double d = coords.x;
        this.parent.getClass();
        double localX = Math.max(0.0, Math.min(1.0, d / 8.0));
        double d2 = coords.y;
        this.parent.getClass();
        double localY = Math.max(0.0, Math.min(1.0, d2 / 8.0));
        return new Point2D(localX, localY);
    }

    protected Point2D gridMouseOverToDiscrete() {
        UIImage c = (UIImage)this.getComponent("Canvas");
        if (c == null || !c.isMouseOver()) {
            return null;
        }
        Point2D tlc = c.getTopLeftCorner();
        int gridX = (int)Math.floor(((double)this.p.mouseX - tlc.x) / (double)this.gridSizeX);
        int gridY = (int)Math.floor(((double)this.p.mouseY - tlc.y) / (double)this.gridSizeY);
        this.parent.getClass();
        gridX = Math.min(8 - 1, gridX);
        this.parent.getClass();
        gridY = Math.min(8 - 1, gridY);
        return new Point2D(gridX, gridY);
    }

    protected Point2D gridMouseOverToContinuous() {
        Point2D d = this.gridMouseOverToDiscrete();
        if (d == null) {
            return null;
        }
        return this.gridDiscreteToContinuous(d);
    }

    protected String[] findPaintLabel(int index) {
        String[] result = new String[]{"error"};
        if (index == 0) {
            result = new String[]{"Erase", ""};
        } else if (index == 1) {
            result = new String[]{"Erase", "(Rectangle)"};
        } else if (index == 2) {
            result = new String[]{"Resource", ""};
        } else if (index == 3) {
            result = new String[]{"Player base", ""};
        } else if (index == 4) {
            result = new String[]{"Impassable region", ""};
        } else if (index == 5) {
            result = new String[]{"Impassable region", "(Rectangle)"};
        } else if (index == 6) {
            result = new String[]{"Constraint:", "Clear"};
        } else if (index == 7) {
            result = new String[]{"Constraint:", "Unchanged tile"};
        } else if (index == 8) {
            result = new String[]{"Constraint:", "Randomize tile"};
        } else if (index == 9) {
            result = new String[]{"Constraint:", "Chokepoint"};
        } else if (index == 10) {
            result = new String[]{"Constraint:", "Deadend"};
        } else if (index == 11) {
            result = new String[]{"Constraint:", "Open Space"};
        } else if (index == 12) {
            result = new String[]{"Constraint:", "Unused Space"};
        } else if (index == 13) {
            result = new String[]{"Constraint:", "Safe Space"};
        } else if (index == 14) {
            result = new String[]{"Constraint:", "Unsafe Space"};
        }
        return result;
    }
}

