/*
 * Decompiled with CFR 0.152.
 */
package strategysketch.screens.tabbed;

import processing.core.PImage;
import strategymap.StrategySketch;
import strategymap.constraints.TileConstraints;
import strategymap.visualization.MapVisualizer;
import strategysketch.screens.components.StatsPanel;
import strategysketch.screens.tabbed.Screen_TabContainer;
import ui.BaseApplet;
import ui.components.UIButton;
import ui.components.UIImage;
import ui.components.UILabel;
import ui.components.UIToggleButtonGroup;
import ui.components.UIToggleButtonImage;
import ui.screens.Screen;
import util.math2d.Point2D;

public class Tab_Suggestions
extends Screen {
    Screen_TabContainer parent;
    Point2D mouseOverTile;
    Point2D startTile;
    final int imgSizeX = 256;
    final int imgSizeY = 256;
    final int thumbSizeX = 128;
    final int thumbSizeY = 128;
    final int suggestionsNumber = 6;
    int gridSizeX;
    int gridSizeY;

    public Tab_Suggestions(BaseApplet p, Screen_TabContainer parent) {
        super(p);
        this.parent = parent;
        this.initialize();
    }

    protected void initialize() {
        this.resetStartTile();
        this.parent.initializeTabs(this);
        this.parent.getClass();
        this.gridSizeX = 256 / 8;
        this.parent.getClass();
        this.gridSizeY = 256 / 8;
        UIImage img = new UIImage(this.p, this.parent.showMap("editor_simple", this.gridSizeX, this.gridSizeY), 0, 0);
        img.setPosition(img.getWidth() / 2 + 10, img.getHeight() / 2 + 90);
        this.addComponent("Suggestions_Canvas", img);
        int offset = 40;
        this.addComponent("Title", new UILabel(this.p, "Strategy Game Map Suggestions", this.p.width / 2, offset + 20, "Huge"));
        this.addComponent("Reset_Button", new UIButton(this.p, "Clear Constraints", img.getPositionX() + img.getWidth() / 2 + 68, offset + 175, 120, 18, "Large"));
        UIToggleButtonGroup t = null;
        t = new UIToggleButtonGroup(this.p, img.getPositionX() + img.getWidth() / 2 + 25, offset + 75, 20, 20);
        t.setAllowUnselected(false);
        t.addButtonImageNextLine("resources/tilesets/simple/Paint_Group/passable.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/constraint_freeze.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/constraint_randomize.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/constraint_nearbyResource.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/constraint_unsafeResource.png", false);
        t.addButtonImageNextLine("resources/tilesets/simple/Paint_Group/constraint_chokepoint.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/constraint_deadend.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/constraint_openspace.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/constraint_unusedspace.png", false);
        t.setSelectedIndex(0);
        for (int i = 0; i < t.size(); ++i) {
            ((UIToggleButtonImage)t.getButton(i)).setUseFrame(true);
        }
        this.addComponent("Paint_Group", t);
        String[] caption = this.findPaintLabel(t.getSelectedIndex());
        this.addComponent("Paint_Label", new UILabel(this.p, caption[0], img.getPositionX() + img.getWidth() / 2 + 75, offset + 130, "Large"));
        this.addComponent("Paint_Label2", new UILabel(this.p, caption[1], img.getPositionX() + img.getWidth() / 2 + 75, offset + 150, "Large"));
        this.addComponent("StatsPanel", new StatsPanel(this.p, img.getPositionX() + img.getWidth() / 2 + 195, offset + 70));
        this.addComponent("AskSuggestion_Button", new UIButton(this.p, "Ask for Suggestion", img.getPositionX() - img.getWidth() / 2 + 60, img.getPositionY() + img.getHeight() / 2 + 20, 130, "Large"));
        this.addComponent("MoreSuggestion_Button", new UIButton(this.p, "More Suggestions", img.getPositionX() - img.getWidth() / 2 + 60, img.getPositionY() + img.getHeight() / 2 + 20, 130, "Large"));
        this.hide("MoreSuggestion_Button");
        this.addComponent("CancelSuggestion_Button", new UIButton(this.p, "Cancel Suggestions", img.getPositionX() - img.getWidth() / 2 + 201, img.getPositionY() + img.getHeight() / 2 + 20, "Large"));
        this.hide("CancelSuggestion_Button");
        this.addComponent("ApplySuggestion_Button", new UIButton(this.p, "Apply Suggestion", img.getPositionX() - img.getWidth() / 2 + 340, img.getPositionY() + img.getHeight() / 2 + 20, 130, "Large"));
        this.hide("ApplySuggestion_Button");
        this.addComponent("NoSuggestions_Label", new UILabel(this.p, "No Suggestions Found", 180, this.p.height - 74, 120, "Huge"));
        this.hide("NoSuggestions_Label");
        t = new UIToggleButtonGroup(this.p, 74, img.getPositionX() - img.getWidth() / 2 + 380 + 64, 128, 128);
        this.addComponent("Suggestions_Group", t);
        this.updateSketch();
    }

    protected void resetStartTile() {
        this.startTile = null;
    }

    protected void setStartTile(int gridX, int gridY) {
        this.startTile = new Point2D(gridX, gridY);
    }

    @Override
    public void update() {
        super.update();
        StatsPanel sp = (StatsPanel)this.getComponent("StatsPanel");
        sp.updateEvaluations(this.parent.sketch, this.parent.evaluationScores);
        UIImage c = (UIImage)this.getComponent("Suggestions_Canvas");
        this.showMap();
    }

    @Override
    public void mouseClicked() {
        StrategySketch s;
        UIToggleButtonGroup sugGroup;
        UIImage c;
        super.mouseClicked();
        UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("Paint_Group");
        UIButton b = null;
        b = (UIButton)this.getComponent("Reset_Button");
        if (b != null && b.getState() == UIButton.State.PRESSED) {
            this.parent.resetConstraints();
            this.updateSketch();
            this.showMap();
        }
        if ((c = (UIImage)this.getComponent("Suggestions_Canvas")) != null && c.isMouseOver()) {
            int index = t.getSelectedIndex();
            if (t.getSelectedIndex() == 0) {
                this.parent.sketchConstraints.getTileConstraints().removeAllConstraintsAt((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
            } else if (t.getSelectedIndex() == 1 || t.getSelectedIndex() == 2) {
                if (this.startTile == null) {
                    this.setStartTile((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                } else {
                    int sX = (int)Math.min(this.startTile.x, this.mouseOverTile.x);
                    int sY = (int)Math.min(this.startTile.y, this.mouseOverTile.y);
                    int eX = (int)Math.max(this.startTile.x, this.mouseOverTile.x);
                    int eY = (int)Math.max(this.startTile.y, this.mouseOverTile.y);
                    for (int x = sX; x <= eX; ++x) {
                        for (int y = sY; y <= eY; ++y) {
                            if (t.getSelectedIndex() == 1) {
                                this.parent.sketchConstraints.getTileConstraints().addConstraint(x, y, TileConstraints.Type.UNCHANGED);
                                continue;
                            }
                            if (t.getSelectedIndex() != 2) continue;
                            this.parent.sketchConstraints.getTileConstraints().addConstraint(x, y, TileConstraints.Type.RANDOMIZE);
                        }
                    }
                    this.resetStartTile();
                }
            } else if (t.getSelectedIndex() == 5) {
                this.parent.sketchConstraints.getTileConstraints().addConstraint((int)this.mouseOverTile.x, (int)this.mouseOverTile.y, TileConstraints.Type.CHOKEPOINT);
            } else if (t.getSelectedIndex() == 6) {
                this.parent.sketchConstraints.getTileConstraints().addConstraint((int)this.mouseOverTile.x, (int)this.mouseOverTile.y, TileConstraints.Type.DEADEND);
            } else if (t.getSelectedIndex() == 7) {
                this.parent.sketchConstraints.getTileConstraints().addConstraint((int)this.mouseOverTile.x, (int)this.mouseOverTile.y, TileConstraints.Type.OPENAREA);
            } else if (t.getSelectedIndex() == 8) {
                this.parent.sketchConstraints.getTileConstraints().addConstraint((int)this.mouseOverTile.x, (int)this.mouseOverTile.y, TileConstraints.Type.UNUSEDSPACE);
            } else if (t.getSelectedIndex() == 3) {
                this.parent.sketchConstraints.getTileConstraints().addConstraint((int)this.mouseOverTile.x, (int)this.mouseOverTile.y, TileConstraints.Type.SAFESPACE);
            } else if (t.getSelectedIndex() == 4) {
                this.parent.sketchConstraints.getTileConstraints().addConstraint((int)this.mouseOverTile.x, (int)this.mouseOverTile.y, TileConstraints.Type.UNSAFESPACE);
            }
            if (this.startTile == null) {
                this.updateSketch();
            }
        }
        if ((b = (UIButton)this.getComponent("AskSuggestion_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.parent.suggestions.createSuggestions(this.parent.sketch, this.parent.sketchConstraints, 6);
            this.showSuggestions();
            this.updateComparisons(-1);
        }
        if ((sugGroup = (UIToggleButtonGroup)this.getComponent("Suggestions_Group")) != null && sugGroup.isMouseOver()) {
            this.updateComparisons(sugGroup.getSelectedIndex());
        }
        if ((b = (UIButton)this.getComponent("ApplySuggestion_Button")) != null && b.getState() == UIButton.State.PRESSED && sugGroup.getSelectedIndex() != -1 && (s = this.parent.suggestions.getSuggestion(sugGroup.getSelectedIndex())) != null) {
            this.parent.sketch = s;
            this.updateSketch();
            this.updateComparisons(-1);
            this.hideSuggestions();
        }
        if ((b = (UIButton)this.getComponent("CancelSuggestion_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.hideSuggestions();
        }
        if ((b = (UIButton)this.getComponent("MoreSuggestion_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.parent.suggestions.createSuggestions(this.parent.sketch, this.parent.sketchConstraints, 6);
            this.showSuggestions();
            this.updateComparisons(-1);
        }
        this.showMap();
    }

    public void showSuggestions() {
        UIToggleButtonGroup sugGroup = (UIToggleButtonGroup)this.getComponent("Suggestions_Group");
        sugGroup.clear();
        int thumbNumber = Math.min(6, this.parent.suggestions.size());
        for (int i = 0; i < thumbNumber; ++i) {
            if (i % thumbNumber == thumbNumber / 2) {
                sugGroup.addButtonImageNextLine(MapVisualizer.renderThumbnail(this.p, this.parent.suggestions.getSuggestion(i), 128, 128).getGraphics(), true);
                continue;
            }
            sugGroup.addButtonImage(MapVisualizer.renderThumbnail(this.p, this.parent.suggestions.getSuggestion(i), 128, 128).getGraphics(), true);
        }
        sugGroup.setSelectedIndex(-1);
        if (sugGroup.size() > 0) {
            this.hide("AskSuggestion_Button");
            this.show("ApplySuggestion_Button");
            this.show("MoreSuggestion_Button");
            this.show("CancelSuggestion_Button");
        } else {
            this.show("NoSuggestions_Label");
            this.hide("ApplySuggestion_Button");
            this.hide("MoreSuggestion_Button");
            this.hide("CancelSuggestion_Button");
        }
    }

    public void hideSuggestions() {
        UIToggleButtonGroup sugGroup = (UIToggleButtonGroup)this.getComponent("Suggestions_Group");
        sugGroup.clear();
        this.show("AskSuggestion_Button");
        this.hide("NoSuggestions_Label");
        this.hide("ApplySuggestion_Button");
        this.hide("MoreSuggestion_Button");
        this.hide("CancelSuggestion_Button");
    }

    protected void showMap() {
        PImage mapImage = this.parent.showMap("suggestions_simple", this.gridSizeX, this.gridSizeY);
        UIImage c = (UIImage)this.getComponent("Suggestions_Canvas");
        c.setImage(mapImage, true);
    }

    protected void updateSketch() {
        this.parent.updateSketch();
        this.update();
    }

    @Override
    public void mouseMoved() {
        UILabel label1 = (UILabel)this.getComponent("Paint_Label");
        UILabel label2 = (UILabel)this.getComponent("Paint_Label2");
        UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("Paint_Group");
        boolean isOver = false;
        for (int i = 0; i < t.size(); ++i) {
            if (!t.getButton(i).isMouseOver()) continue;
            isOver = true;
            String[] caption = this.findPaintLabel(i);
            label1.setCaption(caption[0]);
            label2.setCaption(caption[1]);
        }
        if (!isOver) {
            String[] caption = this.findPaintLabel(t.getSelectedIndex());
            label1.setCaption(caption[0]);
            label2.setCaption(caption[1]);
        }
        this.mouseOverTile = this.gridMouseOverToDiscrete();
    }

    protected void updateComparisons(int selectedIndex) {
        StatsPanel sp = (StatsPanel)this.getComponent("StatsPanel");
        if (this.parent.suggestions.getSuggestions() == null) {
            return;
        }
        if (this.parent.evaluationScores == null) {
            this.parent.updateEvaluations();
        }
        if (selectedIndex == -1) {
            sp.updateComparisons(null, null);
        } else {
            double[] comparativeScores = new double[this.parent.evaluationSize];
            double[] fitnessScores = this.parent.suggestions.getFitnesses(selectedIndex);
            for (int i = 0; i < fitnessScores.length; ++i) {
                comparativeScores[i] = fitnessScores[i] - this.parent.evaluationScores[i];
            }
            sp.updateComparisons(this.parent.suggestions.getSuggestion(selectedIndex), comparativeScores);
        }
    }

    @Override
    public void draw() {
        Point2D tlc;
        UIImage c;
        super.draw();
        UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("Paint_Group");
        int index = t.getSelectedIndex();
        if (this.startTile != null) {
            c = (UIImage)this.getComponent("Suggestions_Canvas");
            tlc = c.getTopLeftCorner();
            this.p.stroke(40);
            this.p.strokeWeight(2.0f);
            this.p.noFill();
            if (this.mouseOverTile != null) {
                double sX = Math.min(this.startTile.x, this.mouseOverTile.x);
                double sY = Math.min(this.startTile.y, this.mouseOverTile.y);
                double eX = Math.max(this.startTile.x, this.mouseOverTile.x);
                double eY = Math.max(this.startTile.y, this.mouseOverTile.y);
                this.p.rect((float)(tlc.x + sX * (double)this.gridSizeX), (float)(tlc.y + sY * (double)this.gridSizeY), (float)((eX - sX + 1.0) * (double)this.gridSizeX), (float)((eY - sY + 1.0) * (double)this.gridSizeY));
            } else {
                this.p.rect((float)(tlc.x + this.startTile.x * (double)this.gridSizeX), (float)(tlc.y + this.startTile.y * (double)this.gridSizeY), this.gridSizeX, this.gridSizeY);
            }
            this.p.strokeWeight(1.0f);
            this.p.noStroke();
        }
        if (this.mouseOverTile != null) {
            c = (UIImage)this.getComponent("Suggestions_Canvas");
            tlc = c.getTopLeftCorner();
            this.p.stroke(0.0f, 255.0f, 0.0f);
            this.p.strokeWeight(2.0f);
            this.p.noFill();
            this.p.rect((float)(tlc.x + this.mouseOverTile.x * (double)this.gridSizeX), (float)(tlc.y + this.mouseOverTile.y * (double)this.gridSizeY), this.gridSizeX, this.gridSizeY);
            this.p.strokeWeight(1.0f);
            this.p.noStroke();
        }
    }

    protected Point2D gridContinuousToDiscrete(Point2D coords) {
        UIImage c = (UIImage)this.getComponent("Suggestions_Canvas");
        if (c == null || coords == null) {
            return null;
        }
        double d = coords.x;
        this.parent.getClass();
        int gridX = (int)Math.round(d * 8.0);
        double d2 = coords.y;
        this.parent.getClass();
        int gridY = (int)Math.round(d2 * 8.0);
        return new Point2D(gridX, gridY);
    }

    protected Point2D gridDiscreteToContinuous(Point2D coords) {
        UIImage c = (UIImage)this.getComponent("Suggestions_Canvas");
        if (c == null || coords == null) {
            return null;
        }
        double d = coords.x;
        this.parent.getClass();
        double localX = Math.max(0.0, Math.min(1.0, d / 8.0));
        double d2 = coords.y;
        this.parent.getClass();
        double localY = Math.max(0.0, Math.min(1.0, d2 / 8.0));
        return new Point2D(localX, localY);
    }

    protected Point2D gridMouseOverToDiscrete() {
        UIImage c = (UIImage)this.getComponent("Suggestions_Canvas");
        if (c == null || !c.isMouseOver()) {
            return null;
        }
        Point2D tlc = c.getTopLeftCorner();
        int gridX = (int)Math.floor(((double)this.p.mouseX - tlc.x) / (double)this.gridSizeX);
        int gridY = (int)Math.floor(((double)this.p.mouseY - tlc.y) / (double)this.gridSizeY);
        this.parent.getClass();
        gridX = Math.min(8 - 1, gridX);
        this.parent.getClass();
        gridY = Math.min(8 - 1, gridY);
        return new Point2D(gridX, gridY);
    }

    protected Point2D gridMouseOverToContinuous() {
        Point2D d = this.gridMouseOverToDiscrete();
        if (d == null) {
            return null;
        }
        return this.gridDiscreteToContinuous(d);
    }

    protected String[] findPaintLabel(int index) {
        String[] result = new String[]{"error"};
        if (index == 0) {
            result = new String[]{"Constraint:", "Clear"};
        } else if (index == 1) {
            result = new String[]{"Constraint:", "Unchanged tile"};
        } else if (index == 2) {
            result = new String[]{"Constraint:", "Randomize tile"};
        } else if (index == 3) {
            result = new String[]{"Constraint:", "Chokepoint"};
        } else if (index == 4) {
            result = new String[]{"Constraint:", "Deadend"};
        } else if (index == 5) {
            result = new String[]{"Constraint:", "Open Space"};
        } else if (index == 6) {
            result = new String[]{"Constraint:", "Unused Space"};
        } else if (index == 7) {
            result = new String[]{"Constraint:", "Safe Space"};
        } else if (index == 8) {
            result = new String[]{"Constraint:", "Unsafe Space"};
        }
        return result;
    }
}

