/*
 * Decompiled with CFR 0.152.
 */
package strategysketch.screens.threaded;

import java.io.File;
import java.util.Vector;
import processing.core.PImage;
import renderer.Render2D;
import strategymap.StrategySketch;
import strategymap.constraints.StrategyConstraints;
import strategymap.genetic.StrategySketchSuggestions;
import strategymap.genetic.fitness.FeasibleFitness;
import strategymap.visualization.MapVisualizer;
import strategysketch.screens.components.StatsPanel_Editor;
import strategysketch.screens.threaded.Screen_DetailedView;
import ui.BaseApplet;
import ui.components.UIButton;
import ui.components.UIImage;
import ui.components.UILabel;
import ui.components.UIToggleButtonGroup;
import ui.components.UIToggleButtonImage;
import ui.screens.Screen;
import util.math2d.Point2D;
import util.statics.LogManager;

public class Screen_Canvas
extends Screen {
    StrategySketch sketch;
    StrategyConstraints sketchConstraints;
    StrategySketchSuggestions suggestions;
    public final int mapSizeX;
    public final int mapSizeY;
    public final int evaluationSize = 6;
    double[] evaluationScores;
    static String filePath;
    Point2D mouseOverTile;
    Point2D startTile;
    final int imgSizeX = 512;
    final int imgSizeY = 512;
    final int suggestionSizeX = 96;
    final int suggestionSizeY = 96;
    int gridSizeX;
    int gridSizeY;
    final int suggestionsNumber = 12;
    int logCounter_clear = 0;
    int logCounter_suggestion = 0;
    int logCounter_export = 0;
    int logCounter_edit = 0;

    public Screen_Canvas(BaseApplet p, int mapSizeX, int mapSizeY, int minBases, int maxBases, int minResources, int maxResources) {
        super(p);
        this.mapSizeX = mapSizeX;
        this.mapSizeY = mapSizeY;
        filePath = this.findLogLocation();
        this.suggestions = new StrategySketchSuggestions();
        this.suggestions.initParameters(mapSizeX, mapSizeY, minBases, maxBases, minResources, maxResources);
        this.resetSketch();
        this.initialize();
        this.updateSketch();
        this.initLoggers();
        this.logEvent_MapChanged();
    }

    public PImage showMap(String label, int gridSizeX, int gridSizeY) {
        Render2D renderer = null;
        if (label.equalsIgnoreCase("suggestions_simple")) {
            renderer = MapVisualizer.renderThumbnail(this.p, this.sketch, this.mapSizeX * gridSizeX, this.mapSizeY * gridSizeY);
            renderer = MapVisualizer.renderTileConstraints(renderer, this.sketchConstraints);
        } else if (label.equalsIgnoreCase("editor_simple")) {
            renderer = MapVisualizer.renderThumbnail(this.p, this.sketch, this.mapSizeX * gridSizeX, this.mapSizeY * gridSizeY);
        } else if (label.equalsIgnoreCase("editor_navmesh")) {
            renderer = MapVisualizer.renderNavmeshThumbnail(this.p, this.sketch, this.mapSizeX * gridSizeX, this.mapSizeY * gridSizeY);
        } else if (label.equalsIgnoreCase("editor_allpaths")) {
            renderer = MapVisualizer.renderPathsThumbnail(this.p, this.sketch, this.mapSizeX * gridSizeX, this.mapSizeY * gridSizeY);
        } else if (label.equalsIgnoreCase("editor_chokepoints")) {
            renderer = MapVisualizer.renderChokePointThumbnail(this.p, this.sketch, this.mapSizeX * gridSizeX, this.mapSizeY * gridSizeY);
        } else if (label.equalsIgnoreCase("editor_resourcesafety")) {
            renderer = MapVisualizer.renderNearbyResourcesThumbnail(this.p, this.sketch, this.mapSizeX * gridSizeX, this.mapSizeY * gridSizeY);
        } else if (label.equalsIgnoreCase("editor_safearea")) {
            renderer = MapVisualizer.renderSafetyMatrix(this.p, this.sketch, this.mapSizeX * gridSizeX, this.mapSizeY * gridSizeY);
        } else if (label.equalsIgnoreCase("editor_unusedspace")) {
            renderer = MapVisualizer.renderUnusedSpaceThumbnail(this.p, this.sketch, this.mapSizeX * gridSizeX, this.mapSizeY * gridSizeY);
        } else if (label.equalsIgnoreCase("editor_segments")) {
            renderer = MapVisualizer.renderSegmentsThumbnail(this.p, this.sketch, this.mapSizeX * gridSizeX, this.mapSizeY * gridSizeY);
        } else if (label.equalsIgnoreCase("editor_safesegments")) {
            renderer = MapVisualizer.renderSafeSegmentsThumbnail(this.p, this.sketch, this.mapSizeX * gridSizeX, this.mapSizeY * gridSizeY);
        } else if (label.equalsIgnoreCase("editor_exploration")) {
            renderer = MapVisualizer.renderExplorationThumbnail(this.p, this.sketch, this.mapSizeX * gridSizeX, this.mapSizeY * gridSizeY);
        } else {
            LogManager.writeError("Error", this, "label for map visualization not found");
        }
        return renderer.getImage();
    }

    public void resetConstraints() {
        this.sketchConstraints = new StrategyConstraints(this.mapSizeX, this.mapSizeY);
    }

    public void resetSketch() {
        this.sketch = new StrategySketch(this.mapSizeX, this.mapSizeY);
        this.sketchConstraints = new StrategyConstraints(this.mapSizeX, this.mapSizeY);
    }

    public void updateSketch() {
        this.sketch.finalizeSketch();
        this.updateEvaluations();
        this.showSuggestions();
        this.update();
    }

    public void randomizeSketch() {
        this.sketch.randomizeChunks(this.mapSizeX * this.mapSizeY / 4);
        this.sketch.randomize(4, 6);
    }

    public void updateEvaluations() {
        this.evaluationScores = new double[6];
        for (int i = 0; i < this.evaluationScores.length; ++i) {
            FeasibleFitness fn = new FeasibleFitness(i);
            this.evaluationScores[i] = fn.evaluate(this.sketch);
        }
    }

    public void initializeTabs(Screen tab_screen) {
        UIToggleButtonGroup t = null;
        t = new UIToggleButtonGroup(this.p, this.p.width / 6, 15, this.p.width / 3, 30);
        t.setAllowUnselected(false);
        t.setOffset(0);
        t.addButton("Editor Tab");
        t.addButton("Suggestions Tab");
        t.addButton("Export Tab");
        for (int i = 0; i < t.size(); ++i) {
            t.getButton(i).setFont("Large", false);
            t.getButton(i).setHeight(30);
        }
        t.setSelectedIndex(0);
        tab_screen.addComponent("tabs_group", t);
    }

    protected void initialize() {
        this.resetStartTile();
        this.gridSizeX = 512 / this.mapSizeX;
        this.gridSizeY = 512 / this.mapSizeY;
        UIImage img = new UIImage(this.p, this.showMap("editor_simple", this.gridSizeX, this.gridSizeY), 0, 0);
        img.setPosition(img.getWidth() / 2 + 10, img.getHeight() / 2 + 90);
        this.addComponent("Canvas", img);
        int offset = 40;
        this.addComponent("Title", new UILabel(this.p, "Strategy Game Map Sketching", this.p.width / 2, offset + 20, "Huge"));
        this.addComponent("Back_Button", new UIButton(this.p, "Back", img.getPositionX() - img.getWidth() / 2 + 50, img.getPositionY() + img.getHeight() / 2 + 40, 80, 18, "Large"));
        this.addComponent("Export_Button", new UIButton(this.p, "Export", img.getPositionX() - img.getWidth() / 2 + 135, img.getPositionY() + img.getHeight() / 2 + 40, 75, 18, "Large"));
        this.addComponent("Reset_Button", new UIButton(this.p, "Clear Map", img.getPositionX() + img.getWidth() / 2 + 45, offset + 150, 75, 18, "Large"));
        UIToggleButtonGroup t = null;
        this.addComponent("ViewMode_Label", new UILabel(this.p, "Viewing Modes", img.getPositionX() + img.getWidth() / 2 + 57, offset + 205, "Large"));
        t = new UIToggleButtonGroup(this.p, img.getPositionX() + img.getWidth() / 2 + 50, offset + 225, 90, 20);
        t.setAllowUnselected(false);
        t.addButtonNextLine("Simple");
        t.addButton("Navmesh");
        t.addButtonNextLine("Resource Safety");
        t.addButton("Safe Area");
        t.addButtonNextLine("Unused Space");
        t.addButton("Segments");
        t.setSelectedIndex(0);
        this.addComponent("ViewingMode_Group", t);
        t = new UIToggleButtonGroup(this.p, img.getPositionX() + img.getWidth() / 2 + 25, offset + 75, 20, 20);
        t.setAllowUnselected(false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/passable.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/passable_rect.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/mineral.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/base.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/impassable.png", false);
        t.addButtonImage("resources/tilesets/simple/Paint_Group/impassable_rect.png", false);
        t.setSelectedIndex(0);
        for (int i = 0; i < t.size(); ++i) {
            ((UIToggleButtonImage)t.getButton(i)).setUseFrame(true);
        }
        this.addComponent("Paint_Group", t);
        String[] caption = this.findPaintLabel(t.getSelectedIndex());
        this.addComponent("Paint_Label", new UILabel(this.p, caption[0], img.getPositionX() + img.getWidth() / 2 + 75, offset + 100, "Large"));
        this.addComponent("Paint_Label2", new UILabel(this.p, caption[1], img.getPositionX() + img.getWidth() / 2 + 75, offset + 120, "Large"));
        this.addComponent("StatsPanel", new StatsPanel_Editor(this.p, img.getPositionX() + img.getWidth() / 2 + 25, offset + 320));
        t = new UIToggleButtonGroup(this.p, this.p.width - 144 - 10, 103, 96, 96);
        t.setAllowUnselected(true);
        t.setSelectedIndex(-1);
        this.addComponent("Suggestions_Group", t);
        this.addComponent("WaitSuggestion_Label", new UILabel(this.p, "Processing...", this.p.width - 144 - 10, 30, 96, 20, "Large"));
        this.addComponent("ApplySuggestion_Button", new UIButton(this.p, "Apply", this.p.width - 144 - 10, 30, 96, 20, "Large"));
        this.addComponent("MoreSuggestion_Button", new UIButton(this.p, "Retry", this.p.width - 48 - 5, 30, 96, 20, "Large"));
        this.hideSuggestions();
    }

    protected void resetStartTile() {
        this.startTile = null;
    }

    protected void setStartTile(int gridX, int gridY) {
        this.startTile = new Point2D(gridX, gridY);
    }

    @Override
    public void update() {
        super.update();
        StatsPanel_Editor sp = (StatsPanel_Editor)this.getComponent("StatsPanel");
        sp.updateEvaluations(this.sketch, this.evaluationScores);
        this.showMap();
    }

    @Override
    public void mouseClicked() {
        StrategySketch s;
        UIToggleButtonGroup sugGroup;
        super.mouseClicked();
        UIButton b = null;
        b = (UIButton)this.getComponent("Back_Button");
        if (b != null && b.getState() == UIButton.State.PRESSED) {
            this.logEvent_Interface("Back_Button Pressed");
            this.p.swapPreviousScreen();
        }
        if ((b = (UIButton)this.getComponent("Export_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.logEvent_Interface("Export_Button Pressed");
            this.logEvent_MapExported();
            this.p.swapScreen(new Screen_DetailedView(this.p, this.sketch));
        }
        if ((b = (UIButton)this.getComponent("Reset_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.logEvent_Interface("Reset_Button Pressed");
            this.logEvent_MapReset();
            this.resetSketch();
            this.updateSketch();
            this.showMap();
            this.logEvent_MapChanged();
        }
        if ((b = (UIButton)this.getComponent("Randomize_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.logEvent_Interface("Randomize_Button Pressed");
            this.randomizeSketch();
            this.updateSketch();
            this.showMap();
            this.logEvent_MapChanged();
        }
        if ((sugGroup = (UIToggleButtonGroup)this.getComponent("Suggestions_Group")) != null && sugGroup.isMouseOver()) {
            this.updateComparisons(sugGroup.getSelectedIndex());
        }
        if (sugGroup != null && sugGroup.getSelectedIndex() == -1) {
            this.hide("ApplySuggestion_Button");
        } else if (sugGroup != null && sugGroup.getSelectedIndex() != -1 && !this.suggestions.isTraining()) {
            this.show("ApplySuggestion_Button");
        }
        b = (UIButton)this.getComponent("ApplySuggestion_Button");
        if (b != null && b.getState() == UIButton.State.PRESSED && sugGroup.getSelectedIndex() != -1 && (s = this.suggestions.getSuggestion(sugGroup.getSelectedIndex())) != null) {
            this.logEvent_Interface("Apply Suggestion " + this.suggestions.getSuggestionLabel(sugGroup.getSelectedIndex()));
            this.logEvent_SuggestionAppliedBefore();
            this.logEvent_SuggestionAppliedIgnored(sugGroup.getSelectedIndex());
            this.sketch = s;
            this.updateSketch();
            this.updateComparisons(-1);
            this.showSuggestions();
            this.logEvent_SuggestionAppliedAfter();
            this.logEvent_MapChanged();
        }
        if ((b = (UIButton)this.getComponent("MoreSuggestion_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.logEvent_Interface("More Suggestions");
            this.showSuggestions();
            this.updateComparisons(-1);
        }
        UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("Paint_Group");
        UIImage c = (UIImage)this.getComponent("Canvas");
        if (c != null) {
            int index = t.getSelectedIndex();
            if (index != 1 && index != 5) {
                this.startTile = null;
            }
            if (c.isMouseOver()) {
                StrategySketch prevSketch = new StrategySketch(this.sketch);
                if (index == 0) {
                    this.sketch.setPassable((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                    this.sketch.removeBase((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                    this.sketch.removeResource((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                    this.logEvent_Interface("Canvas_Passable");
                } else if (index == 1) {
                    if (this.startTile == null) {
                        this.setStartTile((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                    } else {
                        int sX = (int)Math.min(this.startTile.x, this.mouseOverTile.x);
                        int sY = (int)Math.min(this.startTile.y, this.mouseOverTile.y);
                        int eX = (int)Math.max(this.startTile.x, this.mouseOverTile.x);
                        int eY = (int)Math.max(this.startTile.y, this.mouseOverTile.y);
                        for (int x = sX; x <= eX; ++x) {
                            for (int y = sY; y <= eY; ++y) {
                                this.sketch.setPassable(x, y);
                                this.sketch.removeBase(x, y);
                                this.sketch.removeResource(x, y);
                            }
                        }
                        this.resetStartTile();
                        this.logEvent_Interface("Canvas_Passable_Rect");
                    }
                } else if (index == 2) {
                    if (!this.sketch.isBase((int)this.mouseOverTile.x, (int)this.mouseOverTile.y) && !this.sketch.isResource((int)this.mouseOverTile.x, (int)this.mouseOverTile.y) && this.sketch.isPassable((int)this.mouseOverTile.x, (int)this.mouseOverTile.y)) {
                        this.sketch.addResource((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                        this.logEvent_Interface("Canvas_Resource");
                    }
                } else if (index == 3) {
                    if (!this.sketch.isBase((int)this.mouseOverTile.x, (int)this.mouseOverTile.y) && !this.sketch.isResource((int)this.mouseOverTile.x, (int)this.mouseOverTile.y) && this.sketch.isPassable((int)this.mouseOverTile.x, (int)this.mouseOverTile.y)) {
                        this.sketch.addBase((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                        this.logEvent_Interface("Canvas_Base");
                    }
                } else if (index == 4) {
                    if (!this.sketch.isBase((int)this.mouseOverTile.x, (int)this.mouseOverTile.y) && !this.sketch.isResource((int)this.mouseOverTile.x, (int)this.mouseOverTile.y)) {
                        this.sketch.setImpassable((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                        this.logEvent_Interface("Canvas_Impassable");
                    }
                } else if (index == 5) {
                    if (this.startTile == null) {
                        this.setStartTile((int)this.mouseOverTile.x, (int)this.mouseOverTile.y);
                    } else {
                        int sX = (int)Math.min(this.startTile.x, this.mouseOverTile.x);
                        int sY = (int)Math.min(this.startTile.y, this.mouseOverTile.y);
                        int eX = (int)Math.max(this.startTile.x, this.mouseOverTile.x);
                        int eY = (int)Math.max(this.startTile.y, this.mouseOverTile.y);
                        for (int x = sX; x <= eX; ++x) {
                            for (int y = sY; y <= eY; ++y) {
                                if (this.sketch.isBase(x, y) || this.sketch.isResource(x, y)) continue;
                                this.sketch.setImpassable(x, y);
                            }
                        }
                        this.resetStartTile();
                        this.logEvent_Interface("Canvas_Impassable_Rect");
                    }
                }
                if (this.startTile == null && this.sketch.getTileDifference(prevSketch) > 0) {
                    this.updateSketch();
                    this.logEvent_MapChanged();
                }
            }
        }
        this.showMap();
    }

    protected void showMap() {
        UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("ViewingMode_Group");
        PImage mapImage = this.showMap("editor_" + t.getSelectedCaption().replace(" ", ""), this.gridSizeX, this.gridSizeY);
        UIImage c = (UIImage)this.getComponent("Canvas");
        c.setImage(mapImage, true);
    }

    @Override
    public void mouseMoved() {
        UILabel label1 = (UILabel)this.getComponent("Paint_Label");
        UILabel label2 = (UILabel)this.getComponent("Paint_Label2");
        UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("Paint_Group");
        boolean isOver = false;
        for (int i = 0; i < t.size(); ++i) {
            if (!t.getButton(i).isMouseOver()) continue;
            isOver = true;
            String[] caption = this.findPaintLabel(i);
            label1.setCaption(caption[0]);
            label2.setCaption(caption[1]);
        }
        if (!isOver) {
            String[] caption = this.findPaintLabel(t.getSelectedIndex());
            label1.setCaption(caption[0]);
            label2.setCaption(caption[1]);
        }
        this.mouseOverTile = this.gridMouseOverToDiscrete();
    }

    @Override
    public void draw() {
        Point2D tlc;
        UIImage c;
        super.draw();
        if (this.startTile != null) {
            c = (UIImage)this.getComponent("Canvas");
            tlc = c.getTopLeftCorner();
            this.p.stroke(40);
            this.p.strokeWeight(2.0f);
            this.p.noFill();
            if (this.mouseOverTile != null) {
                double sX = Math.min(this.startTile.x, this.mouseOverTile.x);
                double sY = Math.min(this.startTile.y, this.mouseOverTile.y);
                double eX = Math.max(this.startTile.x, this.mouseOverTile.x);
                double eY = Math.max(this.startTile.y, this.mouseOverTile.y);
                this.p.rect((float)(tlc.x + sX * (double)this.gridSizeX), (float)(tlc.y + sY * (double)this.gridSizeY), (float)((eX - sX + 1.0) * (double)this.gridSizeX), (float)((eY - sY + 1.0) * (double)this.gridSizeY));
            } else {
                this.p.rect((float)(tlc.x + this.startTile.x * (double)this.gridSizeX), (float)(tlc.y + this.startTile.y * (double)this.gridSizeY), this.gridSizeX, this.gridSizeY);
            }
            this.p.strokeWeight(1.0f);
            this.p.noStroke();
        }
        if (this.mouseOverTile != null) {
            c = (UIImage)this.getComponent("Canvas");
            tlc = c.getTopLeftCorner();
            this.p.stroke(0.0f, 255.0f, 0.0f);
            this.p.strokeWeight(2.0f);
            this.p.noFill();
            this.p.rect((float)(tlc.x + this.mouseOverTile.x * (double)this.gridSizeX), (float)(tlc.y + this.mouseOverTile.y * (double)this.gridSizeY), this.gridSizeX, this.gridSizeY);
            this.p.strokeWeight(1.0f);
            this.p.noStroke();
        }
        if (this.suggestions != null && this.suggestions.updateTraining()) {
            this.hide("WaitSuggestion_Label");
            UIToggleButtonGroup sugGroup = (UIToggleButtonGroup)this.getComponent("Suggestions_Group");
            sugGroup.clear();
            int thumbNumber = Math.min(12, this.suggestions.size());
            for (int i = 0; i < thumbNumber; ++i) {
                if (i % 2 == 0) {
                    sugGroup.addButtonImageNextLine(MapVisualizer.renderThumbnail(this.p, this.suggestions.getSuggestion(i), 96, 96).getGraphics(), true);
                    continue;
                }
                sugGroup.addButtonImage(MapVisualizer.renderThumbnail(this.p, this.suggestions.getSuggestion(i), 96, 96).getGraphics(), true);
            }
            sugGroup.setSelectedIndex(-1);
            if (sugGroup.size() > 0) {
                this.show("ApplySuggestion_Button");
                this.show("MoreSuggestion_Button");
            } else {
                this.hide("ApplySuggestion_Button");
                this.hide("MoreSuggestion_Button");
            }
            this.updateComparisons(-1);
        }
        if (this.suggestions != null && this.suggestions.isTraining() && !this.suggestions.updateTraining()) {
            this.show("WaitSuggestion_Label");
        }
    }

    protected Point2D gridContinuousToDiscrete(Point2D coords) {
        UIImage c = (UIImage)this.getComponent("Canvas");
        if (c == null || coords == null) {
            return null;
        }
        int gridX = (int)Math.round(coords.x * (double)this.mapSizeX);
        int gridY = (int)Math.round(coords.y * (double)this.mapSizeY);
        return new Point2D(gridX, gridY);
    }

    protected Point2D gridDiscreteToContinuous(Point2D coords) {
        UIImage c = (UIImage)this.getComponent("Canvas");
        if (c == null || coords == null) {
            return null;
        }
        double localX = Math.max(0.0, Math.min(1.0, coords.x / (double)this.mapSizeX));
        double localY = Math.max(0.0, Math.min(1.0, coords.y / (double)this.mapSizeY));
        return new Point2D(localX, localY);
    }

    protected Point2D gridMouseOverToDiscrete() {
        UIImage c = (UIImage)this.getComponent("Canvas");
        if (c == null || !c.isMouseOver()) {
            return null;
        }
        Point2D tlc = c.getTopLeftCorner();
        int gridX = (int)Math.floor(((double)this.p.mouseX - tlc.x) / (double)this.gridSizeX);
        int gridY = (int)Math.floor(((double)this.p.mouseY - tlc.y) / (double)this.gridSizeY);
        gridX = Math.min(this.mapSizeX - 1, gridX);
        gridY = Math.min(this.mapSizeY - 1, gridY);
        return new Point2D(gridX, gridY);
    }

    protected Point2D gridMouseOverToContinuous() {
        Point2D d = this.gridMouseOverToDiscrete();
        if (d == null) {
            return null;
        }
        return this.gridDiscreteToContinuous(d);
    }

    protected String[] findPaintLabel(int index) {
        String[] result = new String[]{"error"};
        if (index == 0) {
            result = new String[]{"Erase", ""};
        } else if (index == 1) {
            result = new String[]{"Erase", "(Rectangle)"};
        } else if (index == 2) {
            result = new String[]{"Resource", ""};
        } else if (index == 3) {
            result = new String[]{"Player base", ""};
        } else if (index == 4) {
            result = new String[]{"Impassable region", ""};
        } else if (index == 5) {
            result = new String[]{"Impassable region", "(Rectangle)"};
        } else if (index == 6) {
            result = new String[]{"Constraint:", "Clear"};
        } else if (index == 7) {
            result = new String[]{"Constraint:", "Unchanged tile"};
        } else if (index == 8) {
            result = new String[]{"Constraint:", "Randomize tile"};
        } else if (index == 9) {
            result = new String[]{"Constraint:", "Chokepoint"};
        } else if (index == 10) {
            result = new String[]{"Constraint:", "Deadend"};
        } else if (index == 11) {
            result = new String[]{"Constraint:", "Open Space"};
        } else if (index == 12) {
            result = new String[]{"Constraint:", "Unused Space"};
        } else if (index == 13) {
            result = new String[]{"Constraint:", "Safe Space"};
        } else if (index == 14) {
            result = new String[]{"Constraint:", "Unsafe Space"};
        }
        return result;
    }

    protected void updateComparisons(int selectedIndex) {
        StatsPanel_Editor sp = (StatsPanel_Editor)this.getComponent("StatsPanel");
        this.hide("ApplySuggestion_Button");
        if (this.suggestions.getSuggestions() == null) {
            return;
        }
        if (this.evaluationScores == null) {
            this.updateEvaluations();
        }
        if (selectedIndex == -1) {
            sp.updateComparisons(null, null);
        } else {
            double[] comparativeScores = new double[6];
            double[] fitnessScores = this.suggestions.getFitnesses(selectedIndex);
            for (int i = 0; i < fitnessScores.length; ++i) {
                comparativeScores[i] = fitnessScores[i] - this.evaluationScores[i];
            }
            sp.updateComparisons(this.suggestions.getSuggestion(selectedIndex), comparativeScores);
        }
    }

    public void showSuggestions() {
        this.suggestions.customizeParameters(this.sketch.getBaseLength(), this.sketch.getResourceLength());
        this.suggestions.initCompositeTraining(this.sketch, this.sketchConstraints);
    }

    public void hideSuggestions() {
        UIToggleButtonGroup sugGroup = (UIToggleButtonGroup)this.getComponent("Suggestions_Group");
        sugGroup.clear();
        this.hide("ApplySuggestion_Button");
        this.hide("MoreSuggestion_Button");
    }

    protected void logEvent_MapReset() {
        LogManager.write("clear_dataBefore", this.logCounter_clear + ";" + this.writeLog(this.sketch));
        this.saveSketchThumb(filePath + "/clear_dataBefore" + this.logCounter_clear + ".png");
        ++this.logCounter_clear;
    }

    protected void logEvent_SuggestionAppliedBefore() {
        LogManager.write("suggestion_dataBefore", this.logCounter_suggestion + ";" + this.writeLog(this.sketch));
        this.saveSketchThumb(filePath + "/suggestion_dataBefore" + this.logCounter_suggestion + ".png");
    }

    protected void logEvent_SuggestionAppliedIgnored(int selectedIndex) {
        Vector<StrategySketch> ignoredSketches = new Vector<StrategySketch>();
        for (int i = 0; i < this.suggestions.size(); ++i) {
            if (i == selectedIndex) continue;
            StrategySketch temp = this.suggestions.getSuggestion(i);
            this.saveSketchThumb(temp, filePath + "/suggestion_dataIgnored" + this.logCounter_suggestion + "_" + i + ".png");
            ignoredSketches.add(temp);
        }
        LogManager.write("suggestion_dataIgnored", this.logCounter_suggestion + ";" + this.writeLog(ignoredSketches));
    }

    protected void logEvent_SuggestionAppliedAfter() {
        LogManager.write("suggestion_dataAfter", this.logCounter_suggestion + ";" + this.writeLog(this.sketch));
        this.saveSketchThumb(filePath + "/suggestion_dataAfter" + this.logCounter_suggestion + ".png");
        ++this.logCounter_suggestion;
    }

    protected void logEvent_MapExported() {
        LogManager.write("export_dataBefore", this.logCounter_edit + ";" + this.writeLog(this.sketch));
        this.saveSketchThumb(filePath + "/export_dataBefore" + this.logCounter_export + ".png");
        ++this.logCounter_export;
    }

    protected void logEvent_MapChanged() {
        LogManager.write("edit_dataAfter", this.logCounter_edit + ";" + this.writeLog(this.sketch));
        this.saveSketchThumb(filePath + "/edit_dataAfter" + this.logCounter_edit + ".png");
        ++this.logCounter_edit;
    }

    protected void logEvent_Interface(String text) {
        LogManager.write("interactionData", text);
    }

    protected void saveSketchThumb(String filename) {
        Render2D renderer = MapVisualizer.renderThumbnail(this.p, this.sketch, this.mapSizeX, this.mapSizeY);
        renderer.getImage().save(filename);
    }

    protected void saveSketchThumb(StrategySketch sketch, String filename) {
        Render2D renderer = MapVisualizer.renderThumbnail(this.p, sketch, this.mapSizeX, this.mapSizeY);
        renderer.getImage().save(filename);
    }

    protected String findLogLocation() {
        String baseFile = "./logs/";
        int result = 0;
        File fp = null;
        while ((fp = new File("./logs/" + ++result)).exists()) {
        }
        return "./logs/" + result;
    }

    protected void initLoggers() {
        filePath = this.findLogLocation();
        LogManager.reset();
        LogManager.addLogfile("clear_dataBefore", filePath + "/clear_dataBefore.csv");
        LogManager.addLogfile("suggestion_dataBefore", filePath + "/suggestion_dataBefore.csv");
        LogManager.addLogfile("suggestion_dataIgnored", filePath + "/suggestion_dataIgnored.csv");
        LogManager.addLogfile("suggestion_dataAfter", filePath + "/suggestion_dataAfter.csv");
        LogManager.addLogfile("export_dataBefore", filePath + "/export_dataBefore.csv");
        LogManager.addLogfile("edit_dataAfter", filePath + "/edit_dataAfter.csv");
        LogManager.addLogfile("interactionData", filePath + "/interactionData.txt");
        LogManager.write("clear_dataBefore", ";" + this.writeDataLabels());
        LogManager.write("suggestion_dataBefore", ";" + this.writeDataLabels());
        LogManager.write("suggestion_dataAfter", ";" + this.writeDataLabels());
        LogManager.write("suggestion_dataIgnored", ";" + this.writeDataLabels(12));
        LogManager.write("export_dataBefore", ";" + this.writeDataLabels());
        LogManager.write("edit_dataAfter", ";" + this.writeDataLabels());
    }

    protected String writeDataLabels() {
        String result = "";
        for (int i = 0; i < FeasibleFitness.labels.length; ++i) {
            result = result + "" + FeasibleFitness.labels[i] + ";";
        }
        result = result + "Bases;";
        result = result + "Resources;";
        result = result + "Used Space;";
        result = result + "Max Base Distance;";
        result = result + "Avg Base Distance;";
        result = result + "Min Base Distance;";
        result = result + "Choke Points;";
        result = result + "Dead Ends;";
        result = result + "Open Areas;";
        return result;
    }

    protected String writeDataLabels(int copies) {
        String result = "";
        for (int i = 0; i < copies; ++i) {
            result = result + this.writeDataLabels();
        }
        return result;
    }

    protected String writeLog(StrategySketch map) {
        String result = "";
        for (int i = 0; i < FeasibleFitness.labels.length; ++i) {
            FeasibleFitness smf = new FeasibleFitness(i);
            result = result + "" + smf.evaluate(map) + ";";
        }
        map.getMetrics().update();
        int[] otherData = map.getMetrics().getDataArray();
        for (int i = 0; i < otherData.length; ++i) {
            result = result + "" + otherData[i] + ";";
        }
        return result;
    }

    protected String writeLog(Vector<StrategySketch> maps) {
        String result = "";
        for (int i = 0; i < maps.size(); ++i) {
            result = result + "" + this.writeLog(maps.get(i));
        }
        return result;
    }
}

