/*
 * Decompiled with CFR 0.152.
 */
package strategysketch.screens.threaded;

import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import processing.core.PImage;
import renderer.Render2D;
import strategymap.DetailConverter;
import strategymap.StrategySketch;
import strategymap.genetic.StrategySketchGene;
import strategymap.genetic.StrategySketchGeneConverter;
import strategymap.visualization.Map3DVisualizer;
import strategymap.visualization.MapVisualizer;
import strategysketch.screens.threaded.Screen_Canvas;
import ui.BaseApplet;
import ui.components.UIButton;
import ui.components.UIImage;
import ui.components.UILabel;
import ui.components.UIToggleButtonGroup;
import ui.screens.Screen;
import util.collections.ParameterCollection;
import util.logs.Writer;
import util.math2d.Matrix2D;
import util.statics.LogManager;

public class Screen_DetailedView
extends Screen {
    final int imgSizeX = 512;
    final int imgSizeY = 512;
    public final int cellularSizeX = 10;
    public final int cellularSizeY = 10;
    int gridSizeX;
    int gridSizeY;
    StrategySketch sketch;
    HashMap<String, DetailConverter> converters;
    Vector<PImage> detailedViews;
    public static String sessionFile;

    public Screen_DetailedView(BaseApplet p, StrategySketch sketch) {
        super(p);
        this.sketch = sketch;
        this.converters = new HashMap();
        this.converters.put("classic", new DetailConverter(sketch, 10, 10));
        this.converters.put("waterworks", new DetailConverter(this.createWaterWorksSketch(), 10, 10));
        sessionFile = Screen_Canvas.filePath;
        this.remakeDetailedViews();
        this.initialize();
    }

    protected void initialize() {
        this.gridSizeX = 512 / this.sketch.getMapSizeX();
        this.gridSizeY = 512 / this.sketch.getMapSizeY();
        UIImage img = new UIImage(this.p, this.detailedViews.get(0), 0, 0);
        img.setPosition(img.getWidth() / 2 + 10, img.getHeight() / 2 + 90);
        this.addComponent("Canvas", img);
        int offset = 40;
        this.addComponent("Title", new UILabel(this.p, "Strategy Game Map Detailed View", this.p.width / 2, offset + 20, "Huge"));
        this.addComponent("ViewMode_Label", new UILabel(this.p, "Viewing Modes", img.getPositionX() + img.getWidth() / 2 + 57, offset + 205, "Large"));
        UIToggleButtonGroup t = new UIToggleButtonGroup(this.p, img.getPositionX() + img.getWidth() / 2 + 50, offset + 225, 90, 20);
        t.setAllowUnselected(false);
        t.addButton("Simple");
        t.addButtonNextLine("Heightmap");
        t.addButtonNextLine("Waterworks");
        t.addButtonNextLine("Dungeon");
        t.setSelectedIndex(0);
        this.addComponent("ViewingMode_Group", t);
        this.addComponent("Reset_Button", new UIButton(this.p, "Regenerate", img.getPositionX() + img.getWidth() / 2 + 57, offset + 155, "Large"));
        this.addComponent("Back_Button", new UIButton(this.p, "Back", img.getPositionX() - img.getWidth() / 2 + 50, img.getPositionY() + img.getHeight() / 2 + 40, "Large"));
        this.addComponent("ExportMap_Button", new UIButton(this.p, "Export Map", img.getPositionX() + img.getWidth() / 2 + 200, 400, "Large"));
        this.addComponent("ExportGene_Button", new UIButton(this.p, "Export Gene", img.getPositionX() + img.getWidth() / 2 + 300, 400, "Large"));
    }

    @Override
    public void mouseClicked() {
        super.mouseClicked();
        UIButton b = null;
        b = (UIButton)this.getComponent("Back_Button");
        if (b != null && b.getState() == UIButton.State.PRESSED) {
            this.p.swapPreviousScreen();
        }
        if ((b = (UIButton)this.getComponent("Reset_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.remakeDetailedViews();
            this.showMap();
        }
        if ((b = (UIButton)this.getComponent("IncSession_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            sessionFile = this.findLogLocation();
        }
        if ((b = (UIButton)this.getComponent("ExportMap_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            if (sessionFile == null) {
                sessionFile = this.findLogLocation();
            }
            UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("ViewingMode_Group");
            PImage mapImage = this.detailedViews.get(t.getSelectedIndex());
            mapImage.save(sessionFile + "/exportedMap.png");
        }
        if ((b = (UIButton)this.getComponent("ExportGene_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            if (sessionFile == null) {
                sessionFile = this.findLogLocation();
            }
            StrategySketchGene baseGene = StrategySketchGeneConverter.getGene(this.sketch, new ParameterCollection());
            Writer writer = new Writer(sessionFile + "/exportedGene.xml");
            writer.write(baseGene.toXML());
            writer.close();
        }
        if ((b = (UIButton)this.getComponent("3D_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            System.out.println("Generating 3D Map. Please be patient...");
            PImage heightImage = this.detailedViews.get(1);
            PImage alphaImage = this.detailedViews.get(4);
            heightImage.filter(11, 2.0f);
            alphaImage.filter(11, 2.0f);
            String resOutput = Matrix2D.print(this.converters.get("classic").getMap().getResourceArray());
            this.p.saveStrings("assets/Textures/Imported/resMatrix.dat", new String[]{resOutput});
            heightImage.resize(513, 513);
            alphaImage.resize(513, 513);
            heightImage.save("assets/Textures/Imported/heightImage.png");
            alphaImage.save("assets/Textures/Imported/alphaImage.png");
            try {
                Runtime.getRuntime().exec("java -jar ../Viewer_Strategy/dist/Viewer_Strategy.jar");
            }
            catch (Exception e) {
                LogManager.writeError("Error", this, e.getMessage());
            }
        }
        this.showMap();
    }

    @Override
    public void update() {
        this.remakeDetailedViews();
        this.showMap();
    }

    public void remakeDetailedViews() {
        this.detailedViews = new Vector();
        this.converters.get("classic").reset(this.sketch);
        this.converters.get("classic").generateMap();
        Render2D renderer = MapVisualizer.renderGradient(this.p, this.converters.get("classic"), 512, 512);
        this.detailedViews.add(renderer.getImage());
        renderer = Map3DVisualizer.renderHeightmap(this.p, this.converters.get("classic"), 512, 512);
        this.detailedViews.add(renderer.getImage());
        this.converters.get("waterworks").reset(this.createWaterWorksSketch());
        this.converters.get("waterworks").generateMap();
        renderer = MapVisualizer.renderWaterworks(this.p, this.sketch, this.converters.get("waterworks"), 512, 512);
        this.detailedViews.add(renderer.getImage());
        renderer = MapVisualizer.renderDungeon(this.p, this.sketch, 512, 512);
        this.detailedViews.add(renderer.getImage());
        renderer = Map3DVisualizer.renderTerrainAlpha(this.p, this.converters.get("classic"), 512, 512);
        this.detailedViews.add(renderer.getImage());
    }

    protected void showMap() {
        UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("ViewingMode_Group");
        PImage mapImage = this.detailedViews.get(t.getSelectedIndex());
        UIImage c = (UIImage)this.getComponent("Canvas");
        c.setImage(mapImage, true);
    }

    protected StrategySketch createWaterWorksSketch() {
        int i;
        StrategySketch wwSketch = new StrategySketch(this.sketch.getMapSizeX(), this.sketch.getMapSizeY());
        for (i = 0; i < this.sketch.getBaseLength(); ++i) {
            wwSketch.addBase((int)this.sketch.getBase((int)i).x, (int)this.sketch.getBase((int)i).y);
        }
        for (i = 0; i < this.sketch.getResourceLength(); ++i) {
            wwSketch.addResource((int)this.sketch.getResource((int)i).x, (int)this.sketch.getResource((int)i).y);
        }
        boolean[][] impassable = this.sketch.getImpassableArray();
        boolean[][] chokePoints = this.sketch.getPaths().getChokePoints();
        boolean[][] deadEnds = this.sketch.getPaths().getDeadEnds();
        for (int x = 0; x < this.sketch.getMapSizeX(); ++x) {
            for (int y = 0; y < this.sketch.getMapSizeY(); ++y) {
                if (impassable[x][y]) {
                    wwSketch.setImpassable(x, y);
                }
                if (!chokePoints[x][y] || this.sketch.isBase(x, y) || this.sketch.isResource(x, y) || deadEnds[x][y]) continue;
                wwSketch.setImpassable(x, y);
            }
        }
        return wwSketch;
    }

    protected String findLogLocation() {
        String baseFile = "./exportedMaps/";
        int result = 0;
        File fp = null;
        while ((fp = new File("./exportedMaps/" + ++result)).exists()) {
        }
        return "./exportedMaps/" + result;
    }
}

